/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.field;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.CacheKey;
import com.apollographql.apollo.cache.normalized.CacheKeyResolver;
import com.apollographql.apollo.cache.normalized.CacheReference;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.internal.cache.normalized.ReadableStore;
import com.apollographql.apollo.internal.field.FieldValueResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class CacheFieldValueResolver
implements FieldValueResolver<Record> {
    private final ReadableStore readableCache;
    private final Operation.Variables variables;
    private final CacheKeyResolver cacheKeyResolver;
    private final CacheHeaders cacheHeaders;
    private final Map<String, Object> variableValues;

    public CacheFieldValueResolver(ReadableStore readableCache, Operation.Variables variables, CacheKeyResolver cacheKeyResolver, CacheHeaders cacheHeaders) {
        this.readableCache = readableCache;
        this.variables = variables;
        this.cacheKeyResolver = cacheKeyResolver;
        this.cacheHeaders = cacheHeaders;
        this.variableValues = variables.valueMap();
    }

    @Override
    public <T> T valueFor(Record record, ResponseField field) {
        if (CacheFieldValueResolver.shouldSkip(field, this.variableValues)) {
            return null;
        }
        if (field.type() == ResponseField.Type.OBJECT) {
            return (T)this.valueForObject(record, field);
        }
        if (field.type() == ResponseField.Type.OBJECT_LIST) {
            return (T)this.valueForObjectList(record, field);
        }
        return this.fieldValue(record, field);
    }

    private Record valueForObject(Record record, ResponseField field) {
        CacheKey fieldCacheKey = this.cacheKeyResolver.fromFieldArguments(field, this.variables);
        CacheReference cacheReference = fieldCacheKey != CacheKey.NO_KEY ? new CacheReference(fieldCacheKey.key()) : (CacheReference)this.fieldValue(record, field);
        if (cacheReference != null) {
            Record referencedRecord = this.readableCache.read(cacheReference.key(), this.cacheHeaders);
            if (referencedRecord == null) {
                throw new IllegalStateException("Cache MISS: failed to find record in cache by reference");
            }
            return referencedRecord;
        }
        return null;
    }

    private List<Record> valueForObjectList(Record record, ResponseField field) {
        List values = (List)this.fieldValue(record, field);
        if (values == null) {
            return null;
        }
        ArrayList<Record> result = new ArrayList<Record>();
        for (CacheReference reference : values) {
            Record referencedRecord = this.readableCache.read(reference.key(), this.cacheHeaders);
            if (referencedRecord == null) {
                throw new IllegalStateException("Cache MISS: failed to find record in cache by reference");
            }
            result.add(referencedRecord);
        }
        return result;
    }

    private <T> T fieldValue(Record record, ResponseField field) {
        String fieldKey = field.cacheKey(this.variables);
        if (!record.hasField(fieldKey)) {
            throw new NullPointerException("Missing value: " + field.fieldName());
        }
        return (T)record.field(fieldKey);
    }

    private static boolean shouldSkip(ResponseField field, Map<String, Object> variableValues) {
        for (ResponseField.Condition condition : field.conditions()) {
            if (!(condition instanceof ResponseField.BooleanCondition)) continue;
            ResponseField.BooleanCondition booleanCondition = (ResponseField.BooleanCondition)condition;
            Boolean conditionValue = (Boolean)variableValues.get(booleanCondition.variableName());
            if (!(booleanCondition.inverted() ? conditionValue == Boolean.TRUE : conditionValue == Boolean.FALSE)) continue;
            return true;
        }
        return false;
    }
}

