/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.fetcher;

import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.util.ApolloLogger;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;

public final class CacheFirstFetcher
implements ResponseFetcher {
    @Override
    public ApolloInterceptor provideInterceptor(ApolloLogger apolloLogger) {
        return new CacheFirstInterceptor();
    }

    private static final class CacheFirstInterceptor
    implements ApolloInterceptor {
        private volatile boolean disposed;

        private CacheFirstInterceptor() {
        }

        @Override
        @Nonnull
        public ApolloInterceptor.InterceptorResponse intercept(@Nonnull ApolloInterceptor.InterceptorRequest request, @Nonnull ApolloInterceptorChain chain) throws ApolloException {
            ApolloInterceptor.InterceptorResponse response;
            if (this.disposed) {
                throw new ApolloCanceledException("Canceled");
            }
            ApolloInterceptor.InterceptorRequest cacheRequest = request.withFetchOptions(request.fetchOptions.toCacheFetchOptions());
            try {
                response = chain.proceed(cacheRequest);
            }
            catch (ApolloException exception) {
                ApolloInterceptor.InterceptorRequest networkRequest = request.withFetchOptions(request.fetchOptions.toNetworkFetchOptions());
                response = chain.proceed(networkRequest);
            }
            return response;
        }

        @Override
        public void interceptAsync(final @Nonnull ApolloInterceptor.InterceptorRequest request, final @Nonnull ApolloInterceptorChain chain, final @Nonnull ExecutorService dispatcher, final @Nonnull ApolloInterceptor.CallBack callBack) {
            ApolloInterceptor.InterceptorRequest cacheRequest = request.withFetchOptions(request.fetchOptions.toCacheFetchOptions());
            chain.proceedAsync(cacheRequest, dispatcher, new ApolloInterceptor.CallBack(){

                @Override
                public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                    callBack.onResponse(response);
                }

                @Override
                public void onFailure(@Nonnull ApolloException e) {
                    if (!CacheFirstInterceptor.this.disposed) {
                        ApolloInterceptor.InterceptorRequest networkRequest = request.withFetchOptions(request.fetchOptions.toNetworkFetchOptions());
                        chain.proceedAsync(networkRequest, dispatcher, callBack);
                    }
                }

                @Override
                public void onCompleted() {
                    callBack.onCompleted();
                }
            });
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }
    }
}

