/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.interceptor;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.interceptor.FetchOptions;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import okhttp3.Response;

public interface ApolloInterceptor {
    @Nonnull
    public InterceptorResponse intercept(@Nonnull InterceptorRequest var1, @Nonnull ApolloInterceptorChain var2) throws ApolloException;

    public void interceptAsync(@Nonnull InterceptorRequest var1, @Nonnull ApolloInterceptorChain var2, @Nonnull ExecutorService var3, @Nonnull CallBack var4);

    public void dispose();

    public static final class InterceptorRequest {
        public final UUID uniqueId = UUID.randomUUID();
        public final Operation operation;
        public final FetchOptions fetchOptions;
        public final Optional<Operation.Data> optimisticUpdates;

        public InterceptorRequest(@Nonnull Operation operation, @Nonnull FetchOptions fetchOptions, Optional<Operation.Data> optimisticUpdates) {
            this.operation = (Operation)Utils.checkNotNull((Object)operation, (Object)"operation == null");
            this.fetchOptions = (FetchOptions)Utils.checkNotNull((Object)fetchOptions, (Object)"fetchOptions == null");
            this.optimisticUpdates = optimisticUpdates;
        }

        public InterceptorRequest withFetchOptions(@Nonnull FetchOptions fetchOptions) {
            return new InterceptorRequest(this.operation, fetchOptions, this.optimisticUpdates);
        }
    }

    public static final class InterceptorResponse {
        public final Optional<Response> httpResponse;
        public final Optional<com.apollographql.apollo.api.Response> parsedResponse;
        public final Optional<Collection<Record>> cacheRecords;

        public InterceptorResponse(Response httpResponse) {
            this(httpResponse, null, null);
        }

        public InterceptorResponse(Response httpResponse, com.apollographql.apollo.api.Response parsedResponse, Collection<Record> cacheRecords) {
            this.httpResponse = Optional.fromNullable((Object)httpResponse);
            this.parsedResponse = Optional.fromNullable((Object)parsedResponse);
            this.cacheRecords = Optional.fromNullable(cacheRecords);
        }
    }

    public static interface CallBack {
        public void onResponse(@Nonnull InterceptorResponse var1);

        public void onFailure(@Nonnull ApolloException var1);

        public void onCompleted();
    }
}

