/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.http;

import com.apollographql.apollo.cache.http.HttpCacheRecord;
import com.apollographql.apollo.cache.http.HttpCacheRecordEditor;
import com.apollographql.apollo.cache.http.HttpCacheStore;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import okhttp3.internal.cache.DiskLruCache;
import okhttp3.internal.io.FileSystem;
import okio.Sink;
import okio.Source;

public final class DiskLruHttpCacheStore
implements HttpCacheStore {
    private static final int VERSION = 99991;
    private static final int ENTRY_HEADERS = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;
    private final DiskLruCache cache;

    public DiskLruHttpCacheStore(@Nonnull File directory, long maxSize) {
        this.cache = DiskLruCache.create((FileSystem)FileSystem.SYSTEM, (File)directory, (int)99991, (int)2, (long)maxSize);
    }

    public DiskLruHttpCacheStore(@Nonnull FileSystem fileSystem, @Nonnull File directory, long maxSize) {
        this.cache = DiskLruCache.create((FileSystem)fileSystem, (File)directory, (int)99991, (int)2, (long)maxSize);
    }

    @Override
    public HttpCacheRecord cacheRecord(@Nonnull String cacheKey) throws IOException {
        final DiskLruCache.Snapshot snapshot = this.cache.get(cacheKey);
        if (snapshot == null) {
            return null;
        }
        HttpCacheRecord responseCacheRecord = new HttpCacheRecord(){

            @Override
            @Nonnull
            public Source headerSource() {
                return snapshot.getSource(0);
            }

            @Override
            @Nonnull
            public Source bodySource() {
                return snapshot.getSource(1);
            }

            @Override
            public void close() {
                snapshot.close();
            }
        };
        return responseCacheRecord;
    }

    @Override
    public HttpCacheRecordEditor cacheRecordEditor(@Nonnull String cacheKey) throws IOException {
        final DiskLruCache.Editor editor = this.cache.edit(cacheKey);
        if (editor == null) {
            return null;
        }
        return new HttpCacheRecordEditor(){

            @Override
            @Nonnull
            public Sink headerSink() {
                return editor.newSink(0);
            }

            @Override
            @Nonnull
            public Sink bodySink() {
                return editor.newSink(1);
            }

            @Override
            public void abort() throws IOException {
                editor.abort();
            }

            @Override
            public void commit() throws IOException {
                editor.commit();
            }
        };
    }

    @Override
    public void delete() throws IOException {
        this.cache.delete();
    }

    @Override
    public void remove(@Nonnull String cacheKey) throws IOException {
        this.cache.remove(cacheKey);
    }
}

