/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo;

import com.apollographql.apollo.ApolloMutationCall;
import com.apollographql.apollo.ApolloPrefetch;
import com.apollographql.apollo.ApolloQueryCall;
import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.IdleResourceCallback;
import com.apollographql.apollo.Logger;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.http.HttpCache;
import com.apollographql.apollo.cache.http.HttpCacheInterceptor;
import com.apollographql.apollo.cache.http.HttpCachePolicy;
import com.apollographql.apollo.cache.http.HttpCacheStore;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.ApolloStoreOperation;
import com.apollographql.apollo.cache.normalized.CacheKeyResolver;
import com.apollographql.apollo.cache.normalized.NormalizedCache;
import com.apollographql.apollo.cache.normalized.NormalizedCacheFactory;
import com.apollographql.apollo.cache.normalized.RecordFieldJsonAdapter;
import com.apollographql.apollo.fetcher.ApolloResponseFetchers;
import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.internal.ApolloCallTracker;
import com.apollographql.apollo.internal.RealApolloCall;
import com.apollographql.apollo.internal.RealApolloPrefetch;
import com.apollographql.apollo.internal.ResponseFieldMapperFactory;
import com.apollographql.apollo.internal.cache.normalized.RealApolloStore;
import com.apollographql.apollo.internal.util.ApolloLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public final class ApolloClient
implements ApolloQueryCall.Factory,
ApolloMutationCall.Factory,
ApolloPrefetch.Factory {
    private final HttpUrl serverUrl;
    private final Call.Factory httpCallFactory;
    private final HttpCache httpCache;
    private final ApolloStore apolloStore;
    private final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;
    private final ResponseFieldMapperFactory responseFieldMapperFactory = new ResponseFieldMapperFactory();
    private final ExecutorService dispatcher;
    private final HttpCachePolicy.Policy defaultHttpCachePolicy;
    private final ResponseFetcher defaultResponseFetcher;
    private final CacheHeaders defaultCacheHeaders;
    private final ApolloLogger logger;
    private final ApolloCallTracker tracker = new ApolloCallTracker();
    private final List<ApolloInterceptor> applicationInterceptors;
    private final boolean sendOperationIdentifiers;

    public static Builder builder() {
        return new Builder();
    }

    private ApolloClient(HttpUrl serverUrl, Call.Factory httpCallFactory, HttpCache httpCache, ApolloStore apolloStore, Map<ScalarType, CustomTypeAdapter> customTypeAdapters, ExecutorService dispatcher, HttpCachePolicy.Policy defaultHttpCachePolicy, ResponseFetcher defaultResponseFetcher, CacheHeaders defaultCacheHeaders, ApolloLogger logger, List<ApolloInterceptor> applicationInterceptors, boolean sendOperationIdentifiers) {
        this.serverUrl = serverUrl;
        this.httpCallFactory = httpCallFactory;
        this.httpCache = httpCache;
        this.apolloStore = apolloStore;
        this.customTypeAdapters = customTypeAdapters;
        this.dispatcher = dispatcher;
        this.defaultHttpCachePolicy = defaultHttpCachePolicy;
        this.defaultResponseFetcher = defaultResponseFetcher;
        this.defaultCacheHeaders = defaultCacheHeaders;
        this.logger = logger;
        this.applicationInterceptors = applicationInterceptors;
        this.sendOperationIdentifiers = sendOperationIdentifiers;
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloMutationCall<T> mutate(@Nonnull Mutation<D, T, V> mutation) {
        return this.newCall((Operation<D, T, V>)mutation).responseFetcher(ApolloResponseFetchers.NETWORK_ONLY);
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloMutationCall<T> mutate(@Nonnull Mutation<D, T, V> mutation, @Nonnull D withOptimisticUpdates) {
        Utils.checkNotNull(withOptimisticUpdates, (Object)"withOptimisticUpdate == null");
        return this.newCall((Operation<D, T, V>)mutation).toBuilder().responseFetcher(ApolloResponseFetchers.NETWORK_ONLY).optimisticUpdates((Optional<Operation.Data>)Optional.fromNullable(withOptimisticUpdates)).build();
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloQueryCall<T> query(@Nonnull Query<D, T, V> query) {
        return this.newCall((Operation<D, T, V>)query);
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloPrefetch prefetch(@Nonnull Operation<D, T, V> operation) {
        return new RealApolloPrefetch(operation, this.serverUrl, this.httpCallFactory, this.httpCache, this.customTypeAdapters, this.dispatcher, this.logger, this.tracker, this.sendOperationIdentifiers);
    }

    public CacheHeaders defaultCacheHeaders() {
        return this.defaultCacheHeaders;
    }

    public void clearHttpCache() {
        if (this.httpCache != null) {
            this.httpCache.clear();
        }
    }

    @Nonnull
    public ApolloStoreOperation<Boolean> clearNormalizedCache() {
        return this.apolloStore.clearAll();
    }

    public ApolloStore apolloStore() {
        return this.apolloStore;
    }

    public void idleCallback(IdleResourceCallback idleResourceCallback) {
        this.tracker.setIdleResourceCallback(idleResourceCallback);
    }

    public int activeCallsCount() {
        return this.tracker.activeCallsCount();
    }

    Response cachedHttpResponse(String cacheKey) throws IOException {
        if (this.httpCache != null) {
            return this.httpCache.read(cacheKey);
        }
        return null;
    }

    private <D extends Operation.Data, T, V extends Operation.Variables> RealApolloCall<T> newCall(@Nonnull Operation<D, T, V> operation) {
        return RealApolloCall.builder().operation(operation).serverUrl(this.serverUrl).httpCallFactory(this.httpCallFactory).httpCache(this.httpCache).httpCachePolicy(this.defaultHttpCachePolicy).responseFieldMapperFactory(this.responseFieldMapperFactory).customTypeAdapters(this.customTypeAdapters).apolloStore(this.apolloStore).responseFetcher(this.defaultResponseFetcher).cacheHeaders(this.defaultCacheHeaders).dispatcher(this.dispatcher).logger(this.logger).applicationInterceptors(this.applicationInterceptors).tracker(this.tracker).refetchQueries(Collections.emptyList()).refetchQueryNames(Collections.emptyList()).sendOperationIdentifiers(this.sendOperationIdentifiers).build();
    }

    public static class Builder {
        Call.Factory callFactory;
        HttpUrl serverUrl;
        HttpCacheStore httpCacheStore;
        ApolloStore apolloStore = ApolloStore.NO_APOLLO_STORE;
        Optional<NormalizedCacheFactory> cacheFactory = Optional.absent();
        Optional<CacheKeyResolver> cacheKeyResolver = Optional.absent();
        HttpCachePolicy.Policy defaultHttpCachePolicy = HttpCachePolicy.NETWORK_ONLY;
        ResponseFetcher defaultResponseFetcher = ApolloResponseFetchers.CACHE_FIRST;
        CacheHeaders defaultCacheHeaders = CacheHeaders.NONE;
        final Map<ScalarType, CustomTypeAdapter> customTypeAdapters = new LinkedHashMap<ScalarType, CustomTypeAdapter>();
        ExecutorService dispatcher;
        Optional<Logger> logger = Optional.absent();
        final List<ApolloInterceptor> applicationInterceptors = new ArrayList<ApolloInterceptor>();
        boolean sendOperationIdentifiers;

        private Builder() {
        }

        public Builder okHttpClient(@Nonnull OkHttpClient okHttpClient) {
            return this.callFactory((Call.Factory)Utils.checkNotNull((Object)okHttpClient, (Object)"okHttpClient is null"));
        }

        public Builder callFactory(@Nonnull Call.Factory factory) {
            this.callFactory = (Call.Factory)Utils.checkNotNull((Object)factory, (Object)"factory == null");
            return this;
        }

        public Builder serverUrl(@Nonnull HttpUrl serverUrl) {
            this.serverUrl = (HttpUrl)Utils.checkNotNull((Object)serverUrl, (Object)"serverUrl is null");
            return this;
        }

        public Builder serverUrl(@Nonnull String serverUrl) {
            this.serverUrl = HttpUrl.parse((String)((String)Utils.checkNotNull((Object)serverUrl, (Object)"serverUrl == null")));
            return this;
        }

        public Builder httpCacheStore(@Nonnull HttpCacheStore cacheStore) {
            this.httpCacheStore = (HttpCacheStore)Utils.checkNotNull((Object)cacheStore, (Object)"cacheStore == null");
            return this;
        }

        public Builder normalizedCache(@Nonnull NormalizedCacheFactory normalizedCacheFactory) {
            return this.normalizedCache(normalizedCacheFactory, CacheKeyResolver.DEFAULT);
        }

        public Builder normalizedCache(@Nonnull NormalizedCacheFactory normalizedCacheFactory, @Nonnull CacheKeyResolver keyResolver) {
            this.cacheFactory = Optional.fromNullable((Object)Utils.checkNotNull((Object)normalizedCacheFactory, (Object)"normalizedCacheFactory == null"));
            this.cacheKeyResolver = Optional.fromNullable((Object)Utils.checkNotNull((Object)keyResolver, (Object)"cacheKeyResolver == null"));
            return this;
        }

        public <T> Builder addCustomTypeAdapter(@Nonnull ScalarType scalarType, @Nonnull CustomTypeAdapter<T> customTypeAdapter) {
            this.customTypeAdapters.put(scalarType, customTypeAdapter);
            return this;
        }

        public Builder dispatcher(@Nonnull ExecutorService dispatcher) {
            this.dispatcher = (ExecutorService)Utils.checkNotNull((Object)dispatcher, (Object)"dispatcher == null");
            return this;
        }

        public Builder defaultHttpCachePolicy(@Nonnull HttpCachePolicy.Policy cachePolicy) {
            this.defaultHttpCachePolicy = (HttpCachePolicy.Policy)Utils.checkNotNull((Object)cachePolicy, (Object)"cachePolicy == null");
            return this;
        }

        public Builder defaultCacheHeaders(@Nonnull CacheHeaders cacheHeaders) {
            this.defaultCacheHeaders = (CacheHeaders)Utils.checkNotNull((Object)cacheHeaders, (Object)"cacheHeaders == null");
            return this;
        }

        public Builder defaultResponseFetcher(@Nonnull ResponseFetcher defaultResponseFetcher) {
            this.defaultResponseFetcher = (ResponseFetcher)Utils.checkNotNull((Object)defaultResponseFetcher, (Object)"defaultResponseFetcher == null");
            return this;
        }

        public Builder logger(@Nullable Logger logger) {
            this.logger = Optional.fromNullable((Object)logger);
            return this;
        }

        public Builder addApplicationInterceptor(@Nonnull ApolloInterceptor interceptor) {
            this.applicationInterceptors.add(interceptor);
            return this;
        }

        public Builder sendOperationIdentifiers(boolean sendOperationIdentifiers) {
            this.sendOperationIdentifiers = sendOperationIdentifiers;
            return this;
        }

        public ApolloClient build() {
            ExecutorService dispatcher;
            boolean localClient;
            Utils.checkNotNull((Object)this.serverUrl, (Object)"serverUrl is null");
            ApolloLogger apolloLogger = new ApolloLogger(this.logger);
            Call.Factory callFactory = this.callFactory;
            boolean bl = localClient = this.callFactory == null;
            if (localClient) {
                callFactory = new OkHttpClient();
            }
            HttpCache httpCache = null;
            if (this.httpCacheStore != null) {
                httpCache = new HttpCache(this.httpCacheStore, apolloLogger);
                if (localClient || Builder.shouldAddHttpCacheInterceptor(callFactory)) {
                    apolloLogger.w("Created local client, adding passed in HttpCache", new Object[0]);
                    callFactory = ((OkHttpClient)callFactory).newBuilder().addInterceptor(httpCache.interceptor()).build();
                }
            }
            if ((dispatcher = this.dispatcher) == null) {
                dispatcher = this.defaultDispatcher();
            }
            ApolloStore apolloStore = this.apolloStore;
            if (this.cacheFactory.isPresent() && this.cacheKeyResolver.isPresent()) {
                NormalizedCache normalizedCache = ((NormalizedCacheFactory)this.cacheFactory.get()).createChain(RecordFieldJsonAdapter.create());
                apolloStore = new RealApolloStore(normalizedCache, (CacheKeyResolver)this.cacheKeyResolver.get(), this.customTypeAdapters, dispatcher, apolloLogger);
            }
            return new ApolloClient(this.serverUrl, callFactory, httpCache, apolloStore, this.customTypeAdapters, dispatcher, this.defaultHttpCachePolicy, this.defaultResponseFetcher, this.defaultCacheHeaders, apolloLogger, this.applicationInterceptors, this.sendOperationIdentifiers);
        }

        private ExecutorService defaultDispatcher() {
            return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

                @Override
                public Thread newThread(@Nonnull Runnable runnable) {
                    return new Thread(runnable, "Apollo Dispatcher");
                }
            });
        }

        private static boolean shouldAddHttpCacheInterceptor(Call.Factory callFactory) {
            if (callFactory instanceof OkHttpClient) {
                OkHttpClient client = (OkHttpClient)callFactory;
                for (Interceptor interceptor : client.interceptors()) {
                    if (!(interceptor instanceof HttpCacheInterceptor)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

