/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.interceptor.FetchOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;

public final class RealApolloInterceptorChain
implements ApolloInterceptorChain {
    private final Operation operation;
    private final List<ApolloInterceptor> interceptors;
    private final int interceptorIndex;

    public RealApolloInterceptorChain(@Nonnull Operation operation, @Nonnull List<ApolloInterceptor> interceptors) {
        this(operation, interceptors, 0);
    }

    private RealApolloInterceptorChain(Operation operation, List<ApolloInterceptor> interceptors, int interceptorIndex) {
        if (interceptorIndex > interceptors.size()) {
            throw new IllegalArgumentException();
        }
        this.operation = (Operation)Utils.checkNotNull((Object)operation, (Object)"operation == null");
        this.interceptors = new ArrayList<ApolloInterceptor>((Collection)Utils.checkNotNull(interceptors, (Object)"interceptors == null"));
        this.interceptorIndex = interceptorIndex;
    }

    @Override
    @Nonnull
    public ApolloInterceptor.InterceptorResponse proceed(@Nonnull FetchOptions fetchOptions) throws ApolloException {
        if (this.interceptorIndex >= this.interceptors.size()) {
            throw new IllegalStateException();
        }
        return this.interceptors.get(this.interceptorIndex).intercept(this.operation, new RealApolloInterceptorChain(this.operation, this.interceptors, this.interceptorIndex + 1), fetchOptions);
    }

    @Override
    public void proceedAsync(@Nonnull ExecutorService dispatcher, @Nonnull FetchOptions fetchOptions, @Nonnull ApolloInterceptor.CallBack callBack) {
        if (this.interceptorIndex >= this.interceptors.size()) {
            throw new IllegalStateException();
        }
        this.interceptors.get(this.interceptorIndex).interceptAsync(this.operation, new RealApolloInterceptorChain(this.operation, this.interceptors, this.interceptorIndex + 1), dispatcher, fetchOptions, callBack);
    }

    @Override
    public void dispose() {
        for (ApolloInterceptor interceptor : this.interceptors) {
            interceptor.dispose();
        }
    }
}

