/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.fetcher;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.interceptor.FetchOptions;
import com.apollographql.apollo.internal.util.ApolloLogger;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;

public final class CacheAndNetworkFetcher
implements ResponseFetcher {
    @Override
    public ApolloInterceptor provideInterceptor(ApolloLogger apolloLogger) {
        return new CacheAndNetworkInterceptor();
    }

    private static final class CacheAndNetworkInterceptor
    implements ApolloInterceptor {
        private Optional<ApolloInterceptor.InterceptorResponse> cacheResponse = Optional.absent();
        private Optional<ApolloInterceptor.InterceptorResponse> networkResponse = Optional.absent();
        private Optional<ApolloException> cacheException = Optional.absent();
        private Optional<ApolloException> networkException = Optional.absent();
        private boolean dispatchedCacheResult;
        private ApolloInterceptor.CallBack originalCallback;
        private volatile boolean disposed;

        private CacheAndNetworkInterceptor() {
        }

        @Override
        @Nonnull
        public ApolloInterceptor.InterceptorResponse intercept(@Nonnull Operation operation, @Nonnull ApolloInterceptorChain chain, @Nonnull FetchOptions options) throws ApolloException {
            throw new IllegalStateException(CacheAndNetworkFetcher.class.getSimpleName() + "Can only be used asynchronously");
        }

        @Override
        public void interceptAsync(@Nonnull Operation operation, @Nonnull ApolloInterceptorChain chain, @Nonnull ExecutorService dispatcher, @Nonnull FetchOptions options, @Nonnull ApolloInterceptor.CallBack callBack) {
            if (this.disposed) {
                return;
            }
            this.originalCallback = callBack;
            chain.proceedAsync(dispatcher, options.toCacheFetchOptions(), new ApolloInterceptor.CallBack(){

                @Override
                public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                    CacheAndNetworkInterceptor.this.handleCacheResponse(response);
                }

                @Override
                public void onFailure(@Nonnull ApolloException e) {
                    CacheAndNetworkInterceptor.this.handleCacheError(e);
                }

                @Override
                public void onCompleted() {
                }
            });
            chain.proceedAsync(dispatcher, options.toNetworkFetchOptions(), new ApolloInterceptor.CallBack(){

                @Override
                public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                    CacheAndNetworkInterceptor.this.handleNetworkResponse(response);
                }

                @Override
                public void onFailure(@Nonnull ApolloException e) {
                    CacheAndNetworkInterceptor.this.handleNetworkError(e);
                }

                @Override
                public void onCompleted() {
                }
            });
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }

        private synchronized void handleNetworkResponse(ApolloInterceptor.InterceptorResponse response) {
            this.networkResponse = Optional.of((Object)response);
            this.dispatch();
        }

        private synchronized void handleNetworkError(ApolloException exception) {
            this.networkException = Optional.of((Object)exception);
            this.dispatch();
        }

        private synchronized void handleCacheResponse(ApolloInterceptor.InterceptorResponse response) {
            this.cacheResponse = Optional.of((Object)response);
            this.dispatch();
        }

        private synchronized void handleCacheError(ApolloException exception) {
            this.cacheException = Optional.of((Object)exception);
            this.dispatch();
        }

        private synchronized void dispatch() {
            if (this.disposed) {
                return;
            }
            if (!this.dispatchedCacheResult) {
                if (this.cacheResponse.isPresent()) {
                    this.originalCallback.onResponse((ApolloInterceptor.InterceptorResponse)this.cacheResponse.get());
                    this.dispatchedCacheResult = true;
                } else if (this.cacheException.isPresent()) {
                    this.dispatchedCacheResult = true;
                }
            }
            if (this.dispatchedCacheResult) {
                if (this.networkResponse.isPresent()) {
                    this.originalCallback.onResponse((ApolloInterceptor.InterceptorResponse)this.networkResponse.get());
                    this.originalCallback.onCompleted();
                } else if (this.networkException.isPresent()) {
                    if (this.cacheException.isPresent()) {
                        this.originalCallback.onFailure((ApolloException)this.networkException.get());
                    } else {
                        this.originalCallback.onCompleted();
                    }
                }
            }
        }
    }
}

