/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.apollographql.apollo.ApolloPrefetch;
import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.cache.http.HttpCache;
import com.apollographql.apollo.cache.http.HttpCachePolicy;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.interceptor.FetchOptions;
import com.apollographql.apollo.internal.ApolloCallTracker;
import com.apollographql.apollo.internal.CallState;
import com.apollographql.apollo.internal.interceptor.ApolloServerInterceptor;
import com.apollographql.apollo.internal.interceptor.RealApolloInterceptorChain;
import com.apollographql.apollo.internal.util.ApolloLogger;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Response;

public final class RealApolloPrefetch
implements ApolloPrefetch {
    final Operation operation;
    final HttpUrl serverUrl;
    final Call.Factory httpCallFactory;
    final HttpCache httpCache;
    final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;
    final ExecutorService dispatcher;
    final ApolloLogger logger;
    final ApolloCallTracker tracker;
    final ApolloInterceptorChain interceptorChain;
    final boolean sendOperationIds;
    final AtomicReference<CallState> state = new AtomicReference<CallState>(CallState.IDLE);
    final AtomicReference<ApolloPrefetch.Callback> originalCallback = new AtomicReference();

    public RealApolloPrefetch(Operation operation, HttpUrl serverUrl, Call.Factory httpCallFactory, HttpCache httpCache, Map<ScalarType, CustomTypeAdapter> customTypeAdapters, ExecutorService dispatcher, ApolloLogger logger, ApolloCallTracker callTracker, boolean sendOperationIds) {
        this.operation = operation;
        this.serverUrl = serverUrl;
        this.httpCallFactory = httpCallFactory;
        this.httpCache = httpCache;
        this.customTypeAdapters = customTypeAdapters;
        this.dispatcher = dispatcher;
        this.logger = logger;
        this.tracker = callTracker;
        this.sendOperationIds = sendOperationIds;
        this.interceptorChain = new RealApolloInterceptorChain(operation, Collections.singletonList(new ApolloServerInterceptor(serverUrl, httpCallFactory, HttpCachePolicy.NETWORK_ONLY, true, customTypeAdapters, logger, sendOperationIds)));
    }

    @Override
    public void execute() throws ApolloException {
        Response httpResponse;
        this.activate((Optional<ApolloPrefetch.Callback>)Optional.absent());
        try {
            httpResponse = (Response)this.interceptorChain.proceed((FetchOptions)FetchOptions.NETWORK_ONLY).httpResponse.get();
        }
        catch (Exception e) {
            if (this.state.get() == CallState.CANCELED) {
                throw new ApolloCanceledException("Call canceled", e);
            }
            throw e;
        }
        finally {
            this.terminate();
        }
        httpResponse.close();
        if (!httpResponse.isSuccessful()) {
            throw new ApolloHttpException(httpResponse);
        }
    }

    @Override
    public void enqueue(@Nullable ApolloPrefetch.Callback responseCallback) {
        try {
            this.activate((Optional<ApolloPrefetch.Callback>)Optional.fromNullable((Object)responseCallback));
        }
        catch (ApolloCanceledException e) {
            if (responseCallback != null) {
                responseCallback.onFailure(e);
            } else {
                this.logger.e(e, "Operation: %s was canceled", this.operation().name().name());
            }
            return;
        }
        this.interceptorChain.proceedAsync(this.dispatcher, FetchOptions.NETWORK_ONLY, this.interceptorCallbackProxy());
    }

    @Override
    @Nonnull
    public Operation operation() {
        return this.operation;
    }

    private ApolloInterceptor.CallBack interceptorCallbackProxy() {
        return new ApolloInterceptor.CallBack(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                try (Response httpResponse = (Response)response.httpResponse.get();){
                    Optional callback = RealApolloPrefetch.this.terminate();
                    if (!callback.isPresent()) {
                        RealApolloPrefetch.this.logger.d("onResponse for prefetch operation: %s. No callback present.", RealApolloPrefetch.this.operation().name().name());
                        return;
                    }
                    if (httpResponse.isSuccessful()) {
                        ((ApolloPrefetch.Callback)callback.get()).onSuccess();
                    } else {
                        ((ApolloPrefetch.Callback)callback.get()).onHttpError(new ApolloHttpException(httpResponse));
                    }
                }
            }

            @Override
            public void onFailure(@Nonnull ApolloException e) {
                Optional callback = RealApolloPrefetch.this.terminate();
                if (!callback.isPresent()) {
                    RealApolloPrefetch.this.logger.e(e, "onFailure for prefetch operation: %s. No callback present.", RealApolloPrefetch.this.operation().name().name());
                    return;
                }
                if (e instanceof ApolloHttpException) {
                    ((ApolloPrefetch.Callback)callback.get()).onHttpError((ApolloHttpException)e);
                } else if (e instanceof ApolloNetworkException) {
                    ((ApolloPrefetch.Callback)callback.get()).onNetworkError((ApolloNetworkException)e);
                } else {
                    ((ApolloPrefetch.Callback)callback.get()).onFailure(e);
                }
            }

            @Override
            public void onCompleted() {
            }
        };
    }

    @Override
    public ApolloPrefetch clone() {
        return new RealApolloPrefetch(this.operation, this.serverUrl, this.httpCallFactory, this.httpCache, this.customTypeAdapters, this.dispatcher, this.logger, this.tracker, this.sendOperationIds);
    }

    @Override
    public synchronized void cancel() {
        switch (this.state.get()) {
            case ACTIVE: {
                try {
                    this.interceptorChain.dispose();
                    break;
                }
                finally {
                    this.tracker.unregisterPrefetchCall(this);
                    this.originalCallback.set(null);
                    this.state.set(CallState.CANCELED);
                }
            }
            case IDLE: {
                this.state.set(CallState.CANCELED);
                break;
            }
            case CANCELED: 
            case TERMINATED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.state.get() == CallState.CANCELED;
    }

    private synchronized void activate(Optional<ApolloPrefetch.Callback> callback) throws ApolloCanceledException {
        switch (this.state.get()) {
            case IDLE: {
                this.originalCallback.set((ApolloPrefetch.Callback)callback.orNull());
                this.tracker.registerPrefetchCall(this);
                break;
            }
            case CANCELED: {
                throw new ApolloCanceledException("Call is cancelled.");
            }
            case ACTIVE: 
            case TERMINATED: {
                throw new IllegalStateException("Already Executed");
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
        this.state.set(CallState.ACTIVE);
    }

    private synchronized Optional<ApolloPrefetch.Callback> terminate() {
        switch (this.state.get()) {
            case ACTIVE: {
                this.tracker.unregisterPrefetchCall(this);
                this.state.set(CallState.TERMINATED);
                return Optional.fromNullable(this.originalCallback.getAndSet(null));
            }
            case CANCELED: {
                return Optional.fromNullable(this.originalCallback.getAndSet(null));
            }
            case IDLE: 
            case TERMINATED: {
                throw new IllegalStateException(CallState.IllegalStateMessage.forCurrentState(this.state.get()).expected(CallState.ACTIVE, CallState.CANCELED));
            }
        }
        throw new IllegalStateException("Unknown state");
    }
}

