/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.interceptor;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.interceptor.FetchOptions;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import okhttp3.Response;

public interface ApolloInterceptor {
    @Nonnull
    public InterceptorResponse intercept(@Nonnull Operation var1, @Nonnull ApolloInterceptorChain var2, @Nonnull FetchOptions var3) throws ApolloException;

    public void interceptAsync(@Nonnull Operation var1, @Nonnull ApolloInterceptorChain var2, @Nonnull ExecutorService var3, @Nonnull FetchOptions var4, @Nonnull CallBack var5);

    public void dispose();

    public static final class InterceptorResponse {
        public final Optional<Response> httpResponse;
        public final Optional<com.apollographql.apollo.api.Response> parsedResponse;
        public final Optional<Collection<Record>> cacheRecords;

        public InterceptorResponse(Response httpResponse) {
            this(httpResponse, null, null);
        }

        public InterceptorResponse(Response httpResponse, com.apollographql.apollo.api.Response parsedResponse, Collection<Record> cacheRecords) {
            this.httpResponse = Optional.fromNullable((Object)httpResponse);
            this.parsedResponse = Optional.fromNullable((Object)parsedResponse);
            this.cacheRecords = Optional.fromNullable(cacheRecords);
        }
    }

    public static interface CallBack {
        public void onResponse(@Nonnull InterceptorResponse var1);

        public void onFailure(@Nonnull ApolloException var1);

        public void onCompleted();
    }
}

