/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.http;

import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.internal.cache.http.HttpCacheFetchStrategy;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public final class HttpCachePolicy {
    public static final ExpirePolicy CACHE_ONLY = new ExpirePolicy(HttpCacheFetchStrategy.CACHE_ONLY);
    public static final Policy NETWORK_ONLY = new Policy(HttpCacheFetchStrategy.NETWORK_ONLY, 0L, null, false);
    public static final ExpirePolicy CACHE_FIRST = new ExpirePolicy(HttpCacheFetchStrategy.CACHE_FIRST);
    public static final ExpirePolicy NETWORK_FIRST = new ExpirePolicy(HttpCacheFetchStrategy.NETWORK_FIRST);

    private HttpCachePolicy() {
    }

    public static final class ExpirePolicy
    extends Policy {
        ExpirePolicy(HttpCacheFetchStrategy fetchStrategy) {
            super(fetchStrategy, 0L, null, false);
        }

        private ExpirePolicy(HttpCacheFetchStrategy fetchStrategy, long expireTimeout, TimeUnit expireTimeUnit, boolean expireAfterRead) {
            super(fetchStrategy, expireTimeout, expireTimeUnit, expireAfterRead);
        }

        public ExpirePolicy expireAfter(long expireTimeout, @Nonnull TimeUnit expireTimeUnit) {
            return new ExpirePolicy(this.fetchStrategy, expireTimeout, (TimeUnit)((Object)Utils.checkNotNull((Object)((Object)expireTimeUnit))), this.expireAfterRead);
        }

        public ExpirePolicy expireAfterRead() {
            return new ExpirePolicy(this.fetchStrategy, this.expireTimeout, this.expireTimeUnit, true);
        }
    }

    public static class Policy {
        public final HttpCacheFetchStrategy fetchStrategy;
        public final long expireTimeout;
        public final TimeUnit expireTimeUnit;
        public final boolean expireAfterRead;

        Policy(HttpCacheFetchStrategy fetchStrategy, long expireTimeout, TimeUnit expireTimeUnit, boolean expireAfterRead) {
            this.fetchStrategy = fetchStrategy;
            this.expireTimeout = expireTimeout;
            this.expireTimeUnit = expireTimeUnit;
            this.expireAfterRead = expireAfterRead;
        }

        public long expireTimeoutMs() {
            if (this.expireTimeUnit == null) {
                return 0L;
            }
            return this.expireTimeUnit.toMillis(this.expireTimeout);
        }
    }
}

