/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.cache.http;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okhttp3.CipherSuite;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.TlsVersion;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;

final class ResponseHeaderRecord {
    private static final String SENT_MILLIS = Platform.get().getPrefix() + "-Sent-Millis";
    private static final String RECEIVED_MILLIS = Platform.get().getPrefix() + "-Received-Millis";
    private final String url;
    private final Headers varyHeaders;
    private final String requestMethod;
    private final Protocol protocol;
    private final int code;
    private final String message;
    private final Headers responseHeaders;
    private final Handshake handshake;
    private final long sentRequestMillis;
    private final long receivedResponseMillis;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResponseHeaderRecord(Source in) throws IOException {
        try {
            BufferedSource source = Okio.buffer((Source)in);
            this.url = source.readUtf8LineStrict();
            this.requestMethod = source.readUtf8LineStrict();
            Headers.Builder varyHeadersBuilder = new Headers.Builder();
            int varyRequestHeaderLineCount = ResponseHeaderRecord.readInt(source);
            for (int i = 0; i < varyRequestHeaderLineCount; ++i) {
                this.addHeaderLenient(varyHeadersBuilder, source.readUtf8LineStrict());
            }
            this.varyHeaders = varyHeadersBuilder.build();
            StatusLine statusLine = StatusLine.parse((String)source.readUtf8LineStrict());
            this.protocol = statusLine.protocol;
            this.code = statusLine.code;
            this.message = statusLine.message;
            Headers.Builder responseHeadersBuilder = new Headers.Builder();
            int responseHeaderLineCount = ResponseHeaderRecord.readInt(source);
            for (int i = 0; i < responseHeaderLineCount; ++i) {
                this.addHeaderLenient(responseHeadersBuilder, source.readUtf8LineStrict());
            }
            String sendRequestMillisString = responseHeadersBuilder.get(SENT_MILLIS);
            String receivedResponseMillisString = responseHeadersBuilder.get(RECEIVED_MILLIS);
            responseHeadersBuilder.removeAll(SENT_MILLIS);
            responseHeadersBuilder.removeAll(RECEIVED_MILLIS);
            this.sentRequestMillis = sendRequestMillisString != null ? Long.parseLong(sendRequestMillisString) : 0L;
            this.receivedResponseMillis = receivedResponseMillisString != null ? Long.parseLong(receivedResponseMillisString) : 0L;
            this.responseHeaders = responseHeadersBuilder.build();
            if (this.isHttps()) {
                String blank = source.readUtf8LineStrict();
                if (blank.length() > 0) {
                    throw new IOException("expected \"\" but was \"" + blank + "\"");
                }
                String cipherSuiteString = source.readUtf8LineStrict();
                CipherSuite cipherSuite = CipherSuite.forJavaName((String)cipherSuiteString);
                List<Certificate> peerCertificates = this.readCertificateList(source);
                List<Certificate> localCertificates = this.readCertificateList(source);
                TlsVersion tlsVersion = !source.exhausted() ? TlsVersion.forJavaName((String)source.readUtf8LineStrict()) : null;
                this.handshake = Handshake.get((TlsVersion)tlsVersion, (CipherSuite)cipherSuite, peerCertificates, localCertificates);
            } else {
                this.handshake = null;
            }
        }
        finally {
            in.close();
        }
    }

    ResponseHeaderRecord(Response response) {
        this.url = response.request().url().toString();
        this.varyHeaders = HttpHeaders.varyHeaders((Response)response);
        this.requestMethod = response.request().method();
        this.protocol = response.protocol();
        this.code = response.code();
        this.message = response.message();
        this.responseHeaders = response.headers();
        this.handshake = response.handshake();
        this.sentRequestMillis = response.sentRequestAtMillis();
        this.receivedResponseMillis = response.receivedResponseAtMillis();
    }

    void writeTo(Sink sink) throws IOException {
        int i;
        BufferedSink bufferedSink = Okio.buffer((Sink)sink);
        bufferedSink.writeUtf8(this.url).writeByte(10);
        bufferedSink.writeUtf8(this.requestMethod).writeByte(10);
        bufferedSink.writeDecimalLong((long)this.varyHeaders.size()).writeByte(10);
        int size = this.varyHeaders.size();
        for (i = 0; i < size; ++i) {
            bufferedSink.writeUtf8(this.varyHeaders.name(i)).writeUtf8(": ").writeUtf8(this.varyHeaders.value(i)).writeByte(10);
        }
        bufferedSink.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString()).writeByte(10);
        bufferedSink.writeDecimalLong((long)(this.responseHeaders.size() + 2)).writeByte(10);
        size = this.responseHeaders.size();
        for (i = 0; i < size; ++i) {
            bufferedSink.writeUtf8(this.responseHeaders.name(i)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(i)).writeByte(10);
        }
        bufferedSink.writeUtf8(SENT_MILLIS).writeUtf8(": ").writeDecimalLong(this.sentRequestMillis).writeByte(10);
        bufferedSink.writeUtf8(RECEIVED_MILLIS).writeUtf8(": ").writeDecimalLong(this.receivedResponseMillis).writeByte(10);
        if (this.isHttps()) {
            bufferedSink.writeByte(10);
            bufferedSink.writeUtf8(this.handshake.cipherSuite().javaName()).writeByte(10);
            this.writeCertList(bufferedSink, this.handshake.peerCertificates());
            this.writeCertList(bufferedSink, this.handshake.localCertificates());
            if (this.handshake.tlsVersion() != null) {
                bufferedSink.writeUtf8(this.handshake.tlsVersion().javaName()).writeByte(10);
            }
        }
        bufferedSink.close();
    }

    private boolean isHttps() {
        return this.url.startsWith("https://");
    }

    private List<Certificate> readCertificateList(BufferedSource source) throws IOException {
        int length = ResponseHeaderRecord.readInt(source);
        if (length == -1) {
            return Collections.emptyList();
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ArrayList<Certificate> result = new ArrayList<Certificate>(length);
            for (int i = 0; i < length; ++i) {
                String line = source.readUtf8LineStrict();
                Buffer bytes = new Buffer();
                bytes.write(ByteString.decodeBase64((String)line));
                result.add(certificateFactory.generateCertificate(bytes.inputStream()));
            }
            return result;
        }
        catch (CertificateException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void writeCertList(BufferedSink sink, List<Certificate> certificates) throws IOException {
        try {
            sink.writeDecimalLong((long)certificates.size()).writeByte(10);
            int size = certificates.size();
            for (int i = 0; i < size; ++i) {
                byte[] bytes = certificates.get(i).getEncoded();
                String line = ByteString.of((byte[])bytes).base64();
                sink.writeUtf8(line).writeByte(10);
            }
        }
        catch (CertificateEncodingException e) {
            throw new IOException(e.getMessage());
        }
    }

    Response response() {
        Request cacheRequest = new Request.Builder().url(this.url).method(this.requestMethod, RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)"")).headers(this.varyHeaders).build();
        return new Response.Builder().request(cacheRequest).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis).build();
    }

    private static int readInt(BufferedSource source) throws IOException {
        try {
            long result = source.readDecimalLong();
            String line = source.readUtf8LineStrict();
            if (result < 0L || result > Integer.MAX_VALUE || !line.isEmpty()) {
                throw new IOException("expected an int but was \"" + result + line + "\"");
            }
            return (int)result;
        }
        catch (NumberFormatException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void addHeaderLenient(Headers.Builder headersBuilder, String line) {
        int index = line.indexOf(":", 1);
        if (index != -1) {
            headersBuilder.add(line.substring(0, index), line.substring(index + 1));
        } else if (line.startsWith(":")) {
            headersBuilder.add("", line.substring(1));
        } else {
            headersBuilder.add("", line);
        }
    }
}

