/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.http.HttpCachePolicy;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.util.ApolloLogger;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;

public final class ApolloServerInterceptor
implements ApolloInterceptor {
    private static final String ACCEPT_TYPE = "application/json";
    private static final String CONTENT_TYPE = "application/json";
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    final HttpUrl serverUrl;
    final Call.Factory httpCallFactory;
    final Optional<HttpCachePolicy.Policy> cachePolicy;
    final boolean prefetch;
    final Moshi moshi;
    final ApolloLogger logger;
    volatile Call httpCall;

    public ApolloServerInterceptor(@Nonnull HttpUrl serverUrl, @Nonnull Call.Factory httpCallFactory, @Nullable HttpCachePolicy.Policy cachePolicy, boolean prefetch, @Nonnull Moshi moshi, @Nonnull ApolloLogger logger) {
        this.serverUrl = (HttpUrl)Utils.checkNotNull((Object)serverUrl, (Object)"serverUrl == null");
        this.httpCallFactory = (Call.Factory)Utils.checkNotNull((Object)httpCallFactory, (Object)"httpCallFactory == null");
        this.cachePolicy = Optional.fromNullable((Object)cachePolicy);
        this.prefetch = prefetch;
        this.moshi = (Moshi)Utils.checkNotNull((Object)moshi, (Object)"moshi == null");
        this.logger = (ApolloLogger)Utils.checkNotNull((Object)logger, (Object)"logger == null");
    }

    @Override
    @Nonnull
    public ApolloInterceptor.InterceptorResponse intercept(Operation operation, ApolloInterceptorChain chain) throws ApolloException {
        try {
            this.httpCall = this.httpCall(operation);
        }
        catch (IOException e) {
            this.logger.e(e, "Failed to prepare http call", new Object[0]);
            throw new ApolloNetworkException("Failed to prepare http call", e);
        }
        try {
            return new ApolloInterceptor.InterceptorResponse(this.httpCall.execute());
        }
        catch (IOException e) {
            this.logger.e(e, "Failed to execute http call", new Object[0]);
            throw new ApolloNetworkException("Failed to execute http call", e);
        }
    }

    @Override
    public void interceptAsync(final @Nonnull Operation operation, @Nonnull ApolloInterceptorChain chain, @Nonnull ExecutorService dispatcher, final @Nonnull ApolloInterceptor.CallBack callBack) {
        dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ApolloServerInterceptor.this.httpCall = ApolloServerInterceptor.this.httpCall(operation);
                }
                catch (IOException e) {
                    ApolloServerInterceptor.this.logger.e(e, "Failed to prepare http call", new Object[0]);
                    callBack.onFailure(new ApolloNetworkException("Failed to prepare http call", e));
                    return;
                }
                ApolloServerInterceptor.this.httpCall.enqueue(new Callback(){

                    public void onFailure(Call call, IOException e) {
                        ApolloServerInterceptor.this.logger.e(e, "Failed to execute http call", new Object[0]);
                        callBack.onFailure(new ApolloNetworkException("Failed to execute http call", e));
                    }

                    public void onResponse(Call call, Response response) throws IOException {
                        callBack.onResponse(new ApolloInterceptor.InterceptorResponse(response));
                    }
                });
            }
        });
    }

    @Override
    public void dispose() {
        Call httpCall = this.httpCall;
        if (httpCall != null) {
            httpCall.cancel();
        }
        this.httpCall = null;
    }

    private Call httpCall(Operation operation) throws IOException {
        RequestBody requestBody = this.httpRequestBody(operation);
        Request.Builder requestBuilder = new Request.Builder().url(this.serverUrl).post(requestBody).header("Accept", "application/json").header("Content-Type", "application/json");
        if (this.cachePolicy.isPresent()) {
            HttpCachePolicy.Policy cachePolicy = (HttpCachePolicy.Policy)this.cachePolicy.get();
            String cacheKey = ApolloServerInterceptor.cacheKey(requestBody);
            requestBuilder = requestBuilder.header("X-APOLLO-CACHE-KEY", cacheKey).header("X-APOLLO-CACHE-FETCH-STRATEGY", cachePolicy.fetchStrategy.name()).header("X-APOLLO-EXPIRE-TIMEOUT", String.valueOf(cachePolicy.expireTimeoutMs())).header("X-APOLLO-EXPIRE-AFTER-READ", Boolean.toString(cachePolicy.expireAfterRead)).header("X-APOLLO-PREFETCH", Boolean.toString(this.prefetch));
        }
        return this.httpCallFactory.newCall(requestBuilder.build());
    }

    private RequestBody httpRequestBody(Operation operation) throws IOException {
        OperationJsonAdapter adapter = new OperationJsonAdapter(this.moshi);
        Buffer buffer = new Buffer();
        adapter.toJson((BufferedSink)buffer, operation);
        return RequestBody.create((MediaType)MEDIA_TYPE, (ByteString)buffer.readByteString());
    }

    public static String cacheKey(RequestBody requestBody) throws IOException {
        Buffer hashBuffer = new Buffer();
        requestBody.writeTo((BufferedSink)hashBuffer);
        return hashBuffer.readByteString().md5().hex();
    }

    static final class OperationJsonAdapter
    extends JsonAdapter<Operation> {
        private final Moshi moshi;

        OperationJsonAdapter(Moshi moshi) {
            this.moshi = moshi;
        }

        public Operation fromJson(JsonReader reader) throws IOException {
            throw new IllegalStateException("This should not be called ever.");
        }

        public void toJson(JsonWriter writer, Operation value) throws IOException {
            writer.beginObject();
            writer.name("query").value(value.queryDocument().replaceAll("\\n", ""));
            Operation.Variables variables = value.variables();
            if (variables != null) {
                JsonAdapter adapter = this.moshi.adapter(variables.getClass());
                writer.name("variables");
                adapter.toJson(writer, (Object)variables);
            }
            writer.endObject();
        }
    }
}

