/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.cache.normalized;

import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.Field;
import com.apollographql.apollo.api.GraphqlFragment;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.CacheKey;
import com.apollographql.apollo.cache.normalized.CacheKeyResolver;
import com.apollographql.apollo.cache.normalized.NormalizedCache;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.internal.cache.normalized.ReadableStore;
import com.apollographql.apollo.internal.cache.normalized.ResponseNormalizer;
import com.apollographql.apollo.internal.cache.normalized.Transaction;
import com.apollographql.apollo.internal.cache.normalized.WriteableStore;
import com.apollographql.apollo.internal.field.CacheFieldValueResolver;
import com.apollographql.apollo.internal.reader.RealResponseReader;
import com.apollographql.apollo.internal.util.ApolloLogger;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class RealApolloStore
implements ApolloStore,
ReadableStore,
WriteableStore {
    private final NormalizedCache normalizedCache;
    private final CacheKeyResolver cacheKeyResolver;
    private final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;
    private final ApolloLogger logger;
    private final ReadWriteLock lock;
    private final Set<ApolloStore.RecordChangeSubscriber> subscribers;

    public RealApolloStore(@Nonnull NormalizedCache normalizedCache, @Nonnull CacheKeyResolver cacheKeyResolver, @Nonnull Map<ScalarType, CustomTypeAdapter> customTypeAdapters, @Nonnull ApolloLogger logger) {
        this.normalizedCache = (NormalizedCache)Utils.checkNotNull((Object)normalizedCache, (Object)"cacheStore == null");
        this.cacheKeyResolver = (CacheKeyResolver)Utils.checkNotNull((Object)cacheKeyResolver, (Object)"cacheKeyResolver == null");
        this.customTypeAdapters = (Map)Utils.checkNotNull(customTypeAdapters, (Object)"customTypeAdapters == null");
        this.logger = (ApolloLogger)Utils.checkNotNull((Object)logger, (Object)"logger == null");
        this.lock = new ReentrantReadWriteLock();
        this.subscribers = Collections.newSetFromMap(new WeakHashMap());
    }

    @Override
    public ResponseNormalizer<Map<String, Object>> networkResponseNormalizer() {
        return new ResponseNormalizer<Map<String, Object>>(){

            @Override
            @Nonnull
            public CacheKey resolveCacheKey(@Nonnull Field field, @Nonnull Map<String, Object> record) {
                return RealApolloStore.this.cacheKeyResolver.fromFieldRecordSet(field, record);
            }
        };
    }

    @Override
    public ResponseNormalizer<Record> cacheResponseNormalizer() {
        return new ResponseNormalizer<Record>(){

            @Override
            @Nonnull
            public CacheKey resolveCacheKey(@Nonnull Field field, @Nonnull Record record) {
                return CacheKey.from(record.key());
            }
        };
    }

    @Override
    public synchronized void subscribe(ApolloStore.RecordChangeSubscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    @Override
    public synchronized void unsubscribe(ApolloStore.RecordChangeSubscriber subscriber) {
        this.subscribers.remove(subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(@Nonnull Set<String> changedKeys) {
        LinkedHashSet<ApolloStore.RecordChangeSubscriber> iterableSubscribers;
        Utils.checkNotNull(changedKeys, (Object)"changedKeys == null");
        if (changedKeys.isEmpty()) {
            return;
        }
        RealApolloStore realApolloStore = this;
        synchronized (realApolloStore) {
            iterableSubscribers = new LinkedHashSet<ApolloStore.RecordChangeSubscriber>(this.subscribers);
        }
        for (ApolloStore.RecordChangeSubscriber subscriber : iterableSubscribers) {
            subscriber.onCacheRecordsChanged(changedKeys);
        }
    }

    @Override
    public void clearAll() {
        this.writeTransaction(new Transaction<WriteableStore, Boolean>(){

            @Override
            public Boolean execute(WriteableStore cache) {
                cache.clearAll();
                return true;
            }
        });
    }

    @Override
    public <R> R readTransaction(Transaction<ReadableStore, R> transaction) {
        this.lock.readLock().lock();
        try {
            R r = transaction.execute(this);
            return r;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <R> R writeTransaction(Transaction<WriteableStore, R> transaction) {
        this.lock.writeLock().lock();
        try {
            R r = transaction.execute(this);
            return r;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public NormalizedCache normalizedCache() {
        return this.normalizedCache;
    }

    @Override
    @Nullable
    public Record read(@Nonnull String key, @Nonnull CacheHeaders cacheHeaders) {
        return this.normalizedCache.loadRecord((String)Utils.checkNotNull((Object)key, (Object)"key == null"), cacheHeaders);
    }

    @Override
    @Nonnull
    public Collection<Record> read(@Nonnull Collection<String> keys, @Nonnull CacheHeaders cacheHeaders) {
        return this.normalizedCache.loadRecords((Collection)Utils.checkNotNull(keys, (Object)"keys == null"), cacheHeaders);
    }

    @Override
    @Nonnull
    public Set<String> merge(@Nonnull Collection<Record> recordSet, @Nonnull CacheHeaders cacheHeaders) {
        return this.normalizedCache.merge((Collection)Utils.checkNotNull(recordSet, (Object)"recordSet == null"), cacheHeaders);
    }

    @Override
    public CacheKeyResolver cacheKeyResolver() {
        return this.cacheKeyResolver;
    }

    @Override
    @Nullable
    public <D extends Operation.Data, T, V extends Operation.Variables> T read(final @Nonnull Operation<D, T, V> operation) {
        Utils.checkNotNull(operation, (Object)"operation == null");
        return (T)this.readTransaction(new Transaction<ReadableStore, T>(){

            @Override
            @Nullable
            public T execute(ReadableStore cache) {
                Record rootRecord = cache.read(CacheKeyResolver.rootKeyForOperation(operation).key(), CacheHeaders.NONE);
                if (rootRecord == null) {
                    return null;
                }
                ResponseFieldMapper responseFieldMapper = operation.responseFieldMapper();
                CacheFieldValueResolver fieldValueResolver = new CacheFieldValueResolver(cache, operation.variables(), RealApolloStore.this.cacheKeyResolver(), CacheHeaders.NONE);
                RealResponseReader<Record> responseReader = new RealResponseReader<Record>(operation.variables(), rootRecord, fieldValueResolver, RealApolloStore.this.customTypeAdapters, ResponseNormalizer.NO_OP_NORMALIZER);
                try {
                    return operation.wrapData((Operation.Data)responseFieldMapper.map(responseReader));
                }
                catch (Exception e) {
                    RealApolloStore.this.logger.e(e, "Failed to read cached operation data. Operation: %s", operation);
                    return null;
                }
            }
        });
    }

    @Override
    @Nonnull
    public <D extends Operation.Data, T, V extends Operation.Variables> Response<T> read(final @Nonnull Operation<D, T, V> operation, final @Nonnull ResponseFieldMapper<D> responseFieldMapper, final @Nonnull ResponseNormalizer<Record> responseNormalizer, final @Nonnull CacheHeaders cacheHeaders) {
        Utils.checkNotNull(operation, (Object)"operation == null");
        Utils.checkNotNull(responseNormalizer, (Object)"responseNormalizer == null");
        Utils.checkNotNull(this.customTypeAdapters, (Object)"customTypeAdapters == null");
        return (Response)this.readTransaction(new Transaction<ReadableStore, Response<T>>(){

            @Override
            @Nonnull
            public Response<T> execute(ReadableStore cache) {
                Record rootRecord = cache.read(CacheKeyResolver.rootKeyForOperation(operation).key(), cacheHeaders);
                if (rootRecord == null) {
                    return Response.builder((Operation)operation).build();
                }
                CacheFieldValueResolver fieldValueResolver = new CacheFieldValueResolver(cache, operation.variables(), RealApolloStore.this.cacheKeyResolver(), cacheHeaders);
                RealResponseReader<Record> responseReader = new RealResponseReader<Record>(operation.variables(), rootRecord, fieldValueResolver, RealApolloStore.this.customTypeAdapters, responseNormalizer);
                try {
                    responseNormalizer.willResolveRootQuery(operation);
                    Object data = operation.wrapData((Operation.Data)responseFieldMapper.map(responseReader));
                    return Response.builder((Operation)operation).data(data).dependentKeys(responseNormalizer.dependentKeys()).build();
                }
                catch (Exception e) {
                    RealApolloStore.this.logger.e(e, "Failed to read cached operation data. Operation: %s", operation);
                    return Response.builder((Operation)operation).build();
                }
            }
        });
    }

    @Override
    @Nullable
    public <F extends GraphqlFragment> F read(final @Nonnull ResponseFieldMapper<F> responseFieldMapper, final @Nonnull CacheKey cacheKey, final @Nonnull Operation.Variables variables) {
        Utils.checkNotNull(responseFieldMapper, (Object)"responseFieldMapper == null");
        Utils.checkNotNull((Object)cacheKey, (Object)"cacheKey == null");
        Utils.checkNotNull((Object)variables, (Object)"variables == null");
        return (F)((GraphqlFragment)this.readTransaction(new Transaction<ReadableStore, F>(){

            @Override
            @Nullable
            public F execute(ReadableStore cache) {
                Record rootRecord = cache.read(cacheKey.key(), CacheHeaders.NONE);
                if (rootRecord == null) {
                    return null;
                }
                CacheFieldValueResolver fieldValueResolver = new CacheFieldValueResolver(cache, variables, RealApolloStore.this.cacheKeyResolver(), CacheHeaders.NONE);
                RealResponseReader<Record> responseReader = new RealResponseReader<Record>(variables, rootRecord, fieldValueResolver, RealApolloStore.this.customTypeAdapters, ResponseNormalizer.NO_OP_NORMALIZER);
                try {
                    return (GraphqlFragment)responseFieldMapper.map(responseReader);
                }
                catch (Exception e) {
                    RealApolloStore.this.logger.e(e, "Failed to read cached fragment data", new Object[0]);
                    return null;
                }
            }
        }));
    }
}

