/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.cache.normalized;

import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.CacheKeyResolver;
import com.apollographql.apollo.cache.normalized.NormalizedCache;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.internal.cache.normalized.ReadableCache;
import com.apollographql.apollo.internal.cache.normalized.ResponseNormalizer;
import com.apollographql.apollo.internal.cache.normalized.Transaction;
import com.apollographql.apollo.internal.cache.normalized.WriteableCache;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class RealApolloStore
implements ApolloStore,
ReadableCache,
WriteableCache {
    private final NormalizedCache normalizedCache;
    private final CacheKeyResolver<Map<String, Object>> networkCacheKeyResolver;
    private final ReadWriteLock lock;
    private final Set<ApolloStore.RecordChangeSubscriber> subscribers;

    public RealApolloStore(@Nonnull NormalizedCache normalizedCache, @Nonnull CacheKeyResolver<Map<String, Object>> networkCacheKeyResolver) {
        this.normalizedCache = (NormalizedCache)Utils.checkNotNull((Object)normalizedCache, (Object)"cacheStore null");
        this.networkCacheKeyResolver = (CacheKeyResolver)Utils.checkNotNull(networkCacheKeyResolver, (Object)"networkCacheKeyResolver null");
        this.lock = new ReentrantReadWriteLock();
        this.subscribers = Collections.newSetFromMap(new WeakHashMap());
    }

    @Override
    public ResponseNormalizer<Map<String, Object>> networkResponseNormalizer() {
        return new ResponseNormalizer<Map<String, Object>>(this.networkCacheKeyResolver);
    }

    @Override
    public ResponseNormalizer<Record> cacheResponseNormalizer() {
        return new ResponseNormalizer<Record>(CacheKeyResolver.RECORD);
    }

    @Override
    public synchronized void subscribe(ApolloStore.RecordChangeSubscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    @Override
    public synchronized void unsubscribe(ApolloStore.RecordChangeSubscriber subscriber) {
        this.subscribers.remove(subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(@Nonnull Set<String> changedKeys) {
        LinkedHashSet<ApolloStore.RecordChangeSubscriber> iterableSubscribers;
        Utils.checkNotNull(changedKeys, (Object)"changedKeys == null");
        if (changedKeys.isEmpty()) {
            return;
        }
        RealApolloStore realApolloStore = this;
        synchronized (realApolloStore) {
            iterableSubscribers = new LinkedHashSet<ApolloStore.RecordChangeSubscriber>(this.subscribers);
        }
        for (ApolloStore.RecordChangeSubscriber subscriber : iterableSubscribers) {
            subscriber.onCacheRecordsChanged(changedKeys);
        }
    }

    @Override
    public void clearAll() {
        this.writeTransaction(new Transaction<WriteableCache, Boolean>(){

            @Override
            public Boolean execute(WriteableCache cache) {
                cache.clearAll();
                return true;
            }
        });
    }

    @Override
    public <R> R readTransaction(Transaction<ReadableCache, R> transaction) {
        this.lock.readLock().lock();
        try {
            R r = transaction.execute(this);
            return r;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <R> R writeTransaction(Transaction<WriteableCache, R> transaction) {
        this.lock.writeLock().lock();
        try {
            R r = transaction.execute(this);
            return r;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public NormalizedCache normalizedCache() {
        return this.normalizedCache;
    }

    @Override
    @Nullable
    public Record read(@Nonnull String key) {
        return this.normalizedCache.loadRecord((String)Utils.checkNotNull((Object)key, (Object)"key == null"));
    }

    @Override
    @Nonnull
    public Collection<Record> read(@Nonnull Collection<String> keys) {
        return this.normalizedCache.loadRecords((Collection)Utils.checkNotNull(keys, (Object)"keys == null"));
    }

    @Override
    @Nonnull
    public Set<String> merge(@Nonnull Collection<Record> recordSet) {
        return this.normalizedCache.merge((Collection)Utils.checkNotNull(recordSet, (Object)"recordSet == null"));
    }
}

