/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.http.HttpCacheControl;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.CacheControl;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.exception.ApolloParseException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.RealApolloWatcher;
import com.apollographql.apollo.internal.cache.http.HttpCache;
import com.apollographql.apollo.internal.interceptor.ApolloCacheInterceptor;
import com.apollographql.apollo.internal.interceptor.ApolloParseInterceptor;
import com.apollographql.apollo.internal.interceptor.ApolloServerInterceptor;
import com.apollographql.apollo.internal.interceptor.RealApolloInterceptorChain;
import com.apollographql.apollo.internal.util.ApolloLogger;
import com.squareup.moshi.Moshi;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.HttpUrl;

public final class RealApolloCall<T>
implements ApolloCall<T> {
    final Operation operation;
    final HttpUrl serverUrl;
    final Call.Factory httpCallFactory;
    final HttpCache httpCache;
    final HttpCacheControl httpCacheControl;
    final Moshi moshi;
    final ResponseFieldMapper responseFieldMapper;
    final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;
    final ApolloStore apolloStore;
    final CacheControl cacheControl;
    final ApolloInterceptorChain interceptorChain;
    final ExecutorService dispatcher;
    final ApolloLogger logger;
    volatile boolean executed;
    volatile boolean canceled;

    public RealApolloCall(Operation operation, HttpUrl serverUrl, Call.Factory httpCallFactory, HttpCache httpCache, HttpCacheControl httpCacheControl, Moshi moshi, ResponseFieldMapper responseFieldMapper, Map<ScalarType, CustomTypeAdapter> customTypeAdapters, ApolloStore apolloStore, CacheControl cacheControl, ExecutorService dispatcher, ApolloLogger logger) {
        this.operation = operation;
        this.serverUrl = serverUrl;
        this.httpCallFactory = httpCallFactory;
        this.httpCache = httpCache;
        this.httpCacheControl = httpCacheControl;
        this.moshi = moshi;
        this.responseFieldMapper = responseFieldMapper;
        this.customTypeAdapters = customTypeAdapters;
        this.apolloStore = apolloStore;
        this.cacheControl = cacheControl;
        this.dispatcher = dispatcher;
        this.logger = logger;
        this.interceptorChain = new RealApolloInterceptorChain(operation, Arrays.asList(new ApolloCacheInterceptor(apolloStore, cacheControl, responseFieldMapper, customTypeAdapters, dispatcher, logger), new ApolloParseInterceptor(httpCache, apolloStore.networkResponseNormalizer(), responseFieldMapper, customTypeAdapters, logger), new ApolloServerInterceptor(serverUrl, httpCallFactory, httpCacheControl, false, moshi, logger)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Response<T> execute() throws ApolloException {
        RealApolloCall realApolloCall = this;
        synchronized (realApolloCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        return (Response)this.interceptorChain.proceed().parsedResponse.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(final @Nullable ApolloCall.Callback<T> callback) {
        RealApolloCall realApolloCall = this;
        synchronized (realApolloCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.interceptorChain.proceedAsync(this.dispatcher, new ApolloInterceptor.CallBack(){

            @Override
            public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                if (callback == null || RealApolloCall.this.isCanceled()) {
                    return;
                }
                callback.onResponse((Response)response.parsedResponse.get());
            }

            @Override
            public void onFailure(@Nonnull ApolloException e) {
                if (callback == null || RealApolloCall.this.isCanceled()) {
                    return;
                }
                if (e instanceof ApolloHttpException) {
                    callback.onHttpError((ApolloHttpException)e);
                } else if (e instanceof ApolloParseException) {
                    callback.onParseError((ApolloParseException)e);
                } else if (e instanceof ApolloNetworkException) {
                    callback.onNetworkError((ApolloNetworkException)e);
                } else {
                    callback.onFailure(e);
                }
            }
        });
    }

    @Override
    @Nonnull
    public RealApolloWatcher<T> watcher() {
        return new RealApolloWatcher(this.clone(), this.apolloStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public RealApolloCall<T> httpCacheControl(@Nonnull HttpCacheControl httpCacheControl) {
        RealApolloCall realApolloCall = this;
        synchronized (realApolloCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
        }
        return new RealApolloCall<T>(this.operation, this.serverUrl, this.httpCallFactory, this.httpCache, (HttpCacheControl)((Object)Utils.checkNotNull((Object)((Object)httpCacheControl), (Object)"httpCacheControl == null")), this.moshi, this.responseFieldMapper, this.customTypeAdapters, this.apolloStore, this.cacheControl, this.dispatcher, this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public RealApolloCall<T> cacheControl(@Nonnull CacheControl cacheControl) {
        RealApolloCall realApolloCall = this;
        synchronized (realApolloCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
        }
        return new RealApolloCall<T>(this.operation, this.serverUrl, this.httpCallFactory, this.httpCache, this.httpCacheControl, this.moshi, this.responseFieldMapper, this.customTypeAdapters, this.apolloStore, (CacheControl)((Object)Utils.checkNotNull((Object)((Object)cacheControl), (Object)"cacheControl == null")), this.dispatcher, this.logger);
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.interceptorChain.dispose();
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    @Nonnull
    public RealApolloCall<T> clone() {
        return new RealApolloCall<T>(this.operation, this.serverUrl, this.httpCallFactory, this.httpCache, this.httpCacheControl, this.moshi, this.responseFieldMapper, this.customTypeAdapters, this.apolloStore, this.cacheControl, this.dispatcher, this.logger);
    }
}

