/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo;

import com.apollographql.apollo.ApolloWatcher;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.cache.http.HttpCacheControl;
import com.apollographql.apollo.cache.normalized.CacheControl;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.exception.ApolloParseException;
import com.apollographql.apollo.internal.util.Cancelable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ApolloCall<T>
extends Cancelable {
    @Nonnull
    public Response<T> execute() throws ApolloException;

    public void enqueue(@Nullable Callback<T> var1);

    @Nonnull
    public ApolloWatcher<T> watcher();

    @Nonnull
    public ApolloCall<T> httpCacheControl(@Nonnull HttpCacheControl var1);

    @Nonnull
    public ApolloCall<T> cacheControl(@Nonnull CacheControl var1);

    @Nonnull
    public ApolloCall<T> clone();

    public static interface Factory {
        public <D extends Operation.Data, T, V extends Operation.Variables> ApolloCall<T> newCall(@Nonnull Operation<D, T, V> var1);
    }

    public static abstract class Callback<T> {
        public abstract void onResponse(@Nonnull Response<T> var1);

        public abstract void onFailure(@Nonnull ApolloException var1);

        public void onHttpError(@Nonnull ApolloHttpException e) {
            this.onFailure(e);
            okhttp3.Response response = e.rawResponse();
            if (response != null) {
                response.close();
            }
        }

        public void onNetworkError(@Nonnull ApolloNetworkException e) {
            this.onFailure(e);
        }

        public void onParseError(@Nonnull ApolloParseException e) {
            this.onFailure(e);
        }
    }
}

