/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.runtime.java.network.ws.protocol;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.ImmutableMapBuilder;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.http.DefaultHttpRequestComposer;
import com.apollographql.apollo.runtime.java.network.ws.WebSocketConnection;
import com.apollographql.apollo.runtime.java.network.ws.protocol.WsProtocol;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;

public class ApolloWsProtocol
extends WsProtocol {
    private Supplier<Map<String, Object>> connectionPayload;
    private WsProtocol.WsFrameType frameType;

    public ApolloWsProtocol(WebSocketConnection webSocketConnection, WsProtocol.Listener listener, Supplier<Map<String, Object>> connectionPayload, WsProtocol.WsFrameType frameType) {
        super(webSocketConnection, listener);
        this.connectionPayload = connectionPayload;
        this.frameType = frameType;
    }

    @Override
    public void connectionInit() {
        Map message = new ImmutableMapBuilder().put((Object)"type", (Object)"connection_init").build();
        Map<String, Object> payload = this.connectionPayload.get();
        if (payload != null) {
            message.put("payload", payload);
        }
        this.sendMessageMap(message, this.frameType);
        Map<String, Object> map = this.receiveMessageMap(-1L);
        if (map == null) {
            this.listener.networkError(new IOException("Connection closed while waiting for connection_ack"));
        } else {
            Object type = map.get("type");
            if ("connection_error".equals(type)) {
                this.listener.networkError(new IOException("connection_error received " + map));
            } else if (!"connection_ack".equals(type)) {
                System.out.println("unknown graphql-ws message while waiting for connection_ack: " + type);
            }
        }
    }

    @Override
    public void handleServerMessage(Map<String, Object> messageMap) {
        String type;
        switch (type = (String)messageMap.get("type")) {
            case "data": {
                this.listener.operationResponse((String)messageMap.get("id"), (Map)messageMap.get("payload"));
                break;
            }
            case "error": {
                String id = (String)messageMap.get("id");
                if (id != null) {
                    this.listener.operationError(id, (Map)messageMap.get("payload"));
                    break;
                }
                this.listener.generalError((Map)messageMap.get("payload"));
                break;
            }
            case "complete": {
                this.listener.operationComplete((String)messageMap.get("id"));
            }
        }
    }

    @Override
    public <D extends Operation.Data> void startOperation(ApolloRequest<D> request) {
        this.sendMessageMap(new ImmutableMapBuilder().put((Object)"type", (Object)"start").put((Object)"id", (Object)request.getRequestUuid().toString()).put((Object)"payload", (Object)DefaultHttpRequestComposer.Companion.composePayload(request)).build(), this.frameType);
    }

    @Override
    public <D extends Operation.Data> void stopOperation(ApolloRequest<D> request) {
        this.sendMessageMap(new ImmutableMapBuilder().put((Object)"type", (Object)"stop").put((Object)"id", (Object)request.getRequestUuid().toString()).build(), this.frameType);
    }

    public static class Factory
    implements WsProtocol.Factory {
        private Supplier<Map<String, Object>> connectionPayload;
        private WsProtocol.WsFrameType frameType;

        public Factory() {
            this(() -> null);
        }

        public Factory(Supplier<Map<String, Object>> connectionPayload) {
            this(connectionPayload, WsProtocol.WsFrameType.Text);
        }

        public Factory(Supplier<Map<String, Object>> connectionPayload, WsProtocol.WsFrameType frameType) {
            this.connectionPayload = connectionPayload;
            this.frameType = frameType;
        }

        @Override
        public String getName() {
            return "apollo-ws";
        }

        @Override
        public WsProtocol create(WebSocketConnection webSocketConnection, WsProtocol.Listener listener) {
            return new ApolloWsProtocol(webSocketConnection, listener, this.connectionPayload, this.frameType);
        }
    }
}

