/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.runtime.java.network.http;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.ExecutionContext;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Operations;
import com.apollographql.apollo.api.http.HttpRequest;
import com.apollographql.apollo.api.http.HttpRequestComposer;
import com.apollographql.apollo.api.http.HttpResponse;
import com.apollographql.apollo.api.json.BufferedSourceJsonReader;
import com.apollographql.apollo.api.json.JsonReader;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.runtime.java.ApolloCallback;
import com.apollographql.apollo.runtime.java.ApolloDisposable;
import com.apollographql.apollo.runtime.java.network.NetworkTransport;
import com.apollographql.apollo.runtime.java.network.http.HttpCallback;
import com.apollographql.apollo.runtime.java.network.http.HttpEngine;
import com.apollographql.apollo.runtime.java.network.http.HttpInterceptor;
import com.apollographql.apollo.runtime.java.network.http.internal.DefaultHttpInterceptorChain;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class HttpNetworkTransport
implements NetworkTransport {
    private final HttpRequestComposer requestComposer;
    private final HttpEngine httpEngine;
    private final List<HttpInterceptor> interceptors;
    private final boolean exposeErrorBody;

    public HttpNetworkTransport(HttpRequestComposer httpRequestComposer, HttpEngine httpEngine, List<HttpInterceptor> interceptors, boolean exposeErrorBody) {
        this.requestComposer = httpRequestComposer;
        this.httpEngine = httpEngine;
        this.interceptors = interceptors;
        this.exposeErrorBody = exposeErrorBody;
    }

    @Override
    public <D extends Operation.Data> void execute(final @NotNull ApolloRequest<D> request, final @NotNull ApolloCallback<D> callback, ApolloDisposable disposable) {
        ArrayList<HttpInterceptor> interceptorsWithEngine = new ArrayList<HttpInterceptor>(this.interceptors);
        interceptorsWithEngine.add((req, chain, httpCallback) -> this.httpEngine.execute(req, httpCallback, disposable));
        DefaultHttpInterceptorChain chain2 = new DefaultHttpInterceptorChain(interceptorsWithEngine, 0);
        HttpRequest httpRequest = this.requestComposer.compose(request);
        chain2.proceed(httpRequest, new HttpCallback(){

            @Override
            public void onResponse(@NotNull HttpResponse response) {
                if (response.getStatusCode() < 200 || response.getStatusCode() > 299) {
                    String message = "Http request failed with status code `" + response.getStatusCode() + "`";
                    if (HttpNetworkTransport.this.exposeErrorBody) {
                        callback.onResponse(HttpNetworkTransport.getExceptionResponse(request, (ApolloException)new ApolloHttpException(response.getStatusCode(), response.getHeaders(), response.getBody(), message, null)));
                    } else {
                        try {
                            response.getBody().close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        callback.onResponse(HttpNetworkTransport.getExceptionResponse(request, (ApolloException)new ApolloHttpException(response.getStatusCode(), response.getHeaders(), null, message, null)));
                    }
                } else {
                    BufferedSourceJsonReader jsonReader = new BufferedSourceJsonReader(response.getBody());
                    CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)request.getExecutionContext().get((ExecutionContext.Key)CustomScalarAdapters.Key);
                    ApolloResponse apolloResponse = Operations.toApolloResponse((JsonReader)jsonReader, (Operation)request.getOperation(), (UUID)request.getRequestUuid(), (CustomScalarAdapters)customScalarAdapters, null);
                    callback.onResponse(apolloResponse);
                }
            }

            @Override
            public void onFailure(@NotNull ApolloNetworkException exception) {
                callback.onResponse(HttpNetworkTransport.getExceptionResponse(request, (ApolloException)exception));
            }
        });
    }

    @NotNull
    private static <D extends Operation.Data> ApolloResponse<D> getExceptionResponse(@NotNull ApolloRequest<D> request, @NotNull ApolloException exception) {
        return new ApolloResponse.Builder(request.getOperation(), request.getRequestUuid()).exception(exception).build();
    }

    @Override
    public void dispose() {
        this.httpEngine.dispose();
    }
}

