/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.apollographql.apollo.annotations.ApolloInternal;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.exception.DefaultApolloException;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Options;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000  2\u00060\u0001j\u0002`\u0002:\u0003\u001e\u001f B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0018\u00010\u0014R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/apollographql/apollo/internal/MultipartReader;", "Ljava/io/Closeable;", "Lokio/Closeable;", "source", "Lokio/BufferedSource;", "boundary", "", "<init>", "(Lokio/BufferedSource;Ljava/lang/String;)V", "getBoundary", "()Ljava/lang/String;", "dashDashBoundary", "Lokio/ByteString;", "crlfDashDashBoundary", "partCount", "", "closed", "", "noMoreParts", "currentPart", "Lcom/apollographql/apollo/internal/MultipartReader$PartSource;", "nextPart", "Lcom/apollographql/apollo/internal/MultipartReader$Part;", "currentPartBytesRemaining", "", "maxResult", "afterBoundaryOptions", "Lokio/Options;", "close", "", "PartSource", "Part", "Companion", "apollo-runtime_debug"})
@ApolloInternal
@SourceDebugExtension(value={"SMAP\nMultipartReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipartReader.kt\ncom/apollographql/apollo/internal/MultipartReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
public final class MultipartReader
implements Closeable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final String boundary;
    @NotNull
    private final ByteString dashDashBoundary;
    @NotNull
    private final ByteString crlfDashDashBoundary;
    private int partCount;
    private boolean closed;
    private boolean noMoreParts;
    @Nullable
    private PartSource currentPart;
    @NotNull
    private final Options afterBoundaryOptions;

    public MultipartReader(@NotNull BufferedSource source, @NotNull String boundary) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
        this.source = source;
        this.boundary = boundary;
        this.dashDashBoundary = new Buffer().writeUtf8("--").writeUtf8(this.boundary).readByteString();
        this.crlfDashDashBoundary = new Buffer().writeUtf8("\r\n--").writeUtf8(this.boundary).readByteString();
        ByteString[] byteStringArray = new ByteString[]{ByteString.Companion.encodeUtf8("\r\n--" + this.boundary + "--"), ByteString.Companion.encodeUtf8("\r\n"), ByteString.Companion.encodeUtf8("--"), ByteString.Companion.encodeUtf8(" "), ByteString.Companion.encodeUtf8("\t")};
        this.afterBoundaryOptions = Options.Companion.of(byteStringArray);
    }

    @NotNull
    public final String getBoundary() {
        return this.boundary;
    }

    @Nullable
    public final Part nextPart() {
        PartSource partSource;
        if (!(!this.closed)) {
            boolean $i$a$-check-MultipartReader$nextPart$22 = false;
            String $i$a$-check-MultipartReader$nextPart$22 = "closed";
            throw new IllegalStateException($i$a$-check-MultipartReader$nextPart$22.toString());
        }
        if (this.noMoreParts) {
            return null;
        }
        if (this.partCount == 0 && this.source.rangeEquals(0L, this.dashDashBoundary)) {
            this.source.skip((long)this.dashDashBoundary.size());
        } else {
            long toSkip;
            while ((toSkip = this.currentPartBytesRemaining(8192L)) != 0L) {
                this.source.skip(toSkip);
            }
            this.source.skip((long)this.crlfDashDashBoundary.size());
        }
        boolean whitespace = false;
        block8: while (true) {
            switch (this.source.select(this.afterBoundaryOptions)) {
                case 0: {
                    if (this.partCount == 0) {
                        throw new DefaultApolloException("expected at least 1 part", null, 2, null);
                    }
                    this.noMoreParts = true;
                    return null;
                }
                case 1: {
                    int n = this.partCount;
                    this.partCount = n + 1;
                    break block8;
                }
                case 2: {
                    if (whitespace) {
                        throw new DefaultApolloException("unexpected characters after boundary", null, 2, null);
                    }
                    if (this.partCount == 0) {
                        throw new DefaultApolloException("expected at least 1 part", null, 2, null);
                    }
                    this.noMoreParts = true;
                    return null;
                }
                case 3: 
                case 4: {
                    whitespace = true;
                    continue block8;
                }
                case -1: {
                    if (this.source.exhausted()) {
                        throw new DefaultApolloException("premature end of multipart body", null, 2, null);
                    }
                    throw new DefaultApolloException("unexpected characters after boundary", null, 2, null);
                }
                default: {
                    continue block8;
                }
            }
            break;
        }
        List headers = MultipartReader.Companion.readHeaders(this.source);
        this.currentPart = partSource = new PartSource();
        return new Part(headers, Okio.buffer((Source)partSource));
    }

    private final long currentPartBytesRemaining(long maxResult) {
        this.source.require((long)this.crlfDashDashBoundary.size());
        long delimiterIndex = this.source.getBuffer().indexOf(this.crlfDashDashBoundary);
        return delimiterIndex == -1L ? Math.min(maxResult, this.source.getBuffer().size() - (long)this.crlfDashDashBoundary.size() + 1L) : Math.min(maxResult, delimiterIndex);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.currentPart = null;
        this.source.close();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/apollographql/apollo/internal/MultipartReader$Companion;", "", "<init>", "()V", "readHeaders", "", "Lcom/apollographql/apollo/api/http/HttpHeader;", "source", "Lokio/BufferedSource;", "apollo-runtime_debug"})
    @SourceDebugExtension(value={"SMAP\nMultipartReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipartReader.kt\ncom/apollographql/apollo/internal/MultipartReader$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        private final List<HttpHeader> readHeaders(BufferedSource source) {
            String line;
            List headers = new ArrayList();
            while (!(((CharSequence)(line = source.readUtf8LineStrict())).length() == 0)) {
                int index = StringsKt.indexOf$default((CharSequence)line, (char)':', (int)0, (boolean)false, (int)6, null);
                if (!(index != -1)) {
                    boolean bl = false;
                    String string = "Unexpected header: " + line;
                    throw new IllegalStateException(string.toString());
                }
                Collection collection = headers;
                String string = line.substring(0, index);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                String string3 = line.substring(index + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                collection.add(new HttpHeader(string2, ((Object)StringsKt.trim((CharSequence)string3)).toString()));
            }
            return headers;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000e\u001a\u00020\u000fH\u0096\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/apollographql/apollo/internal/MultipartReader$Part;", "Ljava/io/Closeable;", "Lokio/Closeable;", "headers", "", "Lcom/apollographql/apollo/api/http/HttpHeader;", "body", "Lokio/BufferedSource;", "<init>", "(Ljava/util/List;Lokio/BufferedSource;)V", "getHeaders", "()Ljava/util/List;", "getBody", "()Lokio/BufferedSource;", "close", "", "apollo-runtime_debug"})
    @ApolloInternal
    public static final class Part
    implements Closeable {
        @NotNull
        private final List<HttpHeader> headers;
        @NotNull
        private final BufferedSource body;

        public Part(@NotNull List<HttpHeader> headers, @NotNull BufferedSource body2) {
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
            this.headers = headers;
            this.body = body2;
        }

        @NotNull
        public final List<HttpHeader> getHeaders() {
            return this.headers;
        }

        @NotNull
        public final BufferedSource getBody() {
            return this.body;
        }

        @Override
        public void close() {
            this.body.close();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/apollographql/apollo/internal/MultipartReader$PartSource;", "Lokio/Source;", "<init>", "(Lcom/apollographql/apollo/internal/MultipartReader;)V", "close", "", "read", "", "sink", "Lokio/Buffer;", "byteCount", "timeout", "Lokio/Timeout;", "apollo-runtime_debug"})
    @SourceDebugExtension(value={"SMAP\nMultipartReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipartReader.kt\ncom/apollographql/apollo/internal/MultipartReader$PartSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
    private final class PartSource
    implements Source {
        public void close() {
            if (Intrinsics.areEqual((Object)MultipartReader.this.currentPart, (Object)this)) {
                MultipartReader.this.currentPart = null;
            }
        }

        public long read(@NotNull Buffer sink, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-MultipartReader$PartSource$read$22 = false;
                String $i$a$-require-MultipartReader$PartSource$read$22 = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException($i$a$-require-MultipartReader$PartSource$read$22.toString());
            }
            if (!Intrinsics.areEqual((Object)MultipartReader.this.currentPart, (Object)this)) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            long limit = MultipartReader.this.currentPartBytesRemaining(byteCount);
            return limit == 0L ? -1L : MultipartReader.this.source.read(sink, limit);
        }

        @NotNull
        public Timeout timeout() {
            return MultipartReader.this.source.timeout();
        }
    }
}

