/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized.api.internal;

import com.apollographql.apollo.api.json.JsonNumber;
import com.apollographql.apollo.cache.normalized.api.CacheKey;
import com.apollographql.apollo.cache.normalized.api.Record;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.internal._Utf8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0007J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0016\u0010\u0014\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0018\u00010\u0001j\u0002`\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/apollographql/apollo/cache/normalized/api/internal/RecordWeigher;", "", "<init>", "()V", "SIZE_OF_BOOLEAN", "", "SIZE_OF_INT", "SIZE_OF_LONG", "SIZE_OF_DOUBLE", "SIZE_OF_ARRAY_OVERHEAD", "SIZE_OF_MAP_OVERHEAD", "SIZE_OF_RECORD_OVERHEAD", "SIZE_OF_CACHE_KEY_OVERHEAD", "SIZE_OF_NULL", "byteChange", "newValue", "oldValue", "calculateBytes", "record", "Lcom/apollographql/apollo/cache/normalized/api/Record;", "weighField", "field", "Lcom/apollographql/apollo/cache/normalized/api/RecordValue;", "apollo-normalized-cache-api"})
@SourceDebugExtension(value={"SMAP\nRecordWeigher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecordWeigher.kt\ncom/apollographql/apollo/cache/normalized/api/internal/RecordWeigher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class RecordWeigher {
    @NotNull
    public static final RecordWeigher INSTANCE = new RecordWeigher();
    private static final int SIZE_OF_BOOLEAN = 16;
    private static final int SIZE_OF_INT = 4;
    private static final int SIZE_OF_LONG = 8;
    private static final int SIZE_OF_DOUBLE = 8;
    private static final int SIZE_OF_ARRAY_OVERHEAD = 16;
    private static final int SIZE_OF_MAP_OVERHEAD = 16;
    private static final int SIZE_OF_RECORD_OVERHEAD = 16;
    private static final int SIZE_OF_CACHE_KEY_OVERHEAD = 16;
    private static final int SIZE_OF_NULL = 4;

    private RecordWeigher() {
    }

    @JvmStatic
    public static final int byteChange(@Nullable Object newValue, @Nullable Object oldValue) {
        return INSTANCE.weighField(newValue) - INSTANCE.weighField(oldValue);
    }

    @JvmStatic
    public static final int calculateBytes(@NotNull Record record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        int size = 16 + _Utf8Kt.commonAsUtf8ToByteArray((String)record.getKey()).length;
        for (Map.Entry<String, Object> entry : record.getFields().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            size += _Utf8Kt.commonAsUtf8ToByteArray((String)key).length + INSTANCE.weighField(value);
        }
        return size;
    }

    private final int weighField(Object field) {
        int n;
        Object object = field;
        if (object == null) {
            n = 4;
        } else if (object instanceof String) {
            n = _Utf8Kt.commonAsUtf8ToByteArray((String)((String)field)).length;
        } else if (object instanceof Boolean) {
            n = 16;
        } else if (object instanceof Integer) {
            n = 4;
        } else if (object instanceof Long) {
            n = 8;
        } else if (object instanceof Double) {
            n = 8;
        } else if (object instanceof JsonNumber) {
            n = _Utf8Kt.commonAsUtf8ToByteArray((String)((JsonNumber)field).getValue()).length + 8;
        } else if (object instanceof Map) {
            int n2;
            Object it;
            int n3;
            Object t;
            Iterable iterable = ((Map)field).keySet();
            int n4 = 16;
            int n5 = 0;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Object t2 = t = iterator.next();
                n3 = n5;
                boolean bl = false;
                n2 = INSTANCE.weighField(it);
                n5 = n3 + n2;
            }
            n3 = n5;
            iterable = ((Map)field).values();
            n4 += n3;
            n5 = 0;
            iterator = iterable.iterator();
            while (iterator.hasNext()) {
                it = t = iterator.next();
                n3 = n5;
                boolean bl = false;
                n2 = INSTANCE.weighField(it);
                n5 = n3 + n2;
            }
            n3 = n5;
            n = n4 + n3;
        } else if (object instanceof List) {
            int n6;
            Iterable iterable = (Iterable)field;
            int n7 = 16;
            int n8 = 0;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Object t;
                Object it = t = iterator.next();
                n6 = n8;
                boolean bl = false;
                int n9 = INSTANCE.weighField(it);
                n8 = n6 + n9;
            }
            n6 = n8;
            n = n7 + n6;
        } else if (object instanceof CacheKey) {
            n = 16 + _Utf8Kt.commonAsUtf8ToByteArray((String)((CacheKey)field).getKey()).length;
        } else {
            throw new IllegalStateException(("Unknown field type in Record: '" + field + '\'').toString());
        }
        return n;
    }
}

