/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized.api;

import com.apollographql.apollo.annotations.ApolloExperimental;
import com.apollographql.apollo.api.CompiledField;
import com.apollographql.apollo.api.Executable;
import com.apollographql.apollo.cache.normalized.api.CacheResolver;
import com.apollographql.apollo.cache.normalized.api.Record;
import com.apollographql.apollo.exception.CacheMissException;
import com.apollographql.apollo.mpp.UtilsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J=\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0019\u0010\f\u001a\u0015\u0012\u0004\u0012\u00020\u000e\u0012\u000b\u0012\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/apollographql/apollo/cache/normalized/api/ReceiveDateCacheResolver;", "Lcom/apollographql/apollo/cache/normalized/api/CacheResolver;", "maxAge", "", "<init>", "(I)V", "resolveField", "", "field", "Lcom/apollographql/apollo/api/CompiledField;", "variables", "Lcom/apollographql/apollo/api/Executable$Variables;", "parent", "", "", "Lkotlin/jvm/JvmSuppressWildcards;", "parentId", "apollo-normalized-cache-api"})
@ApolloExperimental
public final class ReceiveDateCacheResolver
implements CacheResolver {
    private final int maxAge;

    public ReceiveDateCacheResolver(int maxAge) {
        this.maxAge = maxAge;
    }

    @Override
    @Nullable
    public Object resolveField(@NotNull CompiledField field, @NotNull Executable.Variables variables, @NotNull Map<String, Object> parent, @NotNull String parentId) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        String fieldKey = field.nameWithArguments(variables);
        if (!parent.containsKey(fieldKey)) {
            throw new CacheMissException(parentId, fieldKey);
        }
        if (parent instanceof Record) {
            long age;
            Long lastUpdated;
            Map<String, Long> map = ((Record)parent).getDate();
            Long l = lastUpdated = map != null ? map.get(fieldKey) : null;
            if (lastUpdated != null && (age = UtilsKt.currentTimeMillis() / (long)1000 - lastUpdated) > (long)this.maxAge) {
                throw new CacheMissException(parentId, fieldKey, true);
            }
        }
        return parent.get(fieldKey);
    }
}

