/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.http.internal;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.ExecutionContext;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.cache.http.CachingHttpInterceptor;
import com.apollographql.apollo.cache.http.HttpFetchPolicy;
import com.apollographql.apollo.cache.http.HttpFetchPolicyContext;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import java.io.IOException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ4\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u000b0\n\"\b\b\u0000\u0010\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo/cache/http/internal/HttpCacheApolloInterceptor;", "Lcom/apollographql/apollo/interceptor/ApolloInterceptor;", "apolloRequestToCacheKey", "", "", "cachingHttpInterceptor", "Lcom/apollographql/apollo/cache/http/CachingHttpInterceptor;", "<init>", "(Ljava/util/Map;Lcom/apollographql/apollo/cache/http/CachingHttpInterceptor;)V", "intercept", "Lkotlinx/coroutines/flow/Flow;", "Lcom/apollographql/apollo/api/ApolloResponse;", "D", "Lcom/apollographql/apollo/api/Operation$Data;", "request", "Lcom/apollographql/apollo/api/ApolloRequest;", "chain", "Lcom/apollographql/apollo/interceptor/ApolloInterceptorChain;", "getPolicy", "Lcom/apollographql/apollo/cache/http/HttpFetchPolicy;", "apollo-http-cache"})
public final class HttpCacheApolloInterceptor
implements ApolloInterceptor {
    @NotNull
    private final Map<String, String> apolloRequestToCacheKey;
    @NotNull
    private final CachingHttpInterceptor cachingHttpInterceptor;

    public HttpCacheApolloInterceptor(@NotNull Map<String, String> apolloRequestToCacheKey, @NotNull CachingHttpInterceptor cachingHttpInterceptor) {
        Intrinsics.checkNotNullParameter(apolloRequestToCacheKey, (String)"apolloRequestToCacheKey");
        Intrinsics.checkNotNullParameter((Object)cachingHttpInterceptor, (String)"cachingHttpInterceptor");
        this.apolloRequestToCacheKey = apolloRequestToCacheKey;
        this.cachingHttpInterceptor = cachingHttpInterceptor;
    }

    @NotNull
    public <D extends Operation.Data> Flow<ApolloResponse<D>> intercept(@NotNull ApolloRequest<D> request, @NotNull ApolloInterceptorChain chain) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        HttpFetchPolicy policy = this.getPolicy(request);
        switch (WhenMappings.$EnumSwitchMapping$0[policy.ordinal()]) {
            case 1: {
                string2 = "CACHE_FIRST";
                break;
            }
            case 2: {
                string2 = "CACHE_ONLY";
                break;
            }
            case 3: {
                string2 = "NETWORK_FIRST";
                break;
            }
            case 4: {
                string2 = "NETWORK_ONLY";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String policyStr = string2;
        ApolloRequest.Builder builder = request.newBuilder();
        Operation operation = request.getOperation();
        if (operation instanceof Query) {
            string = "query";
        } else if (operation instanceof Mutation) {
            string = "mutation";
        } else if (operation instanceof Subscription) {
            string = "subscription";
        } else {
            throw new IllegalStateException("Unknown operation type".toString());
        }
        ApolloRequest.Builder builder2 = builder.addHttpHeader("X-APOLLO-CACHE-OPERATION-TYPE", string).addHttpHeader("X-APOLLO-CACHE-FETCH-POLICY", policyStr);
        String string3 = request.getRequestUuid().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        Flow $this$intercept_u24lambda_u240 = chain.proceed(builder2.addHttpHeader("X-APOLLO-REQUEST-UUID", string3).addHttpHeader("X-APOLLO-OPERATION-NAME", request.getOperation().name()).build());
        boolean bl = false;
        return request.getOperation() instanceof Query ? FlowKt.onCompletion((Flow)FlowKt.onEach((Flow)$this$intercept_u24lambda_u240, (Function2)new Function2<ApolloResponse<D>, Continuation<? super Unit>, Object>(this, request, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ HttpCacheApolloInterceptor this$0;
            final /* synthetic */ ApolloRequest<D> $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        String string;
                        ResultKt.throwOnFailure((Object)object);
                        ApolloResponse response = (ApolloResponse)this.L$0;
                        Object object2 = HttpCacheApolloInterceptor.access$getApolloRequestToCacheKey$p(this.this$0);
                        HttpCacheApolloInterceptor httpCacheApolloInterceptor = this.this$0;
                        ApolloRequest<D> apolloRequest = this.$request;
                        Map map = object2;
                        synchronized (map) {
                            boolean bl = false;
                            string = (String)HttpCacheApolloInterceptor.access$getApolloRequestToCacheKey$p(httpCacheApolloInterceptor).get(apolloRequest.getRequestUuid().toString());
                        }
                        String cacheKey = string;
                        if (response.hasErrors() || response.exception != null && !(response.exception instanceof ApolloNetworkException)) {
                            try {
                                String string2 = cacheKey;
                                if (string2 != null) {
                                    object2 = string2;
                                    httpCacheApolloInterceptor = this.this$0;
                                    Object it = object2;
                                    boolean bl = false;
                                    HttpCacheApolloInterceptor.access$getCachingHttpInterceptor$p(httpCacheApolloInterceptor).getCache().remove((String)it);
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<ApolloResponse<D>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(ApolloResponse<D> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (Function3)new Function3<FlowCollector<? super ApolloResponse<D>>, Throwable, Continuation<? super Unit>, Object>(this, request, null){
            int label;
            final /* synthetic */ HttpCacheApolloInterceptor this$0;
            final /* synthetic */ ApolloRequest<D> $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(3, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Map map = HttpCacheApolloInterceptor.access$getApolloRequestToCacheKey$p(this.this$0);
                        HttpCacheApolloInterceptor httpCacheApolloInterceptor = this.this$0;
                        ApolloRequest<D> apolloRequest = this.$request;
                        Map map2 = map;
                        synchronized (map2) {
                            boolean bl = false;
                            HttpCacheApolloInterceptor.access$getApolloRequestToCacheKey$p(httpCacheApolloInterceptor).remove(apolloRequest.getRequestUuid().toString());
                            Unit unit = Unit.INSTANCE;
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(FlowCollector<? super ApolloResponse<D>> p1, Throwable p2, Continuation<? super Unit> p3) {
                return new /* invalid duplicate definition of identical inner class */.invokeSuspend((Object)Unit.INSTANCE);
            }
        }) : $this$intercept_u24lambda_u240;
    }

    private final HttpFetchPolicy getPolicy(ApolloRequest<?> request) {
        Object object;
        if (request.getOperation() instanceof Mutation) {
            object = HttpFetchPolicy.NetworkOnly;
        } else {
            object = (HttpFetchPolicyContext)request.getExecutionContext().get((ExecutionContext.Key)HttpFetchPolicyContext.Key);
            if (object == null || (object = ((HttpFetchPolicyContext)object).getHttpFetchPolicy()) == null) {
                object = HttpFetchPolicy.CacheFirst;
            }
        }
        return object;
    }

    public static final /* synthetic */ Map access$getApolloRequestToCacheKey$p(HttpCacheApolloInterceptor $this) {
        return $this.apolloRequestToCacheKey;
    }

    public static final /* synthetic */ CachingHttpInterceptor access$getCachingHttpInterceptor$p(HttpCacheApolloInterceptor $this) {
        return $this.cachingHttpInterceptor;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpFetchPolicy.values().length];
            try {
                nArray[HttpFetchPolicy.CacheFirst.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpFetchPolicy.CacheOnly.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpFetchPolicy.NetworkFirst.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpFetchPolicy.NetworkOnly.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

