/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.http;

import com.apollographql.apollo.api.cache.http.HttpCacheRecordEditor;
import com.apollographql.apollo.cache.http.ResponseBodyCacheSink;
import com.apollographql.apollo.cache.http.Utils;
import com.apollographql.apollo.internal.ApolloLogger;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

final class ResponseBodyProxy
extends ResponseBody {
    private final String contentType;
    private final String contentLength;
    private final Source responseBodySource;

    ResponseBodyProxy(@NotNull HttpCacheRecordEditor cacheRecordEditor, @NotNull Response sourceResponse, @NotNull ApolloLogger logger) {
        com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)cacheRecordEditor, (Object)"cacheRecordEditor == null");
        com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)sourceResponse, (Object)"sourceResponse == null");
        com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)logger, (Object)"logger == null");
        this.contentType = sourceResponse.header("Content-Type");
        this.contentLength = sourceResponse.header("Content-Length");
        this.responseBodySource = new ProxySource(cacheRecordEditor, (Source)sourceResponse.body().source(), logger);
    }

    public MediaType contentType() {
        return this.contentType != null ? MediaType.parse((String)this.contentType) : null;
    }

    public long contentLength() {
        try {
            return this.contentLength != null ? Long.parseLong(this.contentLength) : -1L;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public BufferedSource source() {
        return Okio.buffer((Source)this.responseBodySource);
    }

    private static class ProxySource
    implements Source {
        final HttpCacheRecordEditor cacheRecordEditor;
        final ResponseBodyCacheSink responseBodyCacheSink;
        final Source responseBodySource;
        final ApolloLogger logger;
        boolean closed;

        ProxySource(HttpCacheRecordEditor cacheRecordEditor, Source responseBodySource, final ApolloLogger logger) {
            this.cacheRecordEditor = cacheRecordEditor;
            this.responseBodySource = responseBodySource;
            this.logger = logger;
            this.responseBodyCacheSink = new ResponseBodyCacheSink(Okio.buffer((Sink)cacheRecordEditor.bodySink())){

                @Override
                void onException(Exception e) {
                    ProxySource.this.abortCacheQuietly();
                    logger.w((Throwable)e, "Operation failed", new Object[0]);
                }
            };
        }

        public long read(Buffer sink, long byteCount) throws IOException {
            long bytesRead;
            try {
                bytesRead = this.responseBodySource.read(sink, byteCount);
            }
            catch (IOException e) {
                if (!this.closed) {
                    this.closed = true;
                    this.abortCacheQuietly();
                }
                throw e;
            }
            if (bytesRead == -1L) {
                if (!this.closed) {
                    this.closed = true;
                    this.commitCache();
                }
                return -1L;
            }
            this.responseBodyCacheSink.copyFrom(sink, sink.size() - bytesRead, bytesRead);
            return bytesRead;
        }

        public Timeout timeout() {
            return this.responseBodySource.timeout();
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (Utils.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.responseBodySource.close();
                this.commitCache();
            } else {
                this.responseBodySource.close();
                this.abortCacheQuietly();
            }
        }

        private void commitCache() {
            try {
                this.responseBodyCacheSink.close();
                this.cacheRecordEditor.commit();
            }
            catch (Exception e) {
                Utils.closeQuietly((Closeable)((Object)this.responseBodyCacheSink));
                this.abortCacheQuietly();
                this.logger.e((Throwable)e, "Failed to commit cache changes", new Object[0]);
            }
        }

        void abortCacheQuietly() {
            Utils.closeQuietly((Closeable)((Object)this.responseBodyCacheSink));
            try {
                this.cacheRecordEditor.abort();
            }
            catch (Exception ignore) {
                this.logger.w((Throwable)ignore, "Failed to abort cache edit", new Object[0]);
            }
        }
    }
}

