/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.http;

import com.apollographql.apollo.cache.http.ApolloHttpCache;
import com.apollographql.apollo.cache.http.Utils;
import com.apollographql.apollo.internal.ApolloLogger;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

final class HttpCacheInterceptor
implements Interceptor {
    private final ApolloHttpCache cache;
    private final ApolloLogger logger;

    HttpCacheInterceptor(ApolloHttpCache cache, ApolloLogger logger) {
        this.cache = (ApolloHttpCache)com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)cache, (Object)"cache == null");
        this.logger = (ApolloLogger)com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)logger, (Object)"logger == null");
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (Utils.shouldSkipCache(request)) {
            this.logger.d("Skip http cache for request: %s", new Object[]{request});
            return chain.proceed(request);
        }
        if (Utils.shouldSkipNetwork(request)) {
            this.logger.d("Read http cache only for request: %s", new Object[]{request});
            return this.cacheOnlyResponse(request);
        }
        if (Utils.isNetworkOnly(request)) {
            this.logger.d("Skip http cache network only request: %s", new Object[]{request});
            return this.networkOnly(request, chain);
        }
        if (Utils.isNetworkFirst(request)) {
            this.logger.d("Network first for request: %s", new Object[]{request});
            return this.networkFirst(request, chain);
        }
        this.logger.d("Cache first for request: %s", new Object[]{request});
        return this.cacheFirst(request, chain);
    }

    private Response cacheOnlyResponse(Request request) throws IOException {
        Response cacheResponse = this.cachedResponse(request);
        if (cacheResponse == null) {
            this.logCacheMiss(request);
            return Utils.unsatisfiableCacheRequest(request);
        }
        this.logCacheHit(request);
        return cacheResponse.newBuilder().cacheResponse(Utils.strip(cacheResponse)).build();
    }

    private Response networkOnly(Request request, Interceptor.Chain chain) throws IOException {
        String cacheKey = request.header("X-APOLLO-CACHE-KEY");
        Response networkResponse = Utils.withServedDateHeader(chain.proceed(request));
        if (Utils.isPrefetchResponse(request)) {
            return this.prefetch(networkResponse, cacheKey);
        }
        if (networkResponse.isSuccessful()) {
            this.logger.d("Network success, skip http cache for request: %s, with cache key: %s", new Object[]{request, cacheKey});
            return this.cache.cacheProxy(networkResponse, cacheKey);
        }
        return networkResponse;
    }

    private Response networkFirst(Request request, Interceptor.Chain chain) throws IOException {
        IOException rethrowException;
        String cacheKey = request.header("X-APOLLO-CACHE-KEY");
        Response networkResponse = null;
        try {
            networkResponse = Utils.withServedDateHeader(chain.proceed(request));
            if (networkResponse.isSuccessful()) {
                this.logger.d("Network success, skip http cache for request: %s, with cache key: %s", new Object[]{request, cacheKey});
                return this.cache.cacheProxy(networkResponse, cacheKey);
            }
            rethrowException = null;
        }
        catch (IOException e) {
            rethrowException = e;
        }
        Response cachedResponse = this.cachedResponse(request);
        if (cachedResponse == null) {
            this.logCacheMiss(request);
            if (rethrowException != null) {
                throw rethrowException;
            }
            return networkResponse;
        }
        this.logCacheHit(request);
        return cachedResponse.newBuilder().cacheResponse(Utils.strip(cachedResponse)).networkResponse(Utils.strip(networkResponse)).request(request).build();
    }

    private Response cacheFirst(Request request, Interceptor.Chain chain) throws IOException {
        Response cachedResponse = this.cachedResponse(request);
        if (cachedResponse != null) {
            this.logCacheHit(request);
            return cachedResponse.newBuilder().cacheResponse(Utils.strip(cachedResponse)).request(request).build();
        }
        this.logCacheMiss(request);
        String cacheKey = request.header("X-APOLLO-CACHE-KEY");
        Response networkResponse = Utils.withServedDateHeader(chain.proceed(request));
        if (Utils.isPrefetchResponse(request)) {
            return this.prefetch(networkResponse, cacheKey);
        }
        if (networkResponse.isSuccessful()) {
            return this.cache.cacheProxy(networkResponse, cacheKey);
        }
        return networkResponse;
    }

    private Response prefetch(Response networkResponse, String cacheKey) throws IOException {
        if (!networkResponse.isSuccessful()) {
            return networkResponse;
        }
        try {
            this.cache.write(networkResponse, cacheKey);
        }
        finally {
            networkResponse.close();
        }
        Response cachedResponse = this.cache.read(cacheKey);
        if (cachedResponse == null) {
            throw new IOException("failed to read prefetch cache response");
        }
        return cachedResponse.newBuilder().networkResponse(Utils.strip(networkResponse)).build();
    }

    private Response cachedResponse(Request request) {
        String cacheKey = request.header("X-APOLLO-CACHE-KEY");
        Response cachedResponse = this.cache.read(cacheKey, Utils.shouldExpireAfterRead(request));
        if (cachedResponse == null) {
            return null;
        }
        if (Utils.isStale(request, cachedResponse)) {
            Utils.closeQuietly(cachedResponse);
            return null;
        }
        return cachedResponse;
    }

    private void logCacheHit(Request request) {
        String cacheKey = request.header("X-APOLLO-CACHE-KEY");
        this.logger.d("Cache HIT for request: %s, with cache key: %s", new Object[]{request, cacheKey});
    }

    private void logCacheMiss(Request request) {
        String cacheKey = request.header("X-APOLLO-CACHE-KEY");
        this.logger.d("Cache MISS for request: %s, with cache key: %s", new Object[]{request, cacheKey});
    }
}

