/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.internal;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Utils {
    private Utils() {
    }

    @Nonnull
    public static <T> T checkNotNull(T reference, @Nullable Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static <E> boolean areDisjoint(Set<E> setOne, Set<E> setTwo) {
        if (setOne == null || setTwo == null) {
            return true;
        }
        Set<E> smallerSet = setOne;
        Set<E> largerSet = setTwo;
        if (setOne.size() > setTwo.size()) {
            smallerSet = setTwo;
            largerSet = setOne;
        }
        for (E el : smallerSet) {
            if (!largerSet.contains(el)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }
}

