/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdErrorCode;
import com.apicatalog.jsonld.api.JsonLdOptions;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.RemoteDocument;
import com.apicatalog.jsonld.flattening.Flattening;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.loader.LoadDocumentOptions;
import com.apicatalog.jsonld.processor.CompactionProcessor;
import com.apicatalog.jsonld.processor.ExpansionProcessor;
import java.net.URI;
import javax.json.JsonArray;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public final class FlatteningProcessor {
    private FlatteningProcessor() {
    }

    public static final JsonStructure flatten(URI input, URI context, JsonLdOptions options) throws JsonLdError {
        if (context == null) {
            return FlatteningProcessor.flatten(input, (JsonStructure)null, options);
        }
        RemoteDocument jsonContext = options.getDocumentLoader().loadDocument(context, new LoadDocumentOptions());
        return FlatteningProcessor.flatten(input, jsonContext.getDocument().getJsonStructure(), options);
    }

    public static final JsonStructure flatten(URI input, JsonStructure context, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
        }
        RemoteDocument remoteDocument = options.getDocumentLoader().loadDocument(input, new LoadDocumentOptions().setExtractAllScripts(options.isExtractAllScripts()));
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
        }
        return FlatteningProcessor.flatten(remoteDocument, context, options);
    }

    public static final JsonStructure flatten(RemoteDocument input, JsonStructure context, JsonLdOptions options) throws JsonLdError {
        JsonLdOptions expansionOptions = new JsonLdOptions(options);
        expansionOptions.setOrdered(false);
        JsonArray expandedInput = ExpansionProcessor.expand(input, expansionOptions, false);
        JsonArray flattenedOutput = Flattening.with((JsonStructure)expandedInput).ordered(options.isOrdered()).flatten();
        if (JsonUtils.isNotNull((JsonValue)context)) {
            RemoteDocument document = new RemoteDocument();
            document.setDocument(Document.of((JsonStructure)flattenedOutput));
            JsonLdOptions compactionOptions = new JsonLdOptions(options);
            if (options.getBase() != null) {
                compactionOptions.setBase(options.getBase());
            } else if (options.isCompactArrays()) {
                compactionOptions.setBase(input.getDocumentUrl());
            }
            flattenedOutput = CompactionProcessor.compact(document, context, compactionOptions);
        }
        return flattenedOutput;
    }
}

