/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.api.builder;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdOptions;
import com.apicatalog.jsonld.lang.Version;
import com.apicatalog.jsonld.loader.LoadDocumentCallback;
import com.apicatalog.jsonld.processor.ExpansionProcessor;
import java.net.URI;
import javax.json.JsonArray;

public final class ExpansionApi {
    private final URI documentUri;
    private JsonLdOptions options;

    public ExpansionApi(URI documentUri) {
        this.documentUri = documentUri;
        this.options = new JsonLdOptions();
    }

    public ExpansionApi options(JsonLdOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Parameter 'options' is null.");
        }
        this.options = options;
        return this;
    }

    public ExpansionApi context(URI contextUri) {
        this.options.setExpandContext(contextUri);
        return this;
    }

    public ExpansionApi context(String contextUri) {
        return this.context(URI.create(contextUri));
    }

    public ExpansionApi mode(Version processingMode) {
        this.options.setProcessingMode(processingMode);
        return this;
    }

    public ExpansionApi base(URI baseUri) {
        this.options.setBase(baseUri);
        return this;
    }

    public ExpansionApi base(String baseUri) {
        return this.base(URI.create(baseUri));
    }

    public ExpansionApi loader(LoadDocumentCallback loader) {
        this.options.setDocumentLoader(loader);
        return this;
    }

    public ExpansionApi ordered(boolean enable) {
        this.options.setOrdered(enable);
        return this;
    }

    public ExpansionApi ordered() {
        return this.ordered(true);
    }

    public JsonArray get() throws JsonLdError {
        return ExpansionProcessor.expand(this.documentUri, this.options);
    }
}

