/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld;

import com.apicatalog.jsonld.api.builder.CompactionApi;
import com.apicatalog.jsonld.api.builder.ExpansionApi;
import com.apicatalog.jsonld.api.builder.FlatteningApi;
import com.apicatalog.jsonld.api.builder.FramingApi;
import com.apicatalog.jsonld.api.builder.FromRdfApi;
import com.apicatalog.jsonld.api.builder.ToRdfApi;
import com.apicatalog.jsonld.uri.UriUtils;
import com.apicatalog.rdf.RdfDataset;
import java.net.URI;
import javax.json.JsonStructure;

public final class JsonLd {
    private static final String DOCUMENT_LOCATION_PARAM_NAME = "documentLocation";
    private static final String DOCUMENT_URI_PARAM_NAME = "documentUri";

    private JsonLd() {
    }

    public static final ExpansionApi expand(String documentLocation) {
        JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME);
        return new ExpansionApi(URI.create(documentLocation));
    }

    public static final ExpansionApi expand(URI documentUri) {
        JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME);
        return new ExpansionApi(documentUri);
    }

    public static final CompactionApi compact(String documentLocation, String contextLocation) {
        JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME);
        JsonLd.assertLocation(contextLocation, "contextLocation");
        return JsonLd.compact(URI.create(documentLocation), URI.create(contextLocation));
    }

    public static final CompactionApi compact(URI documentUri, URI contextUri) {
        JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME);
        JsonLd.assertUri(contextUri, "contextUri");
        return new CompactionApi(documentUri, contextUri);
    }

    public static final CompactionApi compact(String documentLocation, JsonStructure context) {
        JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME);
        if (context == null) {
            throw new IllegalArgumentException("A context is null.");
        }
        return new CompactionApi(URI.create(documentLocation), context);
    }

    public static final CompactionApi compact(URI documentUri, JsonStructure context) {
        JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME);
        if (context == null) {
            throw new IllegalArgumentException("A context is null.");
        }
        return new CompactionApi(documentUri, context);
    }

    public static final FlatteningApi flatten(String documentLocation) {
        JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME);
        return new FlatteningApi(URI.create(documentLocation));
    }

    public static final FlatteningApi flatten(URI documentUri) {
        JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME);
        return new FlatteningApi(documentUri);
    }

    public static final FramingApi frame(URI documentUri, URI frameUri) {
        JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME);
        JsonLd.assertUri(frameUri, "frameUri");
        return new FramingApi(documentUri, frameUri);
    }

    public static final ToRdfApi toRdf(String documentLocation) {
        JsonLd.assertLocation(documentLocation, DOCUMENT_LOCATION_PARAM_NAME);
        return new ToRdfApi(URI.create(documentLocation));
    }

    public static final ToRdfApi toRdf(URI documentUri) {
        JsonLd.assertUri(documentUri, DOCUMENT_URI_PARAM_NAME);
        return new ToRdfApi(documentUri);
    }

    public static final FromRdfApi fromRdf(RdfDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("A dataset is null.");
        }
        return new FromRdfApi(dataset);
    }

    private static final void assertLocation(String location, String param) {
        if (location == null || location.isBlank()) {
            throw new IllegalArgumentException("'" + param + "' is null or blank string.");
        }
        if (UriUtils.isNotAbsoluteUri(location)) {
            throw new IllegalArgumentException("'" + param + "' is not an absolute URI [" + location + "].");
        }
    }

    private static final void assertUri(URI uri, String param) {
        if (uri == null) {
            throw new IllegalArgumentException("'" + param + "' is null.");
        }
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("'" + param + "' is not an absolute URI [" + uri + "].");
        }
    }
}

