/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.natives.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class NativeUtils {
    private NativeUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibraryFromJar(String path, String libraryTargetFileName) throws IOException {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String[] parts = path.split("/");
        String filename = parts.length > 1 ? parts[parts.length - 1] : null;
        String prefix = "";
        if (filename != null) {
            parts = filename.split("\\.", 2);
            prefix = parts[0];
        }
        if (filename == null || prefix.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        Path tempDir = Files.createTempDirectory("Aparapi", new FileAttribute[0]);
        tempDir.toFile().deleteOnExit();
        if (!tempDir.toFile().exists()) {
            throw new FileNotFoundException("Directory " + tempDir.toAbsolutePath() + " does not exist.");
        }
        Path libraryFilePath = tempDir.resolve(libraryTargetFileName);
        Path temp = Files.createFile(libraryFilePath, new FileAttribute[0]);
        temp.toFile().deleteOnExit();
        if (!temp.toFile().exists()) {
            throw new FileNotFoundException("File " + temp.toAbsolutePath() + " does not exist.");
        }
        byte[] buffer = new byte[1024];
        InputStream is = NativeUtils.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("File " + path + " was not found inside JAR.");
        }
        FileOutputStream os = new FileOutputStream(temp.toFile());
        try {
            int readBytes;
            while ((readBytes = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, readBytes);
            }
        }
        finally {
            ((OutputStream)os).close();
            is.close();
        }
        System.load(temp.toAbsolutePath().toString());
    }
}

