/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.natives;

import com.aparapi.natives.util.NativeUtils;
import java.io.IOException;

public class NativeLoader {
    private static final String ARCH = System.getProperty("os.arch").toLowerCase();
    private static final String OS = System.getProperty("os.name").toLowerCase();

    private static void loadLibrariesFromJarsInProperOrder(String[][] librariesAndJars) throws IOException {
        for (String[] libraryAndJar : librariesAndJars) {
            NativeUtils.loadLibraryFromJar(libraryAndJar[0], libraryAndJar[1]);
        }
    }

    public static void load() throws IOException {
        if (NativeLoader.isUnix()) {
            if (NativeLoader.isArm()) {
                if (NativeLoader.is64Bit()) {
                    NativeUtils.loadLibraryFromJar("/linux/libaparapi_aarch64.so", "libaparapi.so");
                } else {
                    NativeUtils.loadLibraryFromJar("/linux/libaparapi_armhf.so", "libaparapi.so");
                }
            } else if (NativeLoader.is64Bit()) {
                NativeUtils.loadLibraryFromJar("/linux/libaparapi_x86_64.so", "libaparapi.so");
            } else {
                NativeUtils.loadLibraryFromJar("/linux/libaparapi_x86.so", "libaparapi.so");
            }
        } else if (NativeLoader.isMac() && NativeLoader.is64Bit()) {
            NativeUtils.loadLibraryFromJar("/osx/libaparapi_x86_64.dylib", "libaparapi.dylib");
        } else if (NativeLoader.isWindows() && NativeLoader.is64Bit()) {
            String[][] librariesAndJars = new String[][]{{"/win/libgcc_s_seh_x86_64.dll", "libgcc_s_seh-1.dll"}, {"/win/libstdc++-6_x86_64.dll", "libstdc++-6.dll"}, {"/win/libaparapi_x86_64.dll", "libaparapi.dll"}};
            NativeLoader.loadLibrariesFromJarsInProperOrder(librariesAndJars);
        } else if (NativeLoader.isWindows() && NativeLoader.is32Bit()) {
            String[][] librariesAndJars = new String[][]{{"/win/libgcc_s_sjlj_x86.dll", "libgcc_s_sjlj-1.dll"}, {"/win/libstdc++-6_x86.dll", "libstdc++-6.dll"}, {"/win/libaparapi_x86.dll", "libaparapi.dll"}};
            NativeLoader.loadLibrariesFromJarsInProperOrder(librariesAndJars);
        } else {
            throw new IOException("System is not compatible with any of the known native libraries.");
        }
    }

    private static boolean isWindows() {
        return OS.contains("win");
    }

    private static boolean isMac() {
        return OS.contains("mac");
    }

    private static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }

    private static boolean isSolaris() {
        return OS.contains("sunos");
    }

    private static boolean isArm() {
        return ARCH.startsWith("arm") || ARCH.startsWith("aarch64");
    }

    private static boolean is64Bit() {
        return ARCH.contains("64");
    }

    private static boolean is32Bit() {
        return !NativeLoader.is64Bit();
    }
}

