/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types;

import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.data.async.QueueFactories;
import com.aol.cyclops.data.async.QueueFactory;
import com.aol.cyclops.types.Foldable;
import com.aol.cyclops.types.Functor;
import com.aol.cyclops.types.Traversable;
import com.aol.cyclops.types.futurestream.Continuation;
import com.aol.cyclops.types.stream.ConvertableSequence;
import com.aol.cyclops.types.stream.reactive.QueueBasedSubscriber;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jooq.lambda.Collectable;
import org.reactivestreams.Publisher;

public interface IterableFunctor<T>
extends Iterable<T>,
Functor<T>,
Foldable<T>,
Traversable<T>,
ConvertableSequence<T> {
    default public ReactiveSeq<T> mergePublisher(Collection<? extends Publisher<T>> publishers) {
        return this.mergePublisher(publishers, QueueFactories.boundedQueue(5000));
    }

    default public ReactiveSeq<T> mergePublisher(Collection<? extends Publisher<T>> publishers, QueueFactory<T> factory2) {
        QueueBasedSubscriber.Counter c = new QueueBasedSubscriber.Counter();
        c.active.set(publishers.size() + 1);
        QueueBasedSubscriber<T> init = QueueBasedSubscriber.subscriber(factory2, c, publishers.size());
        Supplier<Continuation> sp = () -> {
            this.subscribe(init);
            for (Publisher next : publishers) {
                next.subscribe(QueueBasedSubscriber.subscriber(init.getQueue(), c, publishers.size()));
            }
            init.close();
            return Continuation.empty();
        };
        Continuation continuation = new Continuation(sp);
        init.addContinuation(continuation);
        return ReactiveSeq.fromStream(init.jdkStream());
    }

    default public <R> ReactiveSeq<R> flatMapPublisher(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.flatMapPublisher(mapper, 10000);
    }

    default public <R> ReactiveSeq<R> flatMapPublisher(Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency) {
        return this.flatMapPublisher(mapper, maxConcurrency, QueueFactories.boundedQueue(5000));
    }

    default public <R> ReactiveSeq<R> flatMapPublisher(Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, QueueFactory<R> factory2) {
        QueueBasedSubscriber.Counter c = new QueueBasedSubscriber.Counter();
        QueueBasedSubscriber init = QueueBasedSubscriber.subscriber(factory2, c, maxConcurrency);
        ReactiveSeq stream = this.stream();
        Supplier<Continuation> sp = () -> {
            stream.map(mapper).forEachEvent(p -> {
                c.active.incrementAndGet();
                p.subscribe(QueueBasedSubscriber.subscriber(init.getQueue(), c, maxConcurrency));
            }, i -> {}, () -> init.close());
            return Continuation.empty();
        };
        Continuation continuation = new Continuation(sp);
        init.addContinuation(continuation);
        return ReactiveSeq.fromStream(init.jdkStream());
    }

    public <U> IterableFunctor<U> unitIterator(Iterator<U> var1);

    @Override
    public <R> IterableFunctor<R> map(Function<? super T, ? extends R> var1);

    @Override
    default public ReactiveSeq<T> stream() {
        return ReactiveSeq.fromIterable(this);
    }

    default public Collectable<T> collectable() {
        return this.stream().collectable();
    }
}

