/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.react.collectors.lazy;

import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.react.Status;
import com.aol.cyclops.util.SimpleTimer;
import com.aol.cyclops.util.ThrowsSoftened;
import java.beans.ConstructorProperties;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.pcollections.ConsPStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Blocker<U> {
    private static final Logger log = LoggerFactory.getLogger(Blocker.class);
    private final List<CompletableFuture> lastActive;
    private final Optional<Consumer<Throwable>> errorHandler;
    private final CompletableFuture<List<U>> promise = new CompletableFuture();
    private final SimpleTimer timer = new SimpleTimer();
    private final AtomicInteger completed = new AtomicInteger();
    private final AtomicInteger errors = new AtomicInteger();
    private final Queue<U> currentResults = new ConcurrentLinkedQueue<U>();

    @ThrowsSoftened(value={InterruptedException.class, ExecutionException.class})
    public ListX<U> block(Predicate<Status> breakout) {
        if (this.lastActive.size() == 0) {
            return ListX.empty();
        }
        this.lastActive.forEach(f -> f.whenComplete((result, ex) -> this.testBreakoutConditionsBeforeUnblockingCurrentThread(breakout, result, (Throwable)ex)));
        return ListX.fromIterable((Iterable)this.promise.join());
    }

    private Status buildStatus(Throwable ex) {
        if (ex != null) {
            this.errors.incrementAndGet();
        } else {
            this.completed.incrementAndGet();
        }
        return new Status(this.completed.get(), this.errors.get(), this.lastActive.size(), this.timer.getElapsedNanoseconds(), ConsPStack.from(this.currentResults));
    }

    private void testBreakoutConditionsBeforeUnblockingCurrentThread(Predicate<Status> breakout, Object result, Throwable ex) {
        if (result != null) {
            this.currentResults.add(result);
        }
        Status status = this.buildStatus(ex);
        if (ex != null) {
            this.errorHandler.ifPresent(handler -> handler.accept(((Exception)ex).getCause()));
        }
        if (this.breakoutConditionsMet(breakout, status) || this.allResultsReturned(status.getCompleted() + status.getErrors())) {
            this.promise.complete(new LinkedList<U>(this.currentResults));
        }
    }

    private boolean allResultsReturned(int localComplete) {
        return localComplete == this.lastActive.size();
    }

    private boolean breakoutConditionsMet(Predicate<Status> breakout, Status status) {
        return breakout.test(status);
    }

    @ConstructorProperties(value={"lastActive", "errorHandler"})
    public Blocker(List<CompletableFuture> lastActive, Optional<Consumer<Throwable>> errorHandler) {
        this.lastActive = lastActive;
        this.errorHandler = errorHandler;
    }
}

