/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.react.collectors.lazy;

import com.aol.cyclops.internal.react.async.future.FastFuture;
import com.aol.cyclops.react.collectors.lazy.LazyResultConsumer;
import com.aol.cyclops.react.collectors.lazy.MaxActive;
import com.aol.cyclops.types.futurestream.BlockingStream;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BatchingCollector<T>
implements LazyResultConsumer<T> {
    private final Collection<FastFuture<T>> results;
    private final List<FastFuture<T>> active = new ArrayList<FastFuture<T>>();
    private final MaxActive maxActive;
    private final BlockingStream<T> blocking;

    public BatchingCollector(MaxActive maxActive, BlockingStream<T> blocking) {
        this.maxActive = maxActive;
        this.results = null;
        this.blocking = blocking;
    }

    @Override
    public void accept(FastFuture<T> t) {
        this.active.add(t);
        if (this.active.size() > this.maxActive.getMaxActive()) {
            while (this.active.size() > this.maxActive.getReduceTo()) {
                List toRemove = this.active.stream().filter(cf -> cf.isDone()).collect(Collectors.toList());
                this.active.removeAll(toRemove);
                this.results.addAll(toRemove);
                if (this.active.size() <= this.maxActive.getReduceTo()) continue;
                CompletableFuture promise = new CompletableFuture();
                FastFuture.xOf(this.active.size() - this.maxActive.getReduceTo(), () -> promise.complete(true), this.active.toArray(new FastFuture[0]));
                promise.join();
            }
        }
    }

    @Override
    public void block(Function<FastFuture<T>, T> safeJoin) {
        if (this.active.size() == 0) {
            return;
        }
        this.active.stream().peek(f -> safeJoin.apply((FastFuture)f)).forEach(a -> {});
    }

    @Override
    public Collection<FastFuture<T>> getResults() {
        return this.results;
    }

    @Override
    public Collection<FastFuture<T>> getAllResults() {
        this.results.addAll(this.active);
        this.active.clear();
        return this.results;
    }

    public static <T> BatchingCollectorBuilder<T> builder() {
        return new BatchingCollectorBuilder();
    }

    @Override
    public BatchingCollector<T> withResults(Collection<FastFuture<T>> results) {
        return this.results == results ? this : new BatchingCollector<T>(results, this.maxActive, this.blocking);
    }

    public BatchingCollector<T> withMaxActive(MaxActive maxActive) {
        return this.maxActive == maxActive ? this : new BatchingCollector<T>(this.results, maxActive, this.blocking);
    }

    public BatchingCollector<T> withBlocking(BlockingStream<T> blocking) {
        return this.blocking == blocking ? this : new BatchingCollector<T>(this.results, this.maxActive, blocking);
    }

    @ConstructorProperties(value={"results", "maxActive", "blocking"})
    public BatchingCollector(Collection<FastFuture<T>> results, MaxActive maxActive, BlockingStream<T> blocking) {
        this.results = results;
        this.maxActive = maxActive;
        this.blocking = blocking;
    }

    public MaxActive getMaxActive() {
        return this.maxActive;
    }

    public BlockingStream<T> getBlocking() {
        return this.blocking;
    }

    public static class BatchingCollectorBuilder<T> {
        private Collection<FastFuture<T>> results;
        private MaxActive maxActive;
        private BlockingStream<T> blocking;

        BatchingCollectorBuilder() {
        }

        public BatchingCollectorBuilder<T> results(Collection<FastFuture<T>> results) {
            this.results = results;
            return this;
        }

        public BatchingCollectorBuilder<T> maxActive(MaxActive maxActive) {
            this.maxActive = maxActive;
            return this;
        }

        public BatchingCollectorBuilder<T> blocking(BlockingStream<T> blocking) {
            this.blocking = blocking;
            return this;
        }

        public BatchingCollector<T> build() {
            return new BatchingCollector<T>(this.results, this.maxActive, this.blocking);
        }

        public String toString() {
            return "BatchingCollector.BatchingCollectorBuilder(results=" + this.results + ", maxActive=" + this.maxActive + ", blocking=" + this.blocking + ")";
        }
    }
}

