/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.stream.operators;

import com.aol.cyclops.util.stream.StreamUtils;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Stream;

public class OnePerOperator<T> {
    private final Stream<T> stream;

    public Stream<T> onePer(long time, TimeUnit t) {
        final Iterator it = this.stream.iterator();
        final long next = t.toNanos(time);
        return StreamUtils.stream(new Iterator<T>(){
            volatile long last = -1L;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                Object nextValue = it.next();
                long sleepFor = next - (System.nanoTime() - this.last);
                LockSupport.parkNanos(sleepFor);
                this.last = System.nanoTime();
                return nextValue;
            }
        });
    }

    @ConstructorProperties(value={"stream"})
    public OnePerOperator(Stream<T> stream) {
        this.stream = stream;
    }
}

