/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.stream;

import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.internal.stream.BaseFutureOperationsImpl;
import com.aol.cyclops.internal.stream.FutureStreamUtils;
import com.aol.cyclops.types.stream.reactive.ReactiveTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class ReactiveSeqFutureOpterationsImpl<T>
extends BaseFutureOperationsImpl<T> {
    public ReactiveSeqFutureOpterationsImpl(Executor exec, ReactiveSeq<T> stream) {
        super(exec, stream);
    }

    @Override
    public <X extends Throwable> ReactiveTask forEachX(long numberOfElements, Consumer<? super T> consumer) {
        return new ReactiveTask(this.getExec(), FutureStreamUtils.forEachX(this.getStream(), numberOfElements, consumer).map2(r -> CompletableFuture.runAsync(r, this.getExec())));
    }

    @Override
    public <X extends Throwable> ReactiveTask forEachXWithError(long numberOfElements, Consumer<? super T> consumer, Consumer<? super Throwable> consumerError) {
        return new ReactiveTask(this.getExec(), FutureStreamUtils.forEachXWithError(this.getStream(), numberOfElements, consumer, consumerError).map2(r -> CompletableFuture.runAsync(r, this.getExec())));
    }

    @Override
    public <X extends Throwable> ReactiveTask forEachXEvents(long numberOfElements, Consumer<? super T> consumer, Consumer<? super Throwable> consumerError, Runnable onComplete) {
        return new ReactiveTask(this.getExec(), FutureStreamUtils.forEachXEvents(this.getStream(), numberOfElements, consumer, consumerError, onComplete).map2(r -> CompletableFuture.runAsync(r, this.getExec())));
    }

    @Override
    public <X extends Throwable> ReactiveTask forEachWithError(Consumer<? super T> consumerElement, Consumer<? super Throwable> consumerError) {
        return new ReactiveTask(this.getExec(), FutureStreamUtils.forEachWithError(this.getStream(), consumerElement, consumerError).map2(r -> CompletableFuture.runAsync(r, this.getExec())));
    }

    @Override
    public <X extends Throwable> ReactiveTask forEachEvent(Consumer<? super T> consumerElement, Consumer<? super Throwable> consumerError, Runnable onComplete) {
        return new ReactiveTask(this.getExec(), FutureStreamUtils.forEachEvent(this.getStream(), consumerElement, consumerError, onComplete).map2(r -> CompletableFuture.runAsync(r, this.getExec())));
    }
}

