/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.react.stream.traits.future.operators;

import com.aol.cyclops.types.futurestream.LazyFutureStream;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple3;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class LazyFutureStreamUtils {
    public static <T, X extends Throwable> Tuple3<CompletableFuture<Subscription>, Runnable, CompletableFuture<Boolean>> forEachX(LazyFutureStream<T> stream, final long x, final Consumer<? super T> consumerElement) {
        final CompletableFuture subscription = new CompletableFuture();
        final CompletableFuture streamCompleted = new CompletableFuture();
        return Tuple.tuple(subscription, () -> stream.subscribe((Subscriber)new Subscriber<T>(){

            public void onSubscribe(Subscription s) {
                Objects.requireNonNull(s);
                s.request(x);
                subscription.complete(s);
            }

            public void onNext(T t) {
                consumerElement.accept(t);
            }

            public void onError(Throwable t) {
            }

            public void onComplete() {
                streamCompleted.complete(true);
            }
        }), streamCompleted);
    }

    public static <T, X extends Throwable> Tuple3<CompletableFuture<Subscription>, Runnable, CompletableFuture<Boolean>> forEachXWithError(LazyFutureStream<T> stream, final long x, final Consumer<? super T> consumerElement, final Consumer<? super Throwable> consumerError) {
        final CompletableFuture subscription = new CompletableFuture();
        final CompletableFuture streamCompleted = new CompletableFuture();
        return Tuple.tuple(subscription, () -> stream.subscribe((Subscriber)new Subscriber<T>(){

            public void onSubscribe(Subscription s) {
                Objects.requireNonNull(s);
                s.request(x);
                subscription.complete(s);
            }

            public void onNext(T t) {
                consumerElement.accept(t);
            }

            public void onError(Throwable t) {
                consumerError.accept(t);
            }

            public void onComplete() {
                streamCompleted.complete(true);
            }
        }), streamCompleted);
    }

    public static <T, X extends Throwable> Tuple3<CompletableFuture<Subscription>, Runnable, CompletableFuture<Boolean>> forEachXEvents(LazyFutureStream<T> stream, final long x, final Consumer<? super T> consumerElement, final Consumer<? super Throwable> consumerError, final Runnable onComplete) {
        final CompletableFuture subscription = new CompletableFuture();
        final CompletableFuture streamCompleted = new CompletableFuture();
        return Tuple.tuple(subscription, () -> stream.subscribe((Subscriber)new Subscriber<T>(){

            public void onSubscribe(Subscription s) {
                Objects.requireNonNull(s);
                s.request(x);
                subscription.complete(s);
            }

            public void onNext(T t) {
                consumerElement.accept(t);
            }

            public void onError(Throwable t) {
                consumerError.accept(t);
            }

            public void onComplete() {
                streamCompleted.complete(true);
                onComplete.run();
            }
        }), streamCompleted);
    }

    public static <T, X extends Throwable> Tuple3<CompletableFuture<Subscription>, Runnable, CompletableFuture<Boolean>> forEachWithError(LazyFutureStream<T> stream, final Consumer<? super T> consumerElement, final Consumer<? super Throwable> consumerError) {
        final CompletableFuture subscription = new CompletableFuture();
        final CompletableFuture streamCompleted = new CompletableFuture();
        return Tuple.tuple(subscription, () -> stream.subscribe((Subscriber)new Subscriber<T>(){

            public void onSubscribe(Subscription s) {
                Objects.requireNonNull(s);
                subscription.complete(s);
                s.request(Long.MAX_VALUE);
            }

            public void onNext(T t) {
                consumerElement.accept(t);
            }

            public void onError(Throwable t) {
                consumerError.accept(t);
            }

            public void onComplete() {
                streamCompleted.complete(true);
            }
        }), streamCompleted);
    }

    public static <T, X extends Throwable> Tuple3<CompletableFuture<Subscription>, Runnable, CompletableFuture<Boolean>> forEachEvent(LazyFutureStream<T> stream, final Consumer<? super T> consumerElement, final Consumer<? super Throwable> consumerError, final Runnable onComplete) {
        final CompletableFuture subscription = new CompletableFuture();
        final CompletableFuture streamCompleted = new CompletableFuture();
        return Tuple.tuple(subscription, () -> stream.subscribe((Subscriber)new Subscriber<T>(){

            public void onSubscribe(Subscription s) {
                Objects.requireNonNull(s);
                subscription.complete(s);
                s.request(Long.MAX_VALUE);
            }

            public void onNext(T t) {
                consumerElement.accept(t);
            }

            public void onError(Throwable t) {
                consumerError.accept(t);
            }

            public void onComplete() {
                streamCompleted.complete(true);
                onComplete.run();
            }
        }), streamCompleted);
    }
}

