/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.react.stream;

import com.aol.cyclops.control.LazyReact;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.internal.react.async.future.FastFuture;
import com.aol.cyclops.internal.react.async.future.FinalPipeline;
import com.aol.cyclops.internal.react.async.future.FuturePool;
import com.aol.cyclops.internal.react.async.future.PipelineBuilder;
import com.aol.cyclops.internal.react.stream.StreamWrapper;
import java.beans.ConstructorProperties;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;

public class LazyStreamWrapper<U>
implements StreamWrapper<U> {
    private final Stream<U> values;
    private final LazyReact react;
    private PipelineBuilder pipeline;
    private final FuturePool pool;

    public LazyStreamWrapper(Stream values, LazyReact react) {
        this.values = values;
        this.pipeline = new PipelineBuilder(react.isAutoOptimize(), react.getExecutor(), react.isAutoMemoize(), react.getMemoizeCache());
        this.react = react;
        this.pool = react.isPoolingActive() ? new FuturePool((ManyToOneConcurrentArrayQueue<FastFuture>)new ManyToOneConcurrentArrayQueue(react.getMaxActive().getMaxActive()), react.getMaxActive().getMaxActive()) : null;
    }

    public ReactiveSeq<FastFuture<U>> injectFuturesSeq() {
        return ReactiveSeq.fromStream(this.injectFutures());
    }

    public Stream<FastFuture> injectFutures() {
        FastFuture f = this.pipeline.build();
        Function<Object, FastFuture> factory2 = v -> {
            FastFuture<Object> next = this.pool != null ? this.pool.next(() -> new FastFuture(f.getPipeline(), fut -> this.pool.done(fut))) : new FastFuture<Object>(f.getPipeline(), 0);
            next.set(v);
            return next;
        };
        if (this.react.isStreamOfFutures()) {
            return this.convertCompletableFutures(f.getPipeline());
        }
        Stream<FastFuture> result = this.values.map(factory2);
        return result;
    }

    public LazyStreamWrapper<U> concat(Stream<U> concatWith) {
        return this.withValues(Stream.concat(this.values, concatWith));
    }

    private Stream<FastFuture> convertCompletableFutures(FinalPipeline pipeline) {
        return this.values.map(cf -> this.buildPool(pipeline).populateFromCompletableFuture((CompletableFuture)cf));
    }

    private FastFuture buildPool(FinalPipeline pipeline) {
        return this.pool != null ? this.pool.next(() -> new FastFuture(pipeline, fut -> this.pool.done(fut))) : new FastFuture(pipeline, 0);
    }

    public <R> LazyStreamWrapper<R> operation(Function<PipelineBuilder, PipelineBuilder> action) {
        this.pipeline = action.apply(this.pipeline);
        return this;
    }

    public <R> LazyStreamWrapper<R> withNewStreamFutures(Stream<R> values) {
        return new LazyStreamWrapper<U>(values, this.react.withStreamOfFutures(true));
    }

    public <R> LazyStreamWrapper<R> withNewStream(Stream<R> values, LazyReact react) {
        return new LazyStreamWrapper<U>(values, react.withStreamOfFutures(false));
    }

    @Override
    public Stream<U> stream() {
        return this.values;
    }

    public LazyStreamWrapper withStream(Stream noType) {
        return this.withValues(noType);
    }

    public boolean isSequential() {
        return this.pipeline.isSequential();
    }

    @ConstructorProperties(value={"values", "react", "pipeline", "pool"})
    public LazyStreamWrapper(Stream<U> values, LazyReact react, PipelineBuilder pipeline, FuturePool pool) {
        this.values = values;
        this.react = react;
        this.pipeline = pipeline;
        this.pool = pool;
    }

    public LazyStreamWrapper<U> withValues(Stream<U> values) {
        return this.values == values ? this : new LazyStreamWrapper<U>(values, this.react, this.pipeline, this.pool);
    }

    public LazyStreamWrapper<U> withReact(LazyReact react) {
        return this.react == react ? this : new LazyStreamWrapper<U>(this.values, react, this.pipeline, this.pool);
    }
}

