/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.react.async.future;

import com.aol.cyclops.internal.react.async.future.FastFuture;
import java.beans.ConstructorProperties;
import java.util.function.Supplier;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;

public class FuturePool {
    private final ManyToOneConcurrentArrayQueue<FastFuture> pool;
    private final int max;

    public <T> FastFuture<T> next(Supplier<FastFuture<T>> factory2) {
        if (this.pool.size() > 0) {
            FastFuture next = (FastFuture)this.pool.poll();
            next.clearFast();
            return next;
        }
        return factory2.get();
    }

    public <T> void done(FastFuture<T> f) {
        if (this.pool.size() < this.max) {
            this.pool.offer(f);
        }
    }

    @ConstructorProperties(value={"pool", "max"})
    public FuturePool(ManyToOneConcurrentArrayQueue<FastFuture> pool, int max) {
        this.pool = pool;
        this.max = max;
    }
}

