/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.monads;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Xor;
import com.aol.cyclops.internal.Monad;
import com.aol.cyclops.internal.comprehensions.comprehenders.MaterializedList;
import com.aol.cyclops.types.anyM.AnyMSeq;
import com.aol.cyclops.types.anyM.AnyMValue;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

public abstract class BaseAnyMImpl<T> {
    protected final Monad<T> monad;
    protected final Class initialType;

    public <R> R unwrap() {
        return (R)this.monad.unwrap();
    }

    protected <R> AnyM<R> fromIterable(Iterable<R> it) {
        if (it instanceof AnyM) {
            return (AnyM)it;
        }
        return AnyM.fromIterable(it);
    }

    protected <R> AnyM<R> fromPublisher(Publisher<R> it) {
        if (it instanceof AnyM) {
            return (AnyM)it;
        }
        return AnyM.fromPublisher(it);
    }

    public Monad monad() {
        return this.monad;
    }

    protected Monad<T> filterInternal(Predicate<? super T> fn) {
        return this.monad.filter((Predicate)fn);
    }

    protected <R> Monad<R> mapInternal(Function<? super T, ? extends R> fn) {
        return this.monad.map((Function)fn);
    }

    protected Monad<T> peekInternal(Consumer<? super T> c) {
        return this.monad.peek((Consumer)c);
    }

    protected <R> Monad<R> bindInternal(Function<? super T, ?> fn) {
        return this.monad.bind(fn);
    }

    protected <R> Monad<R> flatMapInternal(Function<? super T, ? extends AnyM<? extends R>> fn) {
        try {
            return this.monad.bind(in -> ((AnyM)fn.apply(in)).unwrap()).map(this::takeFirst);
        }
        catch (GotoAsEmpty e) {
            return this.monad.empty();
        }
    }

    private <T> T takeFirst(Object o) {
        if (o instanceof MaterializedList) {
            if (((List)o).size() == 0) {
                throw new GotoAsEmpty();
            }
            return (T)((List)o).get(0);
        }
        return (T)o;
    }

    protected <T1> Monad<T1> flattenInternal() {
        return this.monad.flatten();
    }

    abstract Xor<AnyMValue<T>, AnyMSeq<T>> matchable();

    protected AnyM<List<T>> aggregate(AnyM<T> next) {
        return this.unit(Stream.concat(this.matchable().visit(value -> value.toSequence(), seq -> seq.stream()), next.matchable().visit(value -> value.toSequence(), seq -> seq.stream())).collect(Collectors.toList()));
    }

    public void forEach(Consumer<? super T> action) {
        this.asSequence().forEach(action);
    }

    public <NT> ReactiveSeq<NT> toSequence(Function<? super T, ? extends Stream<? extends NT>> fn) {
        return this.monad.flatMapToStream(fn).sequence();
    }

    public <T> ReactiveSeq<T> toSequence() {
        return this.monad.streamedMonad().sequence();
    }

    public ReactiveSeq<T> asSequence() {
        return this.monad.sequence();
    }

    public abstract <T> AnyM<T> unit(T var1);

    public abstract <T> AnyM<T> empty();

    public AnyMValue<T> reduceMValue(Monoid<AnyMValue<T>> reducer) {
        return this.monad.reduceM(Monoid.of(reducer.zero().unwrap(), (a, b) -> (AnyMValue)reducer.combiner().apply(AnyM.ofValue(a), AnyM.ofValue(b)))).anyMValue();
    }

    public AnyMSeq<T> reduceMSeq(Monoid<AnyMSeq<T>> reducer) {
        return this.monad.reduceM(Monoid.of(reducer.zero().unwrap(), (a, b) -> (AnyMSeq)reducer.combiner().apply(AnyM.ofSeq(a), AnyM.ofSeq(b)))).anyMSeq();
    }

    public ReactiveSeq<T> stream() {
        return this.asSequence();
    }

    public String toString() {
        return String.format("AnyM(%s)", this.monad);
    }

    public T get() {
        return this.monad.get();
    }

    @ConstructorProperties(value={"monad", "initialType"})
    protected BaseAnyMImpl(Monad<T> monad, Class initialType) {
        this.monad = monad;
        this.initialType = initialType;
    }

    private static class GotoAsEmpty
    extends RuntimeException {
        private GotoAsEmpty() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }
}

