/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.invokedynamic;

import com.aol.cyclops.util.ExceptionSoftener;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InvokeDynamic {
    private static volatile Map<Method, CallSite> callSites = new ConcurrentHashMap<Method, CallSite>();
    private static volatile Map<String, Map<Class, List<Method>>> generalMethods = new ConcurrentHashMap<String, Map<Class, List<Method>>>();

    public <T> Optional<T> execute(List<String> methodNames, Object obj, Object ... args) {
        return methodNames.stream().map(s -> this.execute((String)s, obj, args)).filter(Optional::isPresent).findFirst().flatMap(i -> i);
    }

    public <T> Optional<T> execute(String methodName, Object obj, Object ... args) {
        Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        Map methods = generalMethods.computeIfAbsent(methodName, k -> new ConcurrentHashMap());
        List om = methods.computeIfAbsent(clazz, c -> Stream.of(c.getMethods()).filter(method -> methodName.equals(method.getName())).filter(method -> method.getParameterCount() == args.length).map(m2 -> {
            m2.setAccessible(true);
            return m2;
        }).collect(Collectors.toList()));
        if (om.size() > 0) {
            return obj instanceof Class ? Optional.of(this.executeStaticMethod((Method)om.get(0), (Class)obj, args)) : Optional.of(this.executeMethod((Method)om.get(0), obj, args));
        }
        return Optional.empty();
    }

    private Object executeStaticMethod(Method m, Class type, Object ... args) {
        MethodHandle mh;
        block8: {
            block7: {
                mh = callSites.computeIfAbsent(m, m2 -> {
                    try {
                        return new ConstantCallSite(MethodHandles.publicLookup().unreflect((Method)m2));
                    }
                    catch (Exception e) {
                        throw ExceptionSoftener.throwSoftenedException(e);
                    }
                }).dynamicInvoker();
                if (args.length != 0) break block7;
                Object object = mh.invoke();
                return object;
            }
            if (args.length != 1) break block8;
            Object object = mh.invoke(args[0]);
            return object;
        }
        try {
            if (args.length == 2) {
                Object object = mh.invoke(args[0], args[1]);
                return object;
            }
        }
        catch (Throwable e) {
            throw ExceptionSoftener.throwSoftenedException(e);
        }
        return null;
    }

    public Object executeMethod(Method m, Object obj, Object ... args) {
        MethodHandle mh;
        block8: {
            block7: {
                mh = callSites.computeIfAbsent(m, m2 -> {
                    try {
                        return new ConstantCallSite(MethodHandles.publicLookup().unreflect((Method)m2));
                    }
                    catch (Exception e) {
                        throw ExceptionSoftener.throwSoftenedException(e);
                    }
                }).dynamicInvoker();
                if (args.length != 0) break block7;
                Object object = mh.invoke(obj);
                return object;
            }
            if (args.length != 1) break block8;
            Object object = mh.invoke(obj, args[0]);
            return object;
        }
        try {
            if (args.length == 2) {
                Object object = mh.invoke(obj, args[0], args[1]);
                return object;
            }
        }
        catch (Throwable e) {
            throw ExceptionSoftener.throwSoftenedException(e);
        }
        return null;
    }
}

