/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.comprehensions.comprehenders;

import com.aol.cyclops.data.collections.extensions.standard.SetX;
import com.aol.cyclops.internal.comprehensions.comprehenders.MaterializedList;
import com.aol.cyclops.types.extensability.Comprehender;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SetComprehender
implements Comprehender<Set> {
    @Override
    public Object resolveForCrossTypeFlatMap(Comprehender comp, Set apply) {
        List list = apply.stream().collect(Collectors.toCollection(MaterializedList::new));
        return list.size() > 0 ? comp.of(list) : comp.empty();
    }

    @Override
    public Class getTargetClass() {
        return Set.class;
    }

    @Override
    public Object filter(Set t, Predicate p) {
        return SetX.fromIterable(t).filter(p);
    }

    @Override
    public Object map(Set t, Function fn) {
        return SetX.fromIterable(t).map(fn);
    }

    @Override
    public Object executeflatMap(Set t, Function fn) {
        return this.flatMap(t, (T input) -> SetComprehender.unwrapOtherMonadTypesLC(this, fn.apply(input)));
    }

    @Override
    public Object flatMap(Set t, Function fn) {
        return SetX.fromIterable(t).flatMap(fn);
    }

    @Override
    public boolean instanceOfT(Object apply) {
        return apply instanceof Stream;
    }

    @Override
    public Set empty() {
        return Collections.unmodifiableSet(new HashSet());
    }

    @Override
    public Set of(Object o) {
        return SetX.of(new Object[]{o});
    }

    @Override
    public Set fromIterator(Iterator it) {
        return SetX.fromIterable(() -> it);
    }

    @Override
    public Set unwrap(Object o) {
        if (o instanceof Set) {
            return (Set)o;
        }
        return ((Stream)o).collect(Collectors.toSet());
    }

    static Set unwrapOtherMonadTypesLC(Comprehender comp, Object apply) {
        if (apply instanceof Collection) {
            return SetX.fromIterable((Collection)apply);
        }
        if (apply instanceof Iterable) {
            return SetX.fromIterable((Iterable)apply);
        }
        if (apply instanceof BaseStream) {
            return SetX.fromIterable(() -> ((BaseStream)apply).iterator());
        }
        Object o = Comprehender.unwrapOtherMonadTypes(comp, apply);
        if (o instanceof Collection) {
            return SetX.fromIterable((Collection)apply);
        }
        if (o instanceof Iterable) {
            return SetX.fromIterable((Iterable)apply);
        }
        if (apply instanceof BaseStream) {
            return SetX.fromIterable(() -> ((BaseStream)apply).iterator());
        }
        return (Set)o;
    }
}

