/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.collections.extensions.standard;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.data.collections.extensions.standard.MutableCollectionX;
import com.aol.cyclops.data.collections.extensions.standard.SetXImpl;
import com.aol.cyclops.util.stream.StreamUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.reactivestreams.Publisher;

public interface SetX<T>
extends Set<T>,
MutableCollectionX<T> {
    public static SetX<Integer> range(int start, int end) {
        return ReactiveSeq.range(start, end).toSetX();
    }

    public static SetX<Long> rangeLong(long start, long end) {
        return ReactiveSeq.rangeLong(start, end).toSetX();
    }

    public static <U, T> SetX<T> unfold(U seed, Function<? super U, Optional<Tuple2<T, U>>> unfolder) {
        return ReactiveSeq.unfold(seed, unfolder).toSetX();
    }

    public static <T> SetX<T> generate(long limit, Supplier<T> s) {
        return ReactiveSeq.generate(s).limit(limit).toSetX();
    }

    public static <T> SetX<T> iterate(long limit, T seed, UnaryOperator<T> f) {
        return ReactiveSeq.iterate(seed, f).limit(limit).toSetX();
    }

    public static <T> Collector<T, ?, SetX<T>> setXCollector() {
        return Collectors.toCollection(() -> SetX.of(new Object[0]));
    }

    public static <T> Collector<T, ?, Set<T>> defaultCollector() {
        return Collectors.toCollection(() -> new HashSet());
    }

    public static <T> Collector<T, ?, Set<T>> immutableCollector() {
        return Collectors.collectingAndThen(SetX.defaultCollector(), d -> Collections.unmodifiableSet(d));
    }

    public static <T> SetX<T> empty() {
        return SetX.fromIterable((Set)SetX.defaultCollector().supplier().get());
    }

    @SafeVarargs
    public static <T> SetX<T> of(T ... values) {
        Set res = (Set)SetX.defaultCollector().supplier().get();
        for (T v : values) {
            res.add(v);
        }
        return SetX.fromIterable(res);
    }

    public static <T> SetX<T> singleton(T value) {
        return SetX.of(new Object[]{value});
    }

    public static <T> SetX<T> fromPublisher(Publisher<? extends T> publisher) {
        return ReactiveSeq.fromPublisher(publisher).toSetX();
    }

    public static <T> SetX<T> fromIterable(Iterable<T> it) {
        return SetX.fromIterable(SetX.defaultCollector(), it);
    }

    public static <T> SetX<T> fromIterable(Collector<T, ?, Set<T>> collector, Iterable<T> it) {
        if (it instanceof SetX) {
            return (SetX)it;
        }
        if (it instanceof Set) {
            return new SetXImpl<T>((Set)it, collector);
        }
        return new SetXImpl<T>(StreamUtils.stream(it).collect(collector), collector);
    }

    @Override
    default public SetX<T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return (SetX)MutableCollectionX.super.combine((BiPredicate)predicate, (BinaryOperator)op);
    }

    @Override
    default public SetX<T> toSetX() {
        return this;
    }

    @Override
    default public ReactiveSeq<T> stream() {
        return ReactiveSeq.fromIterable(this);
    }

    @Override
    default public <R> SetX<R> unit(Collection<R> col) {
        return SetX.fromIterable(col);
    }

    @Override
    default public <R> SetX<R> unit(R value) {
        return SetX.singleton(value);
    }

    @Override
    default public <R> SetX<R> unitIterator(Iterator<R> it) {
        return SetX.fromIterable(() -> it);
    }

    @Override
    default public <T1> SetX<T1> from(Collection<T1> c) {
        return SetX.fromIterable(this.getCollector(), c);
    }

    public <T> Collector<T, ?, Set<T>> getCollector();

    @Override
    default public <X> SetX<X> fromStream(Stream<X> stream) {
        return new SetXImpl<T>(stream.collect(this.getCollector()), this.getCollector());
    }

    @Override
    default public SetX<T> reverse() {
        return (SetX)MutableCollectionX.super.reverse();
    }

    @Override
    default public SetX<T> filter(Predicate<? super T> pred) {
        return (SetX)MutableCollectionX.super.filter((Predicate)pred);
    }

    @Override
    default public <R> SetX<R> map(Function<? super T, ? extends R> mapper) {
        return (SetX)MutableCollectionX.super.map((Function)mapper);
    }

    @Override
    default public <R> SetX<R> flatMap(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return (SetX)MutableCollectionX.super.flatMap(mapper);
    }

    @Override
    default public SetX<T> limit(long num) {
        return (SetX)MutableCollectionX.super.limit(num);
    }

    @Override
    default public SetX<T> skip(long num) {
        return (SetX)MutableCollectionX.super.skip(num);
    }

    @Override
    default public SetX<T> takeRight(int num) {
        return (SetX)MutableCollectionX.super.takeRight(num);
    }

    @Override
    default public SetX<T> dropRight(int num) {
        return (SetX)MutableCollectionX.super.dropRight(num);
    }

    @Override
    default public SetX<T> takeWhile(Predicate<? super T> p) {
        return (SetX)MutableCollectionX.super.takeWhile((Predicate)p);
    }

    @Override
    default public SetX<T> dropWhile(Predicate<? super T> p) {
        return (SetX)MutableCollectionX.super.dropWhile((Predicate)p);
    }

    @Override
    default public SetX<T> takeUntil(Predicate<? super T> p) {
        return (SetX)MutableCollectionX.super.takeUntil((Predicate)p);
    }

    @Override
    default public SetX<T> dropUntil(Predicate<? super T> p) {
        return (SetX)MutableCollectionX.super.dropUntil((Predicate)p);
    }

    @Override
    default public <R> SetX<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (SetX)MutableCollectionX.super.trampoline((Function)mapper);
    }

    @Override
    default public SetX<T> slice(long from, long to) {
        return (SetX)MutableCollectionX.super.slice(from, to);
    }

    @Override
    default public <U extends Comparable<? super U>> SetX<T> sorted(Function<? super T, ? extends U> function) {
        return (SetX)MutableCollectionX.super.sorted((Function)function);
    }

    @Override
    default public SetX<ListX<T>> grouped(int groupSize) {
        return (SetX)MutableCollectionX.super.grouped(groupSize);
    }

    @Override
    default public <K, A, D> SetX<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return (SetX)MutableCollectionX.super.grouped((Function)classifier, (Collector)downstream);
    }

    @Override
    default public <K> SetX<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return (SetX)MutableCollectionX.super.grouped((Function)classifier);
    }

    @Override
    default public <U> SetX<Tuple2<T, U>> zip(Iterable<? extends U> other) {
        return (SetX)MutableCollectionX.super.zip((Iterable)other);
    }

    @Override
    default public <U, R> SetX<R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (SetX)MutableCollectionX.super.zip((Iterable)other, (BiFunction)zipper);
    }

    @Override
    default public <U, R> SetX<R> zip(Stream<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (SetX)MutableCollectionX.super.zip((Stream)other, (BiFunction)zipper);
    }

    @Override
    default public <U, R> SetX<R> zip(Seq<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (SetX)MutableCollectionX.super.zip((Seq)other, (BiFunction)zipper);
    }

    @Override
    default public SetX<ListX<T>> sliding(int windowSize) {
        return (SetX)MutableCollectionX.super.sliding(windowSize);
    }

    @Override
    default public SetX<ListX<T>> sliding(int windowSize, int increment) {
        return (SetX)MutableCollectionX.super.sliding(windowSize, increment);
    }

    @Override
    default public SetX<T> scanLeft(Monoid<T> monoid) {
        return (SetX)MutableCollectionX.super.scanLeft((Monoid)monoid);
    }

    @Override
    default public <U> SetX<U> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return (SetX)MutableCollectionX.super.scanLeft((Object)seed, (BiFunction)function);
    }

    @Override
    default public SetX<T> scanRight(Monoid<T> monoid) {
        return (SetX)MutableCollectionX.super.scanRight((Monoid)monoid);
    }

    @Override
    default public <U> SetX<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return (SetX)MutableCollectionX.super.scanRight((Object)identity, (BiFunction)combiner);
    }

    @Override
    default public SetX<T> plus(T e) {
        this.add(e);
        return this;
    }

    @Override
    default public SetX<T> plusAll(Collection<? extends T> list) {
        this.addAll(list);
        return this;
    }

    @Override
    default public SetX<T> minus(Object e) {
        this.remove(e);
        return this;
    }

    @Override
    default public SetX<T> minusAll(Collection<?> list) {
        this.removeAll(list);
        return this;
    }

    @Override
    default public ListX<T> cycle(int times) {
        return this.stream().cycle(times).toListX();
    }

    @Override
    default public ListX<T> cycle(Monoid<T> m, int times) {
        return this.stream().cycle(m, times).toListX();
    }

    @Override
    default public ListX<T> cycleWhile(Predicate<? super T> predicate) {
        return this.stream().cycleWhile(predicate).toListX();
    }

    @Override
    default public ListX<T> cycleUntil(Predicate<? super T> predicate) {
        return this.stream().cycleUntil(predicate).toListX();
    }

    @Override
    default public <U> SetX<Tuple2<T, U>> zip(Stream<? extends U> other) {
        return (SetX)MutableCollectionX.super.zip((Stream)other);
    }

    @Override
    default public <U> SetX<Tuple2<T, U>> zip(Seq<? extends U> other) {
        return (SetX)MutableCollectionX.super.zip((Seq)other);
    }

    @Override
    default public <S, U> SetX<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return (SetX)MutableCollectionX.super.zip3((Stream)second, (Stream)third);
    }

    @Override
    default public <T2, T3, T4> SetX<Tuple4<T, T2, T3, T4>> zip4(Stream<? extends T2> second, Stream<? extends T3> third, Stream<? extends T4> fourth) {
        return (SetX)MutableCollectionX.super.zip4((Stream)second, (Stream)third, (Stream)fourth);
    }

    @Override
    default public SetX<Tuple2<T, Long>> zipWithIndex() {
        return (SetX)MutableCollectionX.super.zipWithIndex();
    }

    @Override
    default public SetX<T> distinct() {
        return (SetX)MutableCollectionX.super.distinct();
    }

    @Override
    default public SetX<T> sorted() {
        return (SetX)MutableCollectionX.super.sorted();
    }

    @Override
    default public SetX<T> sorted(Comparator<? super T> c) {
        return (SetX)MutableCollectionX.super.sorted((Comparator)c);
    }

    @Override
    default public SetX<T> skipWhile(Predicate<? super T> p) {
        return (SetX)MutableCollectionX.super.skipWhile((Predicate)p);
    }

    @Override
    default public SetX<T> skipUntil(Predicate<? super T> p) {
        return (SetX)MutableCollectionX.super.skipUntil((Predicate)p);
    }

    @Override
    default public SetX<T> limitWhile(Predicate<? super T> p) {
        return (SetX)MutableCollectionX.super.limitWhile((Predicate)p);
    }

    @Override
    default public SetX<T> limitUntil(Predicate<? super T> p) {
        return (SetX)MutableCollectionX.super.limitUntil((Predicate)p);
    }

    @Override
    default public SetX<T> intersperse(T value) {
        return (SetX)MutableCollectionX.super.intersperse((Object)value);
    }

    @Override
    default public SetX<T> shuffle() {
        return (SetX)MutableCollectionX.super.shuffle();
    }

    @Override
    default public SetX<T> skipLast(int num) {
        return (SetX)MutableCollectionX.super.skipLast(num);
    }

    @Override
    default public SetX<T> limitLast(int num) {
        return (SetX)MutableCollectionX.super.limitLast(num);
    }

    @Override
    default public SetX<T> onEmpty(T value) {
        return (SetX)MutableCollectionX.super.onEmpty((Object)value);
    }

    @Override
    default public SetX<T> onEmptyGet(Supplier<? extends T> supplier) {
        return (SetX)MutableCollectionX.super.onEmptyGet((Supplier)supplier);
    }

    @Override
    default public <X extends Throwable> SetX<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return (SetX)MutableCollectionX.super.onEmptyThrow((Supplier)supplier);
    }

    @Override
    default public SetX<T> shuffle(Random random) {
        return (SetX)MutableCollectionX.super.shuffle(random);
    }

    @Override
    default public <U> SetX<U> ofType(Class<? extends U> type) {
        return (SetX)MutableCollectionX.super.ofType((Class)type);
    }

    @Override
    default public SetX<T> filterNot(Predicate<? super T> fn) {
        return (SetX)MutableCollectionX.super.filterNot((Predicate)fn);
    }

    @Override
    default public SetX<T> notNull() {
        return (SetX)MutableCollectionX.super.notNull();
    }

    @Override
    default public SetX<T> removeAll(Stream<? extends T> stream) {
        return (SetX)MutableCollectionX.super.removeAll((Stream)stream);
    }

    @Override
    default public SetX<T> removeAll(Iterable<? extends T> it) {
        return (SetX)MutableCollectionX.super.removeAll((Iterable)it);
    }

    @Override
    default public SetX<T> removeAll(T ... values) {
        return (SetX)MutableCollectionX.super.removeAll((Object[])values);
    }

    @Override
    default public SetX<T> retainAll(Iterable<? extends T> it) {
        return (SetX)MutableCollectionX.super.retainAll((Iterable)it);
    }

    @Override
    default public SetX<T> retainAll(Stream<? extends T> seq) {
        return (SetX)MutableCollectionX.super.retainAll((Stream)seq);
    }

    @Override
    default public SetX<T> retainAll(T ... values) {
        return (SetX)MutableCollectionX.super.retainAll((Object[])values);
    }

    @Override
    default public <U> SetX<U> cast(Class<? extends U> type) {
        return (SetX)MutableCollectionX.super.cast((Class)type);
    }

    @Override
    default public <R> SetX<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (SetX)MutableCollectionX.super.patternMatch((Function)case1, (Supplier)otherwise);
    }

    @Override
    default public <C extends Collection<? super T>> SetX<C> grouped(int size, Supplier<C> supplier) {
        return (SetX)MutableCollectionX.super.grouped(size, (Supplier)supplier);
    }

    @Override
    default public SetX<ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return (SetX)MutableCollectionX.super.groupedUntil((Predicate)predicate);
    }

    @Override
    default public SetX<ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return (SetX)MutableCollectionX.super.groupedWhile((Predicate)predicate);
    }

    @Override
    default public <C extends Collection<? super T>> SetX<C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (SetX)MutableCollectionX.super.groupedWhile((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public <C extends Collection<? super T>> SetX<C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (SetX)MutableCollectionX.super.groupedUntil((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public SetX<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return (SetX)MutableCollectionX.super.groupedStatefullyWhile((BiPredicate)predicate);
    }

    @Override
    default public SetX<T> removeAll(Seq<? extends T> stream) {
        return (SetX)MutableCollectionX.super.removeAll((Seq)stream);
    }

    @Override
    default public SetX<T> retainAll(Seq<? extends T> stream) {
        return (SetX)MutableCollectionX.super.retainAll((Seq)stream);
    }
}

