/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.collections.extensions.standard;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.data.collections.extensions.standard.DequeXImpl;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.data.collections.extensions.standard.MutableCollectionX;
import com.aol.cyclops.util.stream.StreamUtils;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.reactivestreams.Publisher;

public interface DequeX<T>
extends Deque<T>,
MutableCollectionX<T> {
    public static DequeX<Integer> range(int start, int end) {
        return ReactiveSeq.range(start, end).toDequeX();
    }

    public static DequeX<Long> rangeLong(long start, long end) {
        return ReactiveSeq.rangeLong(start, end).toDequeX();
    }

    public static <U, T> DequeX<T> unfold(U seed, Function<? super U, Optional<Tuple2<T, U>>> unfolder) {
        return ReactiveSeq.unfold(seed, unfolder).toDequeX();
    }

    public static <T> DequeX<T> generate(long limit, Supplier<T> s) {
        return ReactiveSeq.generate(s).limit(limit).toDequeX();
    }

    public static <T> DequeX<T> iterate(long limit, T seed, UnaryOperator<T> f) {
        return ReactiveSeq.iterate(seed, f).limit(limit).toDequeX();
    }

    public static <T> Collector<T, ?, Deque<T>> defaultCollector() {
        return Collectors.toCollection(() -> new ArrayDeque());
    }

    public static <T> DequeX<T> empty() {
        return DequeX.fromIterable((Deque)DequeX.defaultCollector().supplier().get());
    }

    public static <T> DequeX<T> of(T ... values) {
        Deque res = (Deque)DequeX.defaultCollector().supplier().get();
        for (T v : values) {
            res.add(v);
        }
        return DequeX.fromIterable(res);
    }

    public static <T> DequeX<T> singleton(T value) {
        return DequeX.of(value);
    }

    public static <T> DequeX<T> fromPublisher(Publisher<? extends T> publisher) {
        return ReactiveSeq.fromPublisher(publisher).toDequeX();
    }

    public static <T> DequeX<T> fromIterable(Iterable<T> it) {
        return DequeX.fromIterable(DequeX.defaultCollector(), it);
    }

    public static <T> DequeX<T> fromIterable(Collector<T, ?, Deque<T>> collector, Iterable<T> it) {
        if (it instanceof DequeX) {
            return (DequeX)it;
        }
        if (it instanceof Deque) {
            return new DequeXImpl<T>((Deque)it, collector);
        }
        return new DequeXImpl<T>(StreamUtils.stream(it).collect(collector), collector);
    }

    @Override
    default public DequeX<T> toDequeX() {
        return this;
    }

    public <T> Collector<T, ?, Deque<T>> getCollector();

    @Override
    default public <T1> DequeX<T1> from(Collection<T1> c) {
        return DequeX.fromIterable(this.getCollector(), c);
    }

    @Override
    default public <X> DequeX<X> fromStream(Stream<X> stream) {
        return new DequeXImpl<T>(stream.collect(this.getCollector()), this.getCollector());
    }

    @Override
    default public DequeX<T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return (DequeX)MutableCollectionX.super.combine((BiPredicate)predicate, (BinaryOperator)op);
    }

    @Override
    default public <R> DequeX<R> unit(Collection<R> col) {
        return DequeX.fromIterable(col);
    }

    @Override
    default public <R> DequeX<R> unit(R value) {
        return DequeX.singleton(value);
    }

    @Override
    default public <R> DequeX<R> unitIterator(Iterator<R> it) {
        return DequeX.fromIterable(() -> it);
    }

    @Override
    default public ReactiveSeq<T> stream() {
        return ReactiveSeq.fromIterable(this);
    }

    @Override
    default public DequeX<T> reverse() {
        return (DequeX)MutableCollectionX.super.reverse();
    }

    @Override
    default public DequeX<T> filter(Predicate<? super T> pred) {
        return (DequeX)MutableCollectionX.super.filter((Predicate)pred);
    }

    @Override
    default public <R> DequeX<R> map(Function<? super T, ? extends R> mapper) {
        return (DequeX)MutableCollectionX.super.map((Function)mapper);
    }

    @Override
    default public <R> DequeX<R> flatMap(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return (DequeX)MutableCollectionX.super.flatMap(mapper);
    }

    @Override
    default public DequeX<T> limit(long num) {
        return (DequeX)MutableCollectionX.super.limit(num);
    }

    @Override
    default public DequeX<T> skip(long num) {
        return (DequeX)MutableCollectionX.super.skip(num);
    }

    @Override
    default public DequeX<T> takeWhile(Predicate<? super T> p) {
        return (DequeX)MutableCollectionX.super.takeWhile((Predicate)p);
    }

    @Override
    default public DequeX<T> takeRight(int num) {
        return (DequeX)MutableCollectionX.super.takeRight(num);
    }

    @Override
    default public DequeX<T> dropRight(int num) {
        return (DequeX)MutableCollectionX.super.dropRight(num);
    }

    @Override
    default public DequeX<T> dropWhile(Predicate<? super T> p) {
        return (DequeX)MutableCollectionX.super.dropWhile((Predicate)p);
    }

    @Override
    default public DequeX<T> takeUntil(Predicate<? super T> p) {
        return (DequeX)MutableCollectionX.super.takeUntil((Predicate)p);
    }

    @Override
    default public DequeX<T> dropUntil(Predicate<? super T> p) {
        return (DequeX)MutableCollectionX.super.dropUntil((Predicate)p);
    }

    @Override
    default public <R> DequeX<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (DequeX)MutableCollectionX.super.trampoline((Function)mapper);
    }

    @Override
    default public DequeX<T> slice(long from, long to) {
        return (DequeX)MutableCollectionX.super.slice(from, to);
    }

    @Override
    default public DequeX<ListX<T>> grouped(int groupSize) {
        return (DequeX)MutableCollectionX.super.grouped(groupSize);
    }

    @Override
    default public <K, A, D> DequeX<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return (DequeX)MutableCollectionX.super.grouped((Function)classifier, (Collector)downstream);
    }

    @Override
    default public <K> DequeX<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return (DequeX)MutableCollectionX.super.grouped((Function)classifier);
    }

    @Override
    default public <U> DequeX<Tuple2<T, U>> zip(Iterable<? extends U> other) {
        return (DequeX)MutableCollectionX.super.zip((Iterable)other);
    }

    @Override
    default public <U, R> DequeX<R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (DequeX)MutableCollectionX.super.zip((Iterable)other, (BiFunction)zipper);
    }

    @Override
    default public <U, R> DequeX<R> zip(Seq<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (DequeX)MutableCollectionX.super.zip((Seq)other, (BiFunction)zipper);
    }

    @Override
    default public <U, R> DequeX<R> zip(Stream<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (DequeX)MutableCollectionX.super.zip((Stream)other, (BiFunction)zipper);
    }

    @Override
    default public DequeX<ListX<T>> sliding(int windowSize) {
        return (DequeX)MutableCollectionX.super.sliding(windowSize);
    }

    @Override
    default public DequeX<ListX<T>> sliding(int windowSize, int increment) {
        return (DequeX)MutableCollectionX.super.sliding(windowSize, increment);
    }

    @Override
    default public DequeX<T> scanLeft(Monoid<T> monoid) {
        return (DequeX)MutableCollectionX.super.scanLeft((Monoid)monoid);
    }

    @Override
    default public <U> DequeX<U> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return (DequeX)MutableCollectionX.super.scanLeft((Object)seed, (BiFunction)function);
    }

    @Override
    default public DequeX<T> scanRight(Monoid<T> monoid) {
        return (DequeX)MutableCollectionX.super.scanRight((Monoid)monoid);
    }

    @Override
    default public <U> DequeX<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return (DequeX)MutableCollectionX.super.scanRight((Object)identity, (BiFunction)combiner);
    }

    @Override
    default public <U extends Comparable<? super U>> DequeX<T> sorted(Function<? super T, ? extends U> function) {
        return (DequeX)MutableCollectionX.super.sorted((Function)function);
    }

    @Override
    default public DequeX<T> plus(T e) {
        this.add(e);
        return this;
    }

    @Override
    default public DequeX<T> plusAll(Collection<? extends T> list) {
        this.addAll(list);
        return this;
    }

    @Override
    default public DequeX<T> minus(Object e) {
        this.remove(e);
        return this;
    }

    @Override
    default public DequeX<T> minusAll(Collection<?> list) {
        this.removeAll(list);
        return this;
    }

    @Override
    default public DequeX<T> peek(Consumer<? super T> c) {
        return (DequeX)MutableCollectionX.super.peek((Consumer)c);
    }

    @Override
    default public <R> DequeX<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (DequeX)MutableCollectionX.super.patternMatch((Function)case1, (Supplier)otherwise);
    }

    @Override
    default public DequeX<T> cycle(int times) {
        return (DequeX)MutableCollectionX.super.cycle(times);
    }

    @Override
    default public DequeX<T> cycle(Monoid<T> m, int times) {
        return (DequeX)MutableCollectionX.super.cycle((Monoid)m, times);
    }

    @Override
    default public DequeX<T> cycleWhile(Predicate<? super T> predicate) {
        return (DequeX)MutableCollectionX.super.cycleWhile((Predicate)predicate);
    }

    @Override
    default public DequeX<T> cycleUntil(Predicate<? super T> predicate) {
        return (DequeX)MutableCollectionX.super.cycleUntil((Predicate)predicate);
    }

    @Override
    default public <U> DequeX<Tuple2<T, U>> zip(Stream<? extends U> other) {
        return (DequeX)MutableCollectionX.super.zip((Stream)other);
    }

    @Override
    default public <U> DequeX<Tuple2<T, U>> zip(Seq<? extends U> other) {
        return (DequeX)MutableCollectionX.super.zip((Seq)other);
    }

    @Override
    default public <S, U> DequeX<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return (DequeX)MutableCollectionX.super.zip3((Stream)second, (Stream)third);
    }

    @Override
    default public <T2, T3, T4> DequeX<Tuple4<T, T2, T3, T4>> zip4(Stream<? extends T2> second, Stream<? extends T3> third, Stream<? extends T4> fourth) {
        return (DequeX)MutableCollectionX.super.zip4((Stream)second, (Stream)third, (Stream)fourth);
    }

    @Override
    default public DequeX<Tuple2<T, Long>> zipWithIndex() {
        return (DequeX)MutableCollectionX.super.zipWithIndex();
    }

    @Override
    default public DequeX<T> distinct() {
        return (DequeX)MutableCollectionX.super.distinct();
    }

    @Override
    default public DequeX<T> sorted() {
        return (DequeX)MutableCollectionX.super.sorted();
    }

    @Override
    default public DequeX<T> sorted(Comparator<? super T> c) {
        return (DequeX)MutableCollectionX.super.sorted((Comparator)c);
    }

    @Override
    default public DequeX<T> skipWhile(Predicate<? super T> p) {
        return (DequeX)MutableCollectionX.super.skipWhile((Predicate)p);
    }

    @Override
    default public DequeX<T> skipUntil(Predicate<? super T> p) {
        return (DequeX)MutableCollectionX.super.skipUntil((Predicate)p);
    }

    @Override
    default public DequeX<T> limitWhile(Predicate<? super T> p) {
        return (DequeX)MutableCollectionX.super.limitWhile((Predicate)p);
    }

    @Override
    default public DequeX<T> limitUntil(Predicate<? super T> p) {
        return (DequeX)MutableCollectionX.super.limitUntil((Predicate)p);
    }

    @Override
    default public DequeX<T> intersperse(T value) {
        return (DequeX)MutableCollectionX.super.intersperse((Object)value);
    }

    @Override
    default public DequeX<T> shuffle() {
        return (DequeX)MutableCollectionX.super.shuffle();
    }

    @Override
    default public DequeX<T> skipLast(int num) {
        return (DequeX)MutableCollectionX.super.skipLast(num);
    }

    @Override
    default public DequeX<T> limitLast(int num) {
        return (DequeX)MutableCollectionX.super.limitLast(num);
    }

    @Override
    default public DequeX<T> onEmpty(T value) {
        return (DequeX)MutableCollectionX.super.onEmpty((Object)value);
    }

    @Override
    default public DequeX<T> onEmptyGet(Supplier<? extends T> supplier) {
        return (DequeX)MutableCollectionX.super.onEmptyGet((Supplier)supplier);
    }

    @Override
    default public <X extends Throwable> DequeX<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return (DequeX)MutableCollectionX.super.onEmptyThrow((Supplier)supplier);
    }

    @Override
    default public DequeX<T> shuffle(Random random) {
        return (DequeX)MutableCollectionX.super.shuffle(random);
    }

    @Override
    default public DequeX<ReactiveSeq<T>> permutations() {
        return (DequeX)MutableCollectionX.super.permutations();
    }

    @Override
    default public DequeX<ReactiveSeq<T>> combinations(int size) {
        return (DequeX)MutableCollectionX.super.combinations(size);
    }

    @Override
    default public DequeX<ReactiveSeq<T>> combinations() {
        return (DequeX)MutableCollectionX.super.combinations();
    }

    @Override
    default public <U> DequeX<U> cast(Class<? extends U> type) {
        return (DequeX)MutableCollectionX.super.cast((Class)type);
    }

    @Override
    default public <U> DequeX<U> ofType(Class<? extends U> type) {
        return (DequeX)MutableCollectionX.super.ofType((Class)type);
    }

    @Override
    default public DequeX<T> filterNot(Predicate<? super T> fn) {
        return (DequeX)MutableCollectionX.super.filterNot((Predicate)fn);
    }

    @Override
    default public DequeX<T> notNull() {
        return (DequeX)MutableCollectionX.super.notNull();
    }

    @Override
    default public DequeX<T> removeAll(Stream<? extends T> stream) {
        return (DequeX)MutableCollectionX.super.removeAll((Stream)stream);
    }

    @Override
    default public DequeX<T> removeAll(Iterable<? extends T> it) {
        return (DequeX)MutableCollectionX.super.removeAll((Iterable)it);
    }

    @Override
    default public DequeX<T> removeAll(T ... values) {
        return (DequeX)MutableCollectionX.super.removeAll((Object[])values);
    }

    @Override
    default public DequeX<T> retainAll(Iterable<? extends T> it) {
        return (DequeX)MutableCollectionX.super.retainAll((Iterable)it);
    }

    @Override
    default public DequeX<T> retainAll(Stream<? extends T> seq) {
        return (DequeX)MutableCollectionX.super.retainAll((Stream)seq);
    }

    @Override
    default public DequeX<T> retainAll(T ... values) {
        return (DequeX)MutableCollectionX.super.retainAll((Object[])values);
    }

    @Override
    default public <C extends Collection<? super T>> DequeX<C> grouped(int size, Supplier<C> supplier) {
        return (DequeX)MutableCollectionX.super.grouped(size, (Supplier)supplier);
    }

    @Override
    default public DequeX<ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return (DequeX)MutableCollectionX.super.groupedUntil((Predicate)predicate);
    }

    @Override
    default public DequeX<ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return (DequeX)MutableCollectionX.super.groupedWhile((Predicate)predicate);
    }

    @Override
    default public <C extends Collection<? super T>> DequeX<C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (DequeX)MutableCollectionX.super.groupedWhile((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public <C extends Collection<? super T>> DequeX<C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (DequeX)MutableCollectionX.super.groupedUntil((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public DequeX<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return (DequeX)MutableCollectionX.super.groupedStatefullyWhile((BiPredicate)predicate);
    }

    @Override
    default public DequeX<T> removeAll(Seq<? extends T> stream) {
        return (DequeX)MutableCollectionX.super.removeAll((Seq)stream);
    }

    @Override
    default public DequeX<T> retainAll(Seq<? extends T> stream) {
        return (DequeX)MutableCollectionX.super.retainAll((Seq)stream);
    }
}

