/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.collections.extensions.persistent;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.Reducer;
import com.aol.cyclops.Reducers;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.data.collections.extensions.FluentSequenceX;
import com.aol.cyclops.data.collections.extensions.persistent.PStackXImpl;
import com.aol.cyclops.data.collections.extensions.persistent.PersistentCollectionX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.pcollections.ConsPStack;
import org.pcollections.PStack;
import org.reactivestreams.Publisher;

public interface PStackX<T>
extends PStack<T>,
PersistentCollectionX<T>,
FluentSequenceX<T> {
    public static PStackX<Integer> range(int start, int end) {
        return ReactiveSeq.range(start, end).toPStackX();
    }

    public static PStackX<Long> rangeLong(long start, long end) {
        return ReactiveSeq.rangeLong(start, end).toPStackX();
    }

    public static <U, T> PStackX<T> unfold(U seed, Function<? super U, Optional<Tuple2<T, U>>> unfolder) {
        return ReactiveSeq.unfold(seed, unfolder).toPStackX();
    }

    public static <T> PStackX<T> generate(long limit, Supplier<T> s) {
        return ReactiveSeq.generate(s).limit(limit).toPStackX();
    }

    public static <T> PStackX<T> iterate(long limit, T seed, UnaryOperator<T> f) {
        return ReactiveSeq.iterate(seed, f).limit(limit).toPStackX();
    }

    public static <T> PStackX<T> of(T ... values) {
        return new PStackXImpl(ConsPStack.from(Arrays.asList(values)), true);
    }

    public static <T> PStackX<T> fromPublisher(Publisher<? extends T> publisher) {
        return ReactiveSeq.fromPublisher(publisher).toPStackX();
    }

    public static <T> PStackX<T> fromIterable(Iterable<T> iterable) {
        if (iterable instanceof PStackX) {
            return (PStackX)iterable;
        }
        if (iterable instanceof PStack) {
            return new PStackXImpl((PStack)iterable, true);
        }
        ConsPStack res = ConsPStack.empty();
        Iterator<T> it = iterable.iterator();
        while (it.hasNext()) {
            res = res.plus(it.next());
        }
        return new PStackXImpl(res, true);
    }

    public static <T> PStackX<T> fromCollection(Collection<T> values) {
        if (values instanceof PStackX) {
            return (PStackX)values;
        }
        if (values instanceof PStack) {
            return new PStackXImpl((PStack)values, true);
        }
        return new PStackXImpl(ConsPStack.from(values), true);
    }

    public static <T> PStackX<T> empty() {
        return new PStackXImpl(ConsPStack.empty(), true);
    }

    public static <T> PStackX<T> singleton(T value) {
        return new PStackXImpl(ConsPStack.singleton(value), true);
    }

    public static <T> PStackX<T> fromStream(Stream<T> stream) {
        return Reducers.toPStackX().mapReduce(stream).efficientOpsOff();
    }

    @Override
    default public PStackX<T> toPStackX() {
        return this;
    }

    @Override
    default public PStackX<T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return (PStackX)PersistentCollectionX.super.combine((BiPredicate)predicate, (BinaryOperator)op);
    }

    @Override
    default public <R> PStackX<R> unit(Collection<R> col) {
        if (this.isEfficientOps()) {
            return PStackX.fromCollection(col);
        }
        return PStackX.fromCollection(col).efficientOpsOff();
    }

    @Override
    default public <R> PStackX<R> unit(R value) {
        return PStackX.singleton(value);
    }

    @Override
    default public <R> PStackX<R> unitIterator(Iterator<R> it) {
        return PStackX.fromIterable(() -> it);
    }

    @Override
    default public <R> PStackX<R> emptyUnit() {
        if (this.isEfficientOps()) {
            return PStackX.empty();
        }
        return PStackX.empty().efficientOpsOff();
    }

    default public PStack<T> toPStack() {
        return this;
    }

    @Override
    default public PStackX<T> plusInOrder(T e) {
        if (this.isEfficientOps()) {
            return this.plus((Object)e);
        }
        return this.plus(this.size(), (Object)e);
    }

    @Override
    default public ReactiveSeq<T> stream() {
        return ReactiveSeq.fromIterable(this);
    }

    @Override
    default public <X> PStackX<X> from(Collection<X> col) {
        if (this.isEfficientOps()) {
            return PStackX.fromCollection(col);
        }
        return PStackX.fromCollection(col).efficientOpsOff();
    }

    @Override
    default public <T> Reducer<PStack<T>> monoid() {
        if (this.isEfficientOps()) {
            return Reducers.toPStackReversed();
        }
        return Reducers.toPStack();
    }

    @Override
    default public PStackX<T> reverse() {
        ConsPStack reversed = ConsPStack.empty();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            reversed = reversed.plus(0, it.next());
        }
        return PStackX.fromCollection(reversed);
    }

    public PStackX<T> efficientOpsOn();

    public PStackX<T> efficientOpsOff();

    public boolean isEfficientOps();

    @Override
    default public PStackX<T> filter(Predicate<? super T> pred) {
        return (PStackX)PersistentCollectionX.super.filter((Predicate)pred);
    }

    @Override
    default public <R> PStackX<R> map(Function<? super T, ? extends R> mapper) {
        return (PStackX)PersistentCollectionX.super.map((Function)mapper);
    }

    @Override
    default public <R> PStackX<R> flatMap(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return (PStackX)PersistentCollectionX.super.flatMap((Function)mapper);
    }

    @Override
    default public PStackX<T> limit(long num) {
        return (PStackX)PersistentCollectionX.super.limit(num);
    }

    @Override
    default public PStackX<T> skip(long num) {
        return (PStackX)PersistentCollectionX.super.skip(num);
    }

    @Override
    default public PStackX<T> takeRight(int num) {
        return (PStackX)PersistentCollectionX.super.takeRight(num);
    }

    @Override
    default public PStackX<T> dropRight(int num) {
        return (PStackX)PersistentCollectionX.super.dropRight(num);
    }

    @Override
    default public PStackX<T> takeWhile(Predicate<? super T> p) {
        return (PStackX)PersistentCollectionX.super.takeWhile((Predicate)p);
    }

    @Override
    default public PStackX<T> dropWhile(Predicate<? super T> p) {
        return (PStackX)PersistentCollectionX.super.dropWhile((Predicate)p);
    }

    @Override
    default public PStackX<T> takeUntil(Predicate<? super T> p) {
        return (PStackX)PersistentCollectionX.super.takeUntil((Predicate)p);
    }

    @Override
    default public PStackX<T> dropUntil(Predicate<? super T> p) {
        return (PStackX)PersistentCollectionX.super.dropUntil((Predicate)p);
    }

    @Override
    default public <R> PStackX<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (PStackX)PersistentCollectionX.super.trampoline((Function)mapper);
    }

    @Override
    default public PStackX<T> slice(long from, long to) {
        return (PStackX)PersistentCollectionX.super.slice(from, to);
    }

    @Override
    default public <U extends Comparable<? super U>> PStackX<T> sorted(Function<? super T, ? extends U> function) {
        return (PStackX)PersistentCollectionX.super.sorted((Function)function);
    }

    @Override
    public PStackX<T> minusAll(Collection<?> var1);

    @Override
    public PStackX<T> minus(Object var1);

    @Override
    public PStackX<T> with(int var1, T var2);

    @Override
    public PStackX<T> plus(int var1, T var2);

    @Override
    public PStackX<T> plus(T var1);

    @Override
    public PStackX<T> plusAll(Collection<? extends T> var1);

    @Override
    public PStackX<T> plusAll(int var1, Collection<? extends T> var2);

    @Override
    public PStackX<T> minus(int var1);

    @Override
    public PStackX<T> subList(int var1, int var2);

    @Override
    default public PStackX<ListX<T>> grouped(int groupSize) {
        return (PStackX)PersistentCollectionX.super.grouped(groupSize);
    }

    @Override
    default public <K, A, D> PStackX<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return (PStackX)PersistentCollectionX.super.grouped((Function)classifier, (Collector)downstream);
    }

    @Override
    default public <K> PStackX<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return (PStackX)PersistentCollectionX.super.grouped((Function)classifier);
    }

    @Override
    default public <U> PStackX<Tuple2<T, U>> zip(Iterable<? extends U> other) {
        return (PStackX)PersistentCollectionX.super.zip((Iterable)other);
    }

    @Override
    default public <U, R> PStackX<R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (PStackX)PersistentCollectionX.super.zip((Iterable)other, (BiFunction)zipper);
    }

    @Override
    default public <U, R> PStackX<R> zip(Seq<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (PStackX)PersistentCollectionX.super.zip((Seq)other, (BiFunction)zipper);
    }

    @Override
    default public <U, R> PStackX<R> zip(Stream<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (PStackX)PersistentCollectionX.super.zip((Stream)other, (BiFunction)zipper);
    }

    @Override
    default public PStackX<ReactiveSeq<T>> permutations() {
        return (PStackX)PersistentCollectionX.super.permutations();
    }

    @Override
    default public PStackX<ReactiveSeq<T>> combinations(int size) {
        return (PStackX)PersistentCollectionX.super.combinations(size);
    }

    @Override
    default public PStackX<ReactiveSeq<T>> combinations() {
        return (PStackX)PersistentCollectionX.super.combinations();
    }

    @Override
    default public PStackX<ListX<T>> sliding(int windowSize) {
        return (PStackX)PersistentCollectionX.super.sliding(windowSize);
    }

    @Override
    default public PStackX<ListX<T>> sliding(int windowSize, int increment) {
        return (PStackX)PersistentCollectionX.super.sliding(windowSize, increment);
    }

    @Override
    default public <U> PStackX<U> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return (PStackX)PersistentCollectionX.super.scanLeft((Object)seed, (BiFunction)function);
    }

    @Override
    default public <U> PStackX<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return (PStackX)PersistentCollectionX.super.scanRight((Object)identity, (BiFunction)combiner);
    }

    @Override
    default public PStackX<T> scanLeft(Monoid<T> monoid) {
        return (PStackX)PersistentCollectionX.super.scanLeft((Monoid)monoid);
    }

    @Override
    default public PStackX<T> scanRight(Monoid<T> monoid) {
        return (PStackX)PersistentCollectionX.super.scanRight((Monoid)monoid);
    }

    @Override
    default public PStackX<T> cycle(int times) {
        return (PStackX)PersistentCollectionX.super.cycle(times);
    }

    @Override
    default public PStackX<T> cycle(Monoid<T> m, int times) {
        return (PStackX)PersistentCollectionX.super.cycle((Monoid)m, times);
    }

    @Override
    default public PStackX<T> cycleWhile(Predicate<? super T> predicate) {
        return (PStackX)PersistentCollectionX.super.cycleWhile((Predicate)predicate);
    }

    @Override
    default public PStackX<T> cycleUntil(Predicate<? super T> predicate) {
        return (PStackX)PersistentCollectionX.super.cycleUntil((Predicate)predicate);
    }

    @Override
    default public <U> PStackX<Tuple2<T, U>> zip(Stream<? extends U> other) {
        return (PStackX)PersistentCollectionX.super.zip((Stream)other);
    }

    @Override
    default public <U> PStackX<Tuple2<T, U>> zip(Seq<? extends U> other) {
        return (PStackX)PersistentCollectionX.super.zip((Seq)other);
    }

    @Override
    default public <S, U> PStackX<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return (PStackX)PersistentCollectionX.super.zip3((Stream)second, (Stream)third);
    }

    @Override
    default public <T2, T3, T4> PStackX<Tuple4<T, T2, T3, T4>> zip4(Stream<? extends T2> second, Stream<? extends T3> third, Stream<? extends T4> fourth) {
        return (PStackX)PersistentCollectionX.super.zip4((Stream)second, (Stream)third, (Stream)fourth);
    }

    @Override
    default public PStackX<Tuple2<T, Long>> zipWithIndex() {
        return (PStackX)PersistentCollectionX.super.zipWithIndex();
    }

    @Override
    default public PStackX<T> distinct() {
        return (PStackX)PersistentCollectionX.super.distinct();
    }

    @Override
    default public PStackX<T> sorted() {
        return (PStackX)PersistentCollectionX.super.sorted();
    }

    @Override
    default public PStackX<T> sorted(Comparator<? super T> c) {
        return (PStackX)PersistentCollectionX.super.sorted((Comparator)c);
    }

    @Override
    default public PStackX<T> skipWhile(Predicate<? super T> p) {
        return (PStackX)PersistentCollectionX.super.skipWhile((Predicate)p);
    }

    @Override
    default public PStackX<T> skipUntil(Predicate<? super T> p) {
        return (PStackX)PersistentCollectionX.super.skipUntil((Predicate)p);
    }

    @Override
    default public PStackX<T> limitWhile(Predicate<? super T> p) {
        return (PStackX)PersistentCollectionX.super.limitWhile((Predicate)p);
    }

    @Override
    default public PStackX<T> limitUntil(Predicate<? super T> p) {
        return (PStackX)PersistentCollectionX.super.limitUntil((Predicate)p);
    }

    @Override
    default public PStackX<T> intersperse(T value) {
        return (PStackX)PersistentCollectionX.super.intersperse((Object)value);
    }

    @Override
    default public PStackX<T> shuffle() {
        return (PStackX)PersistentCollectionX.super.shuffle();
    }

    @Override
    default public PStackX<T> skipLast(int num) {
        return (PStackX)PersistentCollectionX.super.skipLast(num);
    }

    @Override
    default public PStackX<T> limitLast(int num) {
        return (PStackX)PersistentCollectionX.super.limitLast(num);
    }

    @Override
    default public PStackX<T> onEmpty(T value) {
        return (PStackX)PersistentCollectionX.super.onEmpty((Object)value);
    }

    @Override
    default public PStackX<T> onEmptyGet(Supplier<? extends T> supplier) {
        return (PStackX)PersistentCollectionX.super.onEmptyGet((Supplier)supplier);
    }

    @Override
    default public <X extends Throwable> PStackX<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return (PStackX)PersistentCollectionX.super.onEmptyThrow((Supplier)supplier);
    }

    @Override
    default public PStackX<T> shuffle(Random random) {
        return (PStackX)PersistentCollectionX.super.shuffle(random);
    }

    @Override
    default public <U> PStackX<U> ofType(Class<? extends U> type) {
        return (PStackX)PersistentCollectionX.super.ofType((Class)type);
    }

    @Override
    default public PStackX<T> filterNot(Predicate<? super T> fn) {
        return (PStackX)PersistentCollectionX.super.filterNot((Predicate)fn);
    }

    @Override
    default public PStackX<T> notNull() {
        return (PStackX)PersistentCollectionX.super.notNull();
    }

    @Override
    default public PStackX<T> removeAll(Stream<? extends T> stream) {
        return (PStackX)PersistentCollectionX.super.removeAll((Stream)stream);
    }

    @Override
    default public PStackX<T> removeAll(Iterable<? extends T> it) {
        return (PStackX)PersistentCollectionX.super.removeAll((Iterable)it);
    }

    @Override
    default public PStackX<T> removeAll(T ... values) {
        return (PStackX)PersistentCollectionX.super.removeAll((Object[])values);
    }

    @Override
    default public PStackX<T> retainAll(Iterable<? extends T> it) {
        return (PStackX)PersistentCollectionX.super.retainAll((Iterable)it);
    }

    @Override
    default public PStackX<T> retainAll(Stream<? extends T> seq) {
        return (PStackX)PersistentCollectionX.super.retainAll((Stream)seq);
    }

    @Override
    default public PStackX<T> retainAll(T ... values) {
        return (PStackX)PersistentCollectionX.super.retainAll((Object[])values);
    }

    @Override
    default public <U> PStackX<U> cast(Class<? extends U> type) {
        return (PStackX)PersistentCollectionX.super.cast((Class)type);
    }

    @Override
    default public <R> PStackX<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (PStackX)PersistentCollectionX.super.patternMatch((Function)case1, (Supplier)otherwise);
    }

    @Override
    default public <C extends Collection<? super T>> PStackX<C> grouped(int size, Supplier<C> supplier) {
        return (PStackX)PersistentCollectionX.super.grouped(size, (Supplier)supplier);
    }

    @Override
    default public PStackX<ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return (PStackX)PersistentCollectionX.super.groupedUntil((Predicate)predicate);
    }

    @Override
    default public PStackX<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return (PStackX)PersistentCollectionX.super.groupedStatefullyWhile((BiPredicate)predicate);
    }

    @Override
    default public PStackX<ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return (PStackX)PersistentCollectionX.super.groupedWhile((Predicate)predicate);
    }

    @Override
    default public <C extends Collection<? super T>> PStackX<C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (PStackX)PersistentCollectionX.super.groupedWhile((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public <C extends Collection<? super T>> PStackX<C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (PStackX)PersistentCollectionX.super.groupedUntil((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public PStackX<T> removeAll(Seq<? extends T> stream) {
        return (PStackX)PersistentCollectionX.super.removeAll((Seq)stream);
    }

    @Override
    default public PStackX<T> retainAll(Seq<? extends T> stream) {
        return (PStackX)PersistentCollectionX.super.retainAll((Seq)stream);
    }
}

