/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.collections.extensions.persistent;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.Reducer;
import com.aol.cyclops.Reducers;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.data.collections.extensions.persistent.POrderedSetXImpl;
import com.aol.cyclops.data.collections.extensions.persistent.PStackX;
import com.aol.cyclops.data.collections.extensions.persistent.PersistentCollectionX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.pcollections.OrderedPSet;
import org.pcollections.POrderedSet;
import org.reactivestreams.Publisher;

public interface POrderedSetX<T>
extends POrderedSet<T>,
PersistentCollectionX<T> {
    public static POrderedSetX<Integer> range(int start, int end) {
        return ReactiveSeq.range(start, end).toPOrderedSetX();
    }

    public static POrderedSetX<Long> rangeLong(long start, long end) {
        return ReactiveSeq.rangeLong(start, end).toPOrderedSetX();
    }

    public static <U, T> POrderedSetX<T> unfold(U seed, Function<? super U, Optional<Tuple2<T, U>>> unfolder) {
        return ReactiveSeq.unfold(seed, unfolder).toPOrderedSetX();
    }

    public static <T> POrderedSetX<T> generate(long limit, Supplier<T> s) {
        return ReactiveSeq.generate(s).limit(limit).toPOrderedSetX();
    }

    public static <T> POrderedSetX<T> iterate(long limit, T seed, UnaryOperator<T> f) {
        return ReactiveSeq.iterate(seed, f).limit(limit).toPOrderedSetX();
    }

    public static <T> POrderedSetX<T> of(T ... values) {
        return new POrderedSetXImpl(OrderedPSet.from(Arrays.asList(values)));
    }

    public static <T> POrderedSetX<T> empty() {
        return new POrderedSetXImpl(OrderedPSet.empty());
    }

    public static <T> POrderedSetX<T> singleton(T value) {
        return new POrderedSetXImpl(OrderedPSet.singleton(value));
    }

    public static <T> POrderedSetX<T> fromStream(Stream<T> stream) {
        return Reducers.toPOrderedSetX().mapReduce(stream);
    }

    public static <T> POrderedSetX<T> fromCollection(Collection<T> stream) {
        if (stream instanceof POrderedSetX) {
            return (POrderedSetX)stream;
        }
        if (stream instanceof POrderedSet) {
            return new POrderedSetXImpl((POrderedSet)stream);
        }
        return new POrderedSetXImpl(OrderedPSet.from(stream));
    }

    public static <T> POrderedSetX<T> fromPublisher(Publisher<? extends T> publisher) {
        return ReactiveSeq.fromPublisher(publisher).toPOrderedSetX();
    }

    public static <T> POrderedSetX<T> fromIterable(Iterable<T> iterable) {
        if (iterable instanceof POrderedSetX) {
            return (POrderedSetX)iterable;
        }
        if (iterable instanceof POrderedSet) {
            return new POrderedSetXImpl((POrderedSet)iterable);
        }
        OrderedPSet res = OrderedPSet.empty();
        Iterator<T> it = iterable.iterator();
        while (it.hasNext()) {
            res = res.plus(it.next());
        }
        return new POrderedSetXImpl(res);
    }

    public static <T> POrderedSetX<T> toPOrderedSet(Stream<T> stream) {
        return Reducers.toPOrderedSetX().mapReduce(stream);
    }

    @Override
    default public POrderedSetX<T> toPOrderedSetX() {
        return this;
    }

    @Override
    default public <R> POrderedSetX<R> unit(Collection<R> col) {
        return POrderedSetX.fromCollection(col);
    }

    @Override
    default public <R> POrderedSetX<R> unit(R value) {
        return POrderedSetX.singleton(value);
    }

    @Override
    default public <R> POrderedSetX<R> unitIterator(Iterator<R> it) {
        return POrderedSetX.fromIterable(() -> it);
    }

    @Override
    default public <R> POrderedSetX<R> emptyUnit() {
        return POrderedSetX.empty();
    }

    @Override
    default public ReactiveSeq<T> stream() {
        return ReactiveSeq.fromIterable(this);
    }

    default public POrderedSet<T> toPOrderedSet() {
        return this;
    }

    @Override
    default public POrderedSetX<T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return (POrderedSetX)PersistentCollectionX.super.combine((BiPredicate)predicate, (BinaryOperator)op);
    }

    @Override
    default public <X> POrderedSetX<X> from(Collection<X> col) {
        return POrderedSetX.fromCollection(col);
    }

    @Override
    default public <T> Reducer<POrderedSet<T>> monoid() {
        return Reducers.toPOrderedSet();
    }

    @Override
    public POrderedSetX<T> plus(T var1);

    @Override
    public POrderedSetX<T> plusAll(Collection<? extends T> var1);

    @Override
    public POrderedSetX<T> minus(Object var1);

    @Override
    public POrderedSetX<T> minusAll(Collection<?> var1);

    @Override
    default public POrderedSetX<T> reverse() {
        return (POrderedSetX)PersistentCollectionX.super.reverse();
    }

    @Override
    default public POrderedSetX<T> filter(Predicate<? super T> pred) {
        return (POrderedSetX)PersistentCollectionX.super.filter((Predicate)pred);
    }

    @Override
    default public <R> POrderedSetX<R> map(Function<? super T, ? extends R> mapper) {
        return (POrderedSetX)PersistentCollectionX.super.map((Function)mapper);
    }

    @Override
    default public <R> POrderedSetX<R> flatMap(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return (POrderedSetX)PersistentCollectionX.super.flatMap((Function)mapper);
    }

    @Override
    default public POrderedSetX<T> takeRight(int num) {
        return (POrderedSetX)PersistentCollectionX.super.takeRight(num);
    }

    @Override
    default public POrderedSetX<T> dropRight(int num) {
        return (POrderedSetX)PersistentCollectionX.super.dropRight(num);
    }

    @Override
    default public POrderedSetX<T> limit(long num) {
        return (POrderedSetX)PersistentCollectionX.super.limit(num);
    }

    @Override
    default public POrderedSetX<T> skip(long num) {
        return (POrderedSetX)PersistentCollectionX.super.skip(num);
    }

    @Override
    default public POrderedSetX<T> takeWhile(Predicate<? super T> p) {
        return (POrderedSetX)PersistentCollectionX.super.takeWhile((Predicate)p);
    }

    @Override
    default public POrderedSetX<T> dropWhile(Predicate<? super T> p) {
        return (POrderedSetX)PersistentCollectionX.super.dropWhile((Predicate)p);
    }

    @Override
    default public POrderedSetX<T> takeUntil(Predicate<? super T> p) {
        return (POrderedSetX)PersistentCollectionX.super.takeUntil((Predicate)p);
    }

    @Override
    default public POrderedSetX<T> dropUntil(Predicate<? super T> p) {
        return (POrderedSetX)PersistentCollectionX.super.dropUntil((Predicate)p);
    }

    @Override
    default public <R> POrderedSetX<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (POrderedSetX)PersistentCollectionX.super.trampoline((Function)mapper);
    }

    @Override
    default public POrderedSetX<T> slice(long from, long to) {
        return (POrderedSetX)PersistentCollectionX.super.slice(from, to);
    }

    @Override
    default public <U extends Comparable<? super U>> POrderedSetX<T> sorted(Function<? super T, ? extends U> function) {
        return (POrderedSetX)PersistentCollectionX.super.sorted((Function)function);
    }

    @Override
    default public POrderedSetX<ListX<T>> grouped(int groupSize) {
        return (POrderedSetX)PersistentCollectionX.super.grouped(groupSize);
    }

    @Override
    default public <K, A, D> POrderedSetX<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return (POrderedSetX)PersistentCollectionX.super.grouped((Function)classifier, (Collector)downstream);
    }

    @Override
    default public <K> POrderedSetX<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return (POrderedSetX)PersistentCollectionX.super.grouped((Function)classifier);
    }

    @Override
    default public <U> POrderedSetX<Tuple2<T, U>> zip(Iterable<? extends U> other) {
        return (POrderedSetX)PersistentCollectionX.super.zip((Iterable)other);
    }

    @Override
    default public <U, R> POrderedSetX<R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (POrderedSetX)PersistentCollectionX.super.zip((Iterable)other, (BiFunction)zipper);
    }

    @Override
    default public <U, R> POrderedSetX<R> zip(Seq<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (POrderedSetX)PersistentCollectionX.super.zip((Seq)other, (BiFunction)zipper);
    }

    @Override
    default public <U, R> POrderedSetX<R> zip(Stream<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (POrderedSetX)PersistentCollectionX.super.zip((Stream)other, (BiFunction)zipper);
    }

    @Override
    default public POrderedSetX<ReactiveSeq<T>> permutations() {
        return (POrderedSetX)PersistentCollectionX.super.permutations();
    }

    @Override
    default public POrderedSetX<ReactiveSeq<T>> combinations(int size) {
        return (POrderedSetX)PersistentCollectionX.super.combinations(size);
    }

    @Override
    default public POrderedSetX<ReactiveSeq<T>> combinations() {
        return (POrderedSetX)PersistentCollectionX.super.combinations();
    }

    @Override
    default public POrderedSetX<ListX<T>> sliding(int windowSize) {
        return (POrderedSetX)PersistentCollectionX.super.sliding(windowSize);
    }

    @Override
    default public POrderedSetX<ListX<T>> sliding(int windowSize, int increment) {
        return (POrderedSetX)PersistentCollectionX.super.sliding(windowSize, increment);
    }

    @Override
    default public POrderedSetX<T> scanLeft(Monoid<T> monoid) {
        return (POrderedSetX)PersistentCollectionX.super.scanLeft((Monoid)monoid);
    }

    @Override
    default public <U> POrderedSetX<U> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return (POrderedSetX)PersistentCollectionX.super.scanLeft((Object)seed, (BiFunction)function);
    }

    @Override
    default public POrderedSetX<T> scanRight(Monoid<T> monoid) {
        return (POrderedSetX)PersistentCollectionX.super.scanRight((Monoid)monoid);
    }

    @Override
    default public <U> POrderedSetX<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return (POrderedSetX)PersistentCollectionX.super.scanRight((Object)identity, (BiFunction)combiner);
    }

    @Override
    default public POrderedSetX<T> plusInOrder(T e) {
        return (POrderedSetX)PersistentCollectionX.super.plusInOrder((Object)e);
    }

    @Override
    default public PStackX<T> cycle(int times) {
        return this.stream().cycle(times).toPStackX();
    }

    @Override
    default public PStackX<T> cycle(Monoid<T> m, int times) {
        return this.stream().cycle(m, times).toPStackX();
    }

    @Override
    default public PStackX<T> cycleWhile(Predicate<? super T> predicate) {
        return this.stream().cycleWhile(predicate).toPStackX();
    }

    @Override
    default public PStackX<T> cycleUntil(Predicate<? super T> predicate) {
        return this.stream().cycleUntil(predicate).toPStackX();
    }

    @Override
    default public <U> POrderedSetX<Tuple2<T, U>> zip(Stream<? extends U> other) {
        return (POrderedSetX)PersistentCollectionX.super.zip((Stream)other);
    }

    @Override
    default public <U> POrderedSetX<Tuple2<T, U>> zip(Seq<? extends U> other) {
        return (POrderedSetX)PersistentCollectionX.super.zip((Seq)other);
    }

    @Override
    default public <S, U> POrderedSetX<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return (POrderedSetX)PersistentCollectionX.super.zip3((Stream)second, (Stream)third);
    }

    @Override
    default public <T2, T3, T4> POrderedSetX<Tuple4<T, T2, T3, T4>> zip4(Stream<? extends T2> second, Stream<? extends T3> third, Stream<? extends T4> fourth) {
        return (POrderedSetX)PersistentCollectionX.super.zip4((Stream)second, (Stream)third, (Stream)fourth);
    }

    @Override
    default public POrderedSetX<Tuple2<T, Long>> zipWithIndex() {
        return (POrderedSetX)PersistentCollectionX.super.zipWithIndex();
    }

    @Override
    default public POrderedSetX<T> distinct() {
        return (POrderedSetX)PersistentCollectionX.super.distinct();
    }

    @Override
    default public POrderedSetX<T> sorted() {
        return (POrderedSetX)PersistentCollectionX.super.sorted();
    }

    @Override
    default public POrderedSetX<T> sorted(Comparator<? super T> c) {
        return (POrderedSetX)PersistentCollectionX.super.sorted((Comparator)c);
    }

    @Override
    default public POrderedSetX<T> skipWhile(Predicate<? super T> p) {
        return (POrderedSetX)PersistentCollectionX.super.skipWhile((Predicate)p);
    }

    @Override
    default public POrderedSetX<T> skipUntil(Predicate<? super T> p) {
        return (POrderedSetX)PersistentCollectionX.super.skipUntil((Predicate)p);
    }

    @Override
    default public POrderedSetX<T> limitWhile(Predicate<? super T> p) {
        return (POrderedSetX)PersistentCollectionX.super.limitWhile((Predicate)p);
    }

    @Override
    default public POrderedSetX<T> limitUntil(Predicate<? super T> p) {
        return (POrderedSetX)PersistentCollectionX.super.limitUntil((Predicate)p);
    }

    @Override
    default public POrderedSetX<T> intersperse(T value) {
        return (POrderedSetX)PersistentCollectionX.super.intersperse((Object)value);
    }

    @Override
    default public POrderedSetX<T> shuffle() {
        return (POrderedSetX)PersistentCollectionX.super.shuffle();
    }

    @Override
    default public POrderedSetX<T> skipLast(int num) {
        return (POrderedSetX)PersistentCollectionX.super.skipLast(num);
    }

    @Override
    default public POrderedSetX<T> limitLast(int num) {
        return (POrderedSetX)PersistentCollectionX.super.limitLast(num);
    }

    @Override
    default public POrderedSetX<T> onEmpty(T value) {
        return (POrderedSetX)PersistentCollectionX.super.onEmpty((Object)value);
    }

    @Override
    default public POrderedSetX<T> onEmptyGet(Supplier<? extends T> supplier) {
        return (POrderedSetX)PersistentCollectionX.super.onEmptyGet((Supplier)supplier);
    }

    @Override
    default public <X extends Throwable> POrderedSetX<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return (POrderedSetX)PersistentCollectionX.super.onEmptyThrow((Supplier)supplier);
    }

    @Override
    default public POrderedSetX<T> shuffle(Random random) {
        return (POrderedSetX)PersistentCollectionX.super.shuffle(random);
    }

    @Override
    default public <U> POrderedSetX<U> ofType(Class<? extends U> type) {
        return (POrderedSetX)PersistentCollectionX.super.ofType((Class)type);
    }

    @Override
    default public POrderedSetX<T> filterNot(Predicate<? super T> fn) {
        return (POrderedSetX)PersistentCollectionX.super.filterNot((Predicate)fn);
    }

    @Override
    default public POrderedSetX<T> notNull() {
        return (POrderedSetX)PersistentCollectionX.super.notNull();
    }

    @Override
    default public POrderedSetX<T> removeAll(Stream<? extends T> stream) {
        return (POrderedSetX)PersistentCollectionX.super.removeAll((Stream)stream);
    }

    @Override
    default public POrderedSetX<T> removeAll(Iterable<? extends T> it) {
        return (POrderedSetX)PersistentCollectionX.super.removeAll((Iterable)it);
    }

    @Override
    default public POrderedSetX<T> removeAll(T ... values) {
        return (POrderedSetX)PersistentCollectionX.super.removeAll((Object[])values);
    }

    @Override
    default public POrderedSetX<T> retainAll(Iterable<? extends T> it) {
        return (POrderedSetX)PersistentCollectionX.super.retainAll((Iterable)it);
    }

    @Override
    default public POrderedSetX<T> retainAll(Stream<? extends T> seq) {
        return (POrderedSetX)PersistentCollectionX.super.retainAll((Stream)seq);
    }

    @Override
    default public POrderedSetX<T> retainAll(T ... values) {
        return (POrderedSetX)PersistentCollectionX.super.retainAll((Object[])values);
    }

    @Override
    default public <U> POrderedSetX<U> cast(Class<? extends U> type) {
        return (POrderedSetX)PersistentCollectionX.super.cast((Class)type);
    }

    @Override
    default public <R> POrderedSetX<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (POrderedSetX)PersistentCollectionX.super.patternMatch((Function)case1, (Supplier)otherwise);
    }

    @Override
    default public <C extends Collection<? super T>> POrderedSetX<C> grouped(int size, Supplier<C> supplier) {
        return (POrderedSetX)PersistentCollectionX.super.grouped(size, (Supplier)supplier);
    }

    @Override
    default public POrderedSetX<ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return (POrderedSetX)PersistentCollectionX.super.groupedUntil((Predicate)predicate);
    }

    @Override
    default public POrderedSetX<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return (POrderedSetX)PersistentCollectionX.super.groupedStatefullyWhile((BiPredicate)predicate);
    }

    @Override
    default public POrderedSetX<ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return (POrderedSetX)PersistentCollectionX.super.groupedWhile((Predicate)predicate);
    }

    @Override
    default public <C extends Collection<? super T>> POrderedSetX<C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (POrderedSetX)PersistentCollectionX.super.groupedWhile((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public <C extends Collection<? super T>> POrderedSetX<C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (POrderedSetX)PersistentCollectionX.super.groupedUntil((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public POrderedSetX<T> removeAll(Seq<? extends T> stream) {
        return (POrderedSetX)PersistentCollectionX.super.removeAll((Seq)stream);
    }

    @Override
    default public POrderedSetX<T> retainAll(Seq<? extends T> stream) {
        return (POrderedSetX)PersistentCollectionX.super.retainAll((Seq)stream);
    }
}

