/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.async.wait;

import com.aol.cyclops.data.async.wait.WaitStrategy;
import java.beans.ConstructorProperties;
import java.util.concurrent.locks.LockSupport;

public class ExponentialBackofWaitStrategy<T>
implements WaitStrategy<T> {
    private final double backoffNanos;
    private final double coefficient;

    public ExponentialBackofWaitStrategy() {
        this.backoffNanos = 1.0;
        this.coefficient = 1.1;
    }

    @Override
    public T take(WaitStrategy.Takeable<T> t) throws InterruptedException {
        T result;
        double currentBackoff = this.backoffNanos;
        while ((result = t.take()) == null) {
            LockSupport.parkNanos((long)currentBackoff);
            currentBackoff *= this.coefficient;
        }
        return result;
    }

    @Override
    public boolean offer(WaitStrategy.Offerable o) throws InterruptedException {
        double currentBackoff = this.backoffNanos;
        while (!o.offer()) {
            LockSupport.parkNanos((long)currentBackoff);
            currentBackoff *= this.coefficient;
        }
        return true;
    }

    @ConstructorProperties(value={"backoffNanos", "coefficient"})
    public ExponentialBackofWaitStrategy(double backoffNanos, double coefficient) {
        this.backoffNanos = backoffNanos;
        this.coefficient = coefficient;
    }
}

