/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data;

import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.data.Mutable;
import java.beans.ConstructorProperties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class MutableFloat
implements Supplier<Float>,
Consumer<Float>,
Matchable.ValueAndOptionalMatcher<Float> {
    private float var;

    public static <T> MutableFloat of(float var) {
        return new MutableFloat(var);
    }

    public static MutableFloat fromExternal(final Supplier<Float> s, final Consumer<Float> c) {
        return new MutableFloat(){

            @Override
            public float getAsFloat() {
                return ((Float)s.get()).floatValue();
            }

            @Override
            public Float get() {
                return Float.valueOf(this.getAsFloat());
            }

            @Override
            public MutableFloat set(float value) {
                c.accept(Float.valueOf(value));
                return this;
            }
        };
    }

    public <R> Mutable<R> mapOutputToObj(final Function<Float, R> fn) {
        final MutableFloat host = this;
        return new Mutable<R>(){

            @Override
            public R get() {
                return fn.apply(host.get());
            }
        };
    }

    public <T1> Mutable<T1> mapInputToObj(final Function<T1, Float> fn) {
        final MutableFloat host = this;
        return new Mutable<T1>(){

            @Override
            public Mutable<T1> set(T1 value) {
                host.set(((Float)fn.apply(value)).floatValue());
                return this;
            }
        };
    }

    public float getAsFloat() {
        return this.var;
    }

    public MutableFloat set(float var) {
        this.var = var;
        return this;
    }

    public MutableFloat mutate(FloatFunction varFn) {
        this.var = varFn.apply(this.var);
        return this;
    }

    @Override
    public Float get() {
        return Float.valueOf(this.var);
    }

    @Override
    public void accept(Float t) {
        this.set(t.floatValue());
    }

    @ConstructorProperties(value={"var"})
    public MutableFloat(float var) {
        this.var = var;
    }

    public MutableFloat() {
    }

    public String toString() {
        return "MutableFloat(var=" + this.var + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MutableFloat)) {
            return false;
        }
        MutableFloat other = (MutableFloat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Float.compare(this.var, other.var) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof MutableFloat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.var);
        return result;
    }

    public static interface FloatFunction {
        public float apply(float var1);
    }
}

