/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control.monads.transformers.seq;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Xor;
import com.aol.cyclops.control.monads.transformers.XorT;
import com.aol.cyclops.control.monads.transformers.values.ValueTransformerSeq;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.types.IterableFoldable;
import com.aol.cyclops.types.MonadicValue2;
import com.aol.cyclops.types.Sequential;
import com.aol.cyclops.types.Traversable;
import com.aol.cyclops.types.anyM.AnyMSeq;
import com.aol.cyclops.types.stream.ConvertableSequence;
import com.aol.cyclops.types.stream.CyclopsCollectable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jooq.lambda.Collectable;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;

public class XorTSeq<ST, T>
implements XorT<ST, T>,
ValueTransformerSeq<T>,
IterableFoldable<T>,
ConvertableSequence<T>,
CyclopsCollectable<T>,
Sequential<T> {
    private final AnyMSeq<Xor<ST, T>> run;

    private XorTSeq(AnyMSeq<Xor<ST, T>> run) {
        this.run = run;
    }

    @Override
    public AnyMSeq<Xor<ST, T>> unwrap() {
        return this.run;
    }

    @Override
    public XorTSeq<ST, T> peek(Consumer<? super T> peek) {
        return XorTSeq.of(this.run.peek((T opt) -> opt.map((T a) -> {
            peek.accept(a);
            return a;
        })));
    }

    @Override
    public XorTSeq<ST, T> filter(Predicate<? super T> test) {
        return XorTSeq.of(this.run.map((T opt) -> opt.filter(test)));
    }

    @Override
    public <B> XorTSeq<ST, B> map(Function<? super T, ? extends B> f) {
        return new XorTSeq<ST, T>(this.run.map((T o) -> o.map(f)));
    }

    public <ST2, B> XorTSeq<ST, B> flatMapT(Function<? super T, XorTSeq<ST2, ? extends B>> f) {
        return XorTSeq.of(this.run.bind((T opt) -> {
            if (opt.isPrimary()) {
                return ((XorTSeq)f.apply(opt.get())).run.unwrap();
            }
            return this;
        }));
    }

    public <T> XorTSeq<ST, T> unitStream(ReactiveSeq<T> traversable) {
        return XorT.fromStream(traversable.map(Xor::primary));
    }

    public <T> XorTSeq<ST, T> unitAnyM(AnyM<Traversable<T>> traversable) {
        return XorTSeq.of((AnyMSeq)traversable.map((T t) -> Xor.fromIterable(t)));
    }

    public AnyMSeq<? extends Traversable<T>> transformerStream() {
        return this.run.map((T e) -> e.toListX());
    }

    @Override
    public XorTSeq<T, ST> swap() {
        return XorTSeq.of(this.run.map((T xor) -> xor.swap()));
    }

    @Override
    public <ST2, B> XorTSeq<ST2, B> flatMap(Function<? super T, ? extends MonadicValue2<? extends ST2, ? extends B>> f) {
        return new XorTSeq<ST, T>(this.run.map((T o) -> o.flatMap(f)));
    }

    public static <ST, U, R> Function<XorTSeq<ST, U>, XorTSeq<ST, R>> lift(Function<? super U, ? extends R> fn) {
        return optTu -> optTu.map((T input) -> fn.apply((Object)input));
    }

    public static <ST, U1, U2, R> BiFunction<XorTSeq<ST, U1>, XorTSeq<ST, U2>, XorTSeq<ST, R>> lift2(BiFunction<? super U1, ? super U2, ? extends R> fn) {
        return (optTu1, optTu2) -> optTu1.flatMapT(input1 -> optTu2.map((T input2) -> fn.apply((Object)input1, (Object)input2)));
    }

    public static <ST, A> XorTSeq<ST, A> fromAnyM(AnyMSeq<A> anyM) {
        return XorTSeq.of(anyM.map(Xor::primary));
    }

    public static <ST, A> XorTSeq<ST, A> of(AnyMSeq<Xor<ST, A>> monads) {
        return new XorTSeq(monads);
    }

    public static <ST, A> XorTSeq<ST, A> of(Xor<ST, A> monads) {
        return XorT.fromIterable(ListX.of(new Xor[]{monads}));
    }

    public String toString() {
        return String.format("XorTSeq[%s]", this.run);
    }

    public boolean isPrimary() {
        return this.run.allMatch(x -> x.isPrimary());
    }

    public boolean isSecondary() {
        return this.run.allMatch(x -> x.isSecondary());
    }

    public <R> R visit(Function<ST, ? extends R> secondary, Function<? super T, ? extends R> primary, Monoid<R> combiner) {
        return this.run.map((T t) -> t.visit(secondary, primary)).reduce(combiner);
    }

    @Override
    public <R> XorTSeq<ST, R> unit(R value) {
        return XorTSeq.of(this.run.unit((Object)Xor.primary(value)));
    }

    @Override
    public <R> XorTSeq<ST, R> empty() {
        return XorTSeq.of(this.run.unit((Object)Xor.secondary(null)));
    }

    @Override
    public ReactiveSeq<T> stream() {
        return this.run.stream().flatMapIterable(e -> e);
    }

    @Override
    public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    public <R> XorTSeq<ST, R> unitIterator(Iterator<R> it) {
        return XorTSeq.of(this.run.unitIterator(it).map((T i) -> Xor.primary(i)));
    }

    @Override
    public Collectable<T> collectable() {
        return this.stream();
    }

    @Override
    public boolean isSeqPresent() {
        return !this.run.isEmpty();
    }

    public static <ST, T> XorTSeq<ST, T> emptyList() {
        return XorT.fromIterable(ListX.of(new Xor[0]));
    }

    public XorTSeq<ST, T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return (XorTSeq)ValueTransformerSeq.super.combine(predicate, op);
    }

    public XorTSeq<ST, T> cycle(int times) {
        return (XorTSeq)ValueTransformerSeq.super.cycle(times);
    }

    public XorTSeq<ST, T> cycle(Monoid<T> m, int times) {
        return (XorTSeq)ValueTransformerSeq.super.cycle(m, times);
    }

    public XorTSeq<ST, T> cycleWhile(Predicate<? super T> predicate) {
        return (XorTSeq)ValueTransformerSeq.super.cycleWhile(predicate);
    }

    public XorTSeq<ST, T> cycleUntil(Predicate<? super T> predicate) {
        return (XorTSeq)ValueTransformerSeq.super.cycleUntil(predicate);
    }

    public <U, R> XorTSeq<ST, R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (XorTSeq)ValueTransformerSeq.super.zip(other, zipper);
    }

    public <U, R> XorTSeq<ST, R> zip(Seq<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (XorTSeq)ValueTransformerSeq.super.zip(other, zipper);
    }

    public <U, R> XorTSeq<ST, R> zip(Stream<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (XorTSeq)ValueTransformerSeq.super.zip(other, zipper);
    }

    public <U> XorTSeq<ST, Tuple2<T, U>> zip(Stream<? extends U> other) {
        return (XorTSeq)ValueTransformerSeq.super.zip(other);
    }

    public <U> XorTSeq<ST, Tuple2<T, U>> zip(Seq<? extends U> other) {
        return (XorTSeq)ValueTransformerSeq.super.zip(other);
    }

    public <U> XorTSeq<ST, Tuple2<T, U>> zip(Iterable<? extends U> other) {
        return (XorTSeq)ValueTransformerSeq.super.zip(other);
    }

    public <S, U> XorTSeq<ST, Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return (XorTSeq)ValueTransformerSeq.super.zip3(second, third);
    }

    public <T2, T3, T4> XorTSeq<ST, Tuple4<T, T2, T3, T4>> zip4(Stream<? extends T2> second, Stream<? extends T3> third, Stream<? extends T4> fourth) {
        return (XorTSeq)ValueTransformerSeq.super.zip4(second, third, fourth);
    }

    public XorTSeq<ST, Tuple2<T, Long>> zipWithIndex() {
        return (XorTSeq)ValueTransformerSeq.super.zipWithIndex();
    }

    public XorTSeq<ST, ListX<T>> sliding(int windowSize) {
        return (XorTSeq)ValueTransformerSeq.super.sliding(windowSize);
    }

    public XorTSeq<ST, ListX<T>> sliding(int windowSize, int increment) {
        return (XorTSeq)ValueTransformerSeq.super.sliding(windowSize, increment);
    }

    public <C extends Collection<? super T>> XorTSeq<ST, C> grouped(int size, Supplier<C> supplier) {
        return (XorTSeq)ValueTransformerSeq.super.grouped(size, supplier);
    }

    public XorTSeq<ST, ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return (XorTSeq)ValueTransformerSeq.super.groupedUntil(predicate);
    }

    public XorTSeq<ST, ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return (XorTSeq)ValueTransformerSeq.super.groupedStatefullyWhile(predicate);
    }

    public XorTSeq<ST, ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return (XorTSeq)ValueTransformerSeq.super.groupedWhile(predicate);
    }

    public <C extends Collection<? super T>> XorTSeq<ST, C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (XorTSeq)ValueTransformerSeq.super.groupedWhile(predicate, factory2);
    }

    public <C extends Collection<? super T>> XorTSeq<ST, C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (XorTSeq)ValueTransformerSeq.super.groupedUntil(predicate, factory2);
    }

    public XorTSeq<ST, ListX<T>> grouped(int groupSize) {
        return (XorTSeq)ValueTransformerSeq.super.grouped(groupSize);
    }

    public <K, A, D> XorTSeq<ST, Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return (XorTSeq)ValueTransformerSeq.super.grouped(classifier, downstream);
    }

    public <K> XorTSeq<ST, Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return (XorTSeq)ValueTransformerSeq.super.grouped(classifier);
    }

    public XorTSeq<ST, T> distinct() {
        return (XorTSeq)ValueTransformerSeq.super.distinct();
    }

    public XorTSeq<ST, T> scanLeft(Monoid<T> monoid) {
        return (XorTSeq)ValueTransformerSeq.super.scanLeft(monoid);
    }

    public <U> XorTSeq<ST, U> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return (XorTSeq)ValueTransformerSeq.super.scanLeft(seed, function);
    }

    public XorTSeq<ST, T> scanRight(Monoid<T> monoid) {
        return (XorTSeq)ValueTransformerSeq.super.scanRight(monoid);
    }

    public <U> XorTSeq<ST, U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return (XorTSeq)ValueTransformerSeq.super.scanRight(identity, combiner);
    }

    public XorTSeq<ST, T> sorted() {
        return (XorTSeq)ValueTransformerSeq.super.sorted();
    }

    public XorTSeq<ST, T> sorted(Comparator<? super T> c) {
        return (XorTSeq)ValueTransformerSeq.super.sorted(c);
    }

    public XorTSeq<ST, T> takeWhile(Predicate<? super T> p) {
        return (XorTSeq)ValueTransformerSeq.super.takeWhile(p);
    }

    public XorTSeq<ST, T> dropWhile(Predicate<? super T> p) {
        return (XorTSeq)ValueTransformerSeq.super.dropWhile(p);
    }

    public XorTSeq<ST, T> takeUntil(Predicate<? super T> p) {
        return (XorTSeq)ValueTransformerSeq.super.takeUntil(p);
    }

    public XorTSeq<ST, T> dropUntil(Predicate<? super T> p) {
        return (XorTSeq)ValueTransformerSeq.super.dropUntil(p);
    }

    public XorTSeq<ST, T> dropRight(int num) {
        return (XorTSeq)ValueTransformerSeq.super.dropRight(num);
    }

    public XorTSeq<ST, T> takeRight(int num) {
        return (XorTSeq)ValueTransformerSeq.super.takeRight(num);
    }

    public XorTSeq<ST, T> skip(long num) {
        return (XorTSeq)ValueTransformerSeq.super.skip(num);
    }

    public XorTSeq<ST, T> skipWhile(Predicate<? super T> p) {
        return (XorTSeq)ValueTransformerSeq.super.skipWhile(p);
    }

    public XorTSeq<ST, T> skipUntil(Predicate<? super T> p) {
        return (XorTSeq)ValueTransformerSeq.super.skipUntil(p);
    }

    public XorTSeq<ST, T> limit(long num) {
        return (XorTSeq)ValueTransformerSeq.super.limit(num);
    }

    public XorTSeq<ST, T> limitWhile(Predicate<? super T> p) {
        return (XorTSeq)ValueTransformerSeq.super.limitWhile(p);
    }

    public XorTSeq<ST, T> limitUntil(Predicate<? super T> p) {
        return (XorTSeq)ValueTransformerSeq.super.limitUntil(p);
    }

    public XorTSeq<ST, T> intersperse(T value) {
        return (XorTSeq)ValueTransformerSeq.super.intersperse(value);
    }

    public XorTSeq<ST, T> reverse() {
        return (XorTSeq)ValueTransformerSeq.super.reverse();
    }

    public XorTSeq<ST, T> shuffle() {
        return (XorTSeq)ValueTransformerSeq.super.shuffle();
    }

    public XorTSeq<ST, T> skipLast(int num) {
        return (XorTSeq)ValueTransformerSeq.super.skipLast(num);
    }

    public XorTSeq<ST, T> limitLast(int num) {
        return (XorTSeq)ValueTransformerSeq.super.limitLast(num);
    }

    public XorTSeq<ST, T> onEmpty(T value) {
        return (XorTSeq)ValueTransformerSeq.super.onEmpty(value);
    }

    public XorTSeq<ST, T> onEmptyGet(Supplier<? extends T> supplier) {
        return (XorTSeq)ValueTransformerSeq.super.onEmptyGet(supplier);
    }

    public <X extends Throwable> XorTSeq<ST, T> onEmptyThrow(Supplier<? extends X> supplier) {
        return (XorTSeq)ValueTransformerSeq.super.onEmptyThrow(supplier);
    }

    public XorTSeq<ST, T> shuffle(Random random) {
        return (XorTSeq)ValueTransformerSeq.super.shuffle(random);
    }

    public XorTSeq<ST, T> slice(long from, long to) {
        return (XorTSeq)ValueTransformerSeq.super.slice(from, to);
    }

    public <U extends Comparable<? super U>> XorTSeq<ST, T> sorted(Function<? super T, ? extends U> function) {
        return (XorTSeq)ValueTransformerSeq.super.sorted(function);
    }

    public int hashCode() {
        return this.run.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof XorTSeq) {
            return this.run.equals(((XorTSeq)o).run);
        }
        return false;
    }
}

