/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control.monads.transformers.seq;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.monads.transformers.StreamableT;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.types.IterableFoldable;
import com.aol.cyclops.types.Traversable;
import com.aol.cyclops.types.anyM.AnyMSeq;
import com.aol.cyclops.types.stream.CyclopsCollectable;
import com.aol.cyclops.util.stream.Streamable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;

public class StreamableTSeq<T>
implements StreamableT<T> {
    final AnyMSeq<Streamable<T>> run;

    private StreamableTSeq(AnyMSeq<Streamable<T>> run) {
        this.run = run;
    }

    @Override
    public boolean isSeqPresent() {
        return !this.run.isEmpty();
    }

    @Override
    public AnyM<Streamable<T>> unwrap() {
        return this.run;
    }

    @Override
    public StreamableTSeq<T> peek(Consumer<? super T> peek) {
        return this.map((T a) -> {
            peek.accept(a);
            return a;
        });
    }

    @Override
    public StreamableTSeq<T> filter(Predicate<? super T> test) {
        return StreamableTSeq.of(this.run.map((T stream) -> stream.filter(test)));
    }

    @Override
    public <B> StreamableTSeq<B> map(Function<? super T, ? extends B> f) {
        return new StreamableTSeq<T>(this.run.map((T o) -> o.map(f)));
    }

    public <B> StreamableTSeq<B> flatMapT(Function<? super T, StreamableTSeq<? extends B>> f) {
        return StreamableTSeq.of(this.run.map((T stream) -> stream.flatMap((? super T a) -> Streamable.fromStream(((StreamableTSeq)f.apply(a)).run.stream())).flatMap((? super T a) -> a)));
    }

    @Override
    public <B> StreamableTSeq<B> flatMap(Function<? super T, ? extends Iterable<? extends B>> f) {
        return new StreamableTSeq<T>(this.run.map((T o) -> o.flatMapIterable(f)));
    }

    public static <U, R> Function<StreamableTSeq<U>, StreamableTSeq<R>> lift(Function<? super U, ? extends R> fn) {
        return optTu -> optTu.map((T input) -> fn.apply((Object)input));
    }

    public static <U1, U2, R> BiFunction<StreamableTSeq<U1>, StreamableTSeq<U2>, StreamableTSeq<R>> lift2(BiFunction<? super U1, ? super U2, ? extends R> fn) {
        return (optTu1, optTu2) -> optTu1.flatMapT(input1 -> optTu2.map((T input2) -> fn.apply((Object)input1, (Object)input2)));
    }

    public static <A> StreamableTSeq<A> fromAnyM(AnyMSeq<A> anyM) {
        return StreamableTSeq.of(anyM.map((T xva$0) -> Streamable.of(xva$0)));
    }

    public static <A> StreamableTSeq<A> of(AnyMSeq<Streamable<A>> monads) {
        return new StreamableTSeq(monads);
    }

    public static <A> StreamableTSeq<A> of(Streamable<A> monads) {
        return StreamableT.fromIterable(Streamable.of(monads));
    }

    public static <A> StreamableTSeq<A> fromStream(AnyMSeq<Stream<A>> monads) {
        return new StreamableTSeq(monads.map(Streamable::fromStream));
    }

    public String toString() {
        return String.format("StreamableTSeq[%s]", this.run);
    }

    @Override
    public <T> StreamableTSeq<T> unit(T unit) {
        return StreamableTSeq.of(this.run.unit((Object)Streamable.of(unit)));
    }

    @Override
    public ReactiveSeq<T> stream() {
        return this.run.stream().flatMapIterable(e -> e);
    }

    @Override
    public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    @Override
    public <R> StreamableTSeq<R> unitIterator(Iterator<R> it) {
        return StreamableTSeq.of(this.run.unitIterator(it).map((T i) -> Streamable.of(i)));
    }

    @Override
    public <R> StreamableTSeq<R> empty() {
        return StreamableTSeq.of(this.run.empty());
    }

    @Override
    public AnyM<? extends IterableFoldable<T>> nestedFoldables() {
        return this.run;
    }

    @Override
    public AnyM<? extends CyclopsCollectable<T>> nestedCollectables() {
        return this.run;
    }

    @Override
    public <T> StreamableTSeq<T> unitAnyM(AnyM<Traversable<T>> traversable) {
        return StreamableTSeq.of((AnyMSeq)traversable.map((T t) -> Streamable.fromIterable(t)));
    }

    public AnyMSeq<? extends Traversable<T>> transformerStream() {
        return this.run;
    }

    public static <T> StreamableTSeq<T> emptyStreamable() {
        return StreamableT.fromIterable(Streamable.empty());
    }

    @Override
    public StreamableTSeq<T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return (StreamableTSeq)StreamableT.super.combine((BiPredicate)predicate, (BinaryOperator)op);
    }

    @Override
    public StreamableTSeq<T> cycle(int times) {
        return (StreamableTSeq)StreamableT.super.cycle(times);
    }

    @Override
    public StreamableTSeq<T> cycle(Monoid<T> m, int times) {
        return (StreamableTSeq)StreamableT.super.cycle((Monoid)m, times);
    }

    @Override
    public StreamableTSeq<T> cycleWhile(Predicate<? super T> predicate) {
        return (StreamableTSeq)StreamableT.super.cycleWhile((Predicate)predicate);
    }

    @Override
    public StreamableTSeq<T> cycleUntil(Predicate<? super T> predicate) {
        return (StreamableTSeq)StreamableT.super.cycleUntil((Predicate)predicate);
    }

    @Override
    public <U, R> StreamableTSeq<R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (StreamableTSeq)StreamableT.super.zip((Iterable)other, (BiFunction)zipper);
    }

    @Override
    public <U, R> StreamableTSeq<R> zip(Seq<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (StreamableTSeq)StreamableT.super.zip((Seq)other, (BiFunction)zipper);
    }

    @Override
    public <U, R> StreamableTSeq<R> zip(Stream<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (StreamableTSeq)StreamableT.super.zip((Stream)other, (BiFunction)zipper);
    }

    @Override
    public <U> StreamableTSeq<Tuple2<T, U>> zip(Stream<? extends U> other) {
        return (StreamableTSeq)StreamableT.super.zip((Stream)other);
    }

    @Override
    public <U> StreamableTSeq<Tuple2<T, U>> zip(Iterable<? extends U> other) {
        return (StreamableTSeq)StreamableT.super.zip((Iterable)other);
    }

    @Override
    public <U> StreamableTSeq<Tuple2<T, U>> zip(Seq<? extends U> other) {
        return (StreamableTSeq)StreamableT.super.zip((Seq)other);
    }

    @Override
    public <S, U> StreamableTSeq<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return (StreamableTSeq)StreamableT.super.zip3((Stream)second, (Stream)third);
    }

    @Override
    public <T2, T3, T4> StreamableTSeq<Tuple4<T, T2, T3, T4>> zip4(Stream<? extends T2> second, Stream<? extends T3> third, Stream<? extends T4> fourth) {
        return (StreamableTSeq)StreamableT.super.zip4((Stream)second, (Stream)third, (Stream)fourth);
    }

    @Override
    public StreamableTSeq<Tuple2<T, Long>> zipWithIndex() {
        return (StreamableTSeq)StreamableT.super.zipWithIndex();
    }

    @Override
    public StreamableTSeq<ListX<T>> sliding(int windowSize) {
        return (StreamableTSeq)StreamableT.super.sliding(windowSize);
    }

    @Override
    public StreamableTSeq<ListX<T>> sliding(int windowSize, int increment) {
        return (StreamableTSeq)StreamableT.super.sliding(windowSize, increment);
    }

    @Override
    public <C extends Collection<? super T>> StreamableTSeq<C> grouped(int size, Supplier<C> supplier) {
        return (StreamableTSeq)StreamableT.super.grouped(size, (Supplier)supplier);
    }

    @Override
    public StreamableTSeq<ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return (StreamableTSeq)StreamableT.super.groupedUntil((Predicate)predicate);
    }

    @Override
    public StreamableTSeq<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return (StreamableTSeq)StreamableT.super.groupedStatefullyWhile((BiPredicate)predicate);
    }

    @Override
    public StreamableTSeq<ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return (StreamableTSeq)StreamableT.super.groupedWhile((Predicate)predicate);
    }

    @Override
    public <C extends Collection<? super T>> StreamableTSeq<C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (StreamableTSeq)StreamableT.super.groupedWhile((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    public <C extends Collection<? super T>> StreamableTSeq<C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (StreamableTSeq)StreamableT.super.groupedUntil((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    public StreamableTSeq<ListX<T>> grouped(int groupSize) {
        return (StreamableTSeq)StreamableT.super.grouped(groupSize);
    }

    @Override
    public <K, A, D> StreamableTSeq<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return (StreamableTSeq)StreamableT.super.grouped((Function)classifier, (Collector)downstream);
    }

    @Override
    public <K> StreamableTSeq<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return (StreamableTSeq)StreamableT.super.grouped((Function)classifier);
    }

    @Override
    public StreamableTSeq<T> distinct() {
        return (StreamableTSeq)StreamableT.super.distinct();
    }

    @Override
    public StreamableTSeq<T> scanLeft(Monoid<T> monoid) {
        return (StreamableTSeq)StreamableT.super.scanLeft((Monoid)monoid);
    }

    @Override
    public <U> StreamableTSeq<U> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return (StreamableTSeq)StreamableT.super.scanLeft((Object)seed, (BiFunction)function);
    }

    @Override
    public StreamableTSeq<T> scanRight(Monoid<T> monoid) {
        return (StreamableTSeq)StreamableT.super.scanRight((Monoid)monoid);
    }

    @Override
    public <U> StreamableTSeq<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return (StreamableTSeq)StreamableT.super.scanRight((Object)identity, (BiFunction)combiner);
    }

    @Override
    public StreamableTSeq<T> sorted() {
        return (StreamableTSeq)StreamableT.super.sorted();
    }

    @Override
    public StreamableTSeq<T> sorted(Comparator<? super T> c) {
        return (StreamableTSeq)StreamableT.super.sorted((Comparator)c);
    }

    @Override
    public StreamableTSeq<T> takeWhile(Predicate<? super T> p) {
        return (StreamableTSeq)StreamableT.super.takeWhile((Predicate)p);
    }

    @Override
    public StreamableTSeq<T> dropWhile(Predicate<? super T> p) {
        return (StreamableTSeq)StreamableT.super.dropWhile((Predicate)p);
    }

    @Override
    public StreamableTSeq<T> takeUntil(Predicate<? super T> p) {
        return (StreamableTSeq)StreamableT.super.takeUntil((Predicate)p);
    }

    @Override
    public StreamableTSeq<T> dropUntil(Predicate<? super T> p) {
        return (StreamableTSeq)StreamableT.super.dropUntil((Predicate)p);
    }

    @Override
    public StreamableTSeq<T> dropRight(int num) {
        return (StreamableTSeq)StreamableT.super.dropRight(num);
    }

    @Override
    public StreamableTSeq<T> takeRight(int num) {
        return (StreamableTSeq)StreamableT.super.takeRight(num);
    }

    @Override
    public StreamableTSeq<T> skip(long num) {
        return (StreamableTSeq)StreamableT.super.skip(num);
    }

    @Override
    public StreamableTSeq<T> skipWhile(Predicate<? super T> p) {
        return (StreamableTSeq)StreamableT.super.skipWhile((Predicate)p);
    }

    @Override
    public StreamableTSeq<T> skipUntil(Predicate<? super T> p) {
        return (StreamableTSeq)StreamableT.super.skipUntil((Predicate)p);
    }

    @Override
    public StreamableTSeq<T> limit(long num) {
        return (StreamableTSeq)StreamableT.super.limit(num);
    }

    @Override
    public StreamableTSeq<T> limitWhile(Predicate<? super T> p) {
        return (StreamableTSeq)StreamableT.super.limitWhile((Predicate)p);
    }

    @Override
    public StreamableTSeq<T> limitUntil(Predicate<? super T> p) {
        return (StreamableTSeq)StreamableT.super.limitUntil((Predicate)p);
    }

    @Override
    public StreamableTSeq<T> intersperse(T value) {
        return (StreamableTSeq)StreamableT.super.intersperse((Object)value);
    }

    @Override
    public StreamableTSeq<T> reverse() {
        return (StreamableTSeq)StreamableT.super.reverse();
    }

    @Override
    public StreamableTSeq<T> shuffle() {
        return (StreamableTSeq)StreamableT.super.shuffle();
    }

    @Override
    public StreamableTSeq<T> skipLast(int num) {
        return (StreamableTSeq)StreamableT.super.skipLast(num);
    }

    @Override
    public StreamableTSeq<T> limitLast(int num) {
        return (StreamableTSeq)StreamableT.super.limitLast(num);
    }

    @Override
    public StreamableTSeq<T> onEmpty(T value) {
        return (StreamableTSeq)StreamableT.super.onEmpty((Object)value);
    }

    @Override
    public StreamableTSeq<T> onEmptyGet(Supplier<? extends T> supplier) {
        return (StreamableTSeq)StreamableT.super.onEmptyGet((Supplier)supplier);
    }

    @Override
    public <X extends Throwable> StreamableTSeq<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return (StreamableTSeq)StreamableT.super.onEmptyThrow((Supplier)supplier);
    }

    @Override
    public StreamableTSeq<T> shuffle(Random random) {
        return (StreamableTSeq)StreamableT.super.shuffle(random);
    }

    @Override
    public StreamableTSeq<T> slice(long from, long to) {
        return (StreamableTSeq)StreamableT.super.slice(from, to);
    }

    @Override
    public <U extends Comparable<? super U>> StreamableTSeq<T> sorted(Function<? super T, ? extends U> function) {
        return (StreamableTSeq)StreamableT.super.sorted((Function)function);
    }

    public int hashCode() {
        return this.run.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof StreamableTSeq) {
            return this.run.equals(((StreamableTSeq)o).run);
        }
        return false;
    }
}

