/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.Reducer;
import com.aol.cyclops.Semigroup;
import com.aol.cyclops.Semigroups;
import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.Eval;
import com.aol.cyclops.control.FluentFunctions;
import com.aol.cyclops.control.Ior;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.Maybe;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.data.collections.extensions.CollectionX;
import com.aol.cyclops.data.collections.extensions.persistent.PStackX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.types.Filterable;
import com.aol.cyclops.types.Functor;
import com.aol.cyclops.types.MonadicValue;
import com.aol.cyclops.types.MonadicValue2;
import com.aol.cyclops.types.Value;
import com.aol.cyclops.types.anyM.AnyMValue;
import com.aol.cyclops.types.applicative.ApplicativeFunctor;
import com.aol.cyclops.types.stream.reactive.ValueSubscriber;
import com.aol.cyclops.util.function.Curry;
import com.aol.cyclops.util.stream.StreamUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jooq.lambda.tuple.Tuple;
import org.reactivestreams.Publisher;

public interface Xor<ST, PT>
extends Supplier<PT>,
MonadicValue2<ST, PT>,
Functor<PT>,
Filterable<PT>,
ApplicativeFunctor<PT> {
    public static <T> Xor<Throwable, T> fromPublisher(Publisher<T> pub) {
        ValueSubscriber sub = ValueSubscriber.subscriber();
        pub.subscribe(sub);
        return sub.toXor();
    }

    public static <ST, T> Xor<ST, T> fromIterable(Iterable<T> iterable) {
        Iterator<T> it = iterable.iterator();
        return Xor.primary(it.hasNext() ? (Object)it.next() : null);
    }

    public static <ST, PT> Xor<ST, PT> secondary(ST value) {
        return new Secondary(value);
    }

    public static <ST, PT> Xor<ST, PT> primary(PT value) {
        return new Primary(value);
    }

    @Override
    default public AnyMValue<PT> anyM() {
        return AnyM.ofValue(this);
    }

    default public <R> Xor<ST, R> coflatMap(Function<? super MonadicValue<PT>, R> mapper) {
        return (Xor)MonadicValue2.super.coflatMap(mapper);
    }

    default public Xor<ST, MonadicValue<PT>> nest() {
        return this.map((T t) -> this.unit(t));
    }

    @Override
    default public Xor<ST, PT> combine(Monoid<PT> monoid, MonadicValue2<? extends ST, ? extends PT> v2) {
        return (Xor)MonadicValue2.super.combine(monoid, v2);
    }

    @Override
    default public <T> Xor<ST, T> unit(T unit) {
        return Xor.primary(unit);
    }

    @Override
    default public Optional<PT> toOptional() {
        return this.isPrimary() ? Optional.of(this.get()) : Optional.empty();
    }

    public Xor<ST, PT> filter(Predicate<? super PT> var1);

    public Xor<ST, PT> secondaryToPrimayMap(Function<? super ST, ? extends PT> var1);

    public <R> Xor<R, PT> secondaryMap(Function<? super ST, ? extends R> var1);

    @Override
    public <R> Xor<ST, R> map(Function<? super PT, ? extends R> var1);

    public Xor<ST, PT> secondaryPeek(Consumer<? super ST> var1);

    public Xor<ST, PT> peek(Consumer<? super PT> var1);

    public Xor<PT, ST> swap();

    @Override
    public Ior<ST, PT> toIor();

    @Override
    default public boolean isPresent() {
        return this.isPrimary();
    }

    @Override
    default public Xor<ST, PT> toXor() {
        return this;
    }

    @Override
    default public <ST2> Xor<ST2, PT> toXor(ST2 secondary) {
        return this.visit((? super ST s) -> Xor.secondary(secondary), (? super PT p) -> Xor.primary(p));
    }

    public static <ST, PT> Xor<ListX<PT>, ListX<ST>> sequenceSecondary(CollectionX<Xor<ST, PT>> xors) {
        return (Xor)AnyM.sequence(AnyM.listFromXor(xors.map(Xor::swap))).unwrap();
    }

    public static <ST, PT, R> Xor<?, R> accumulateSecondary(CollectionX<Xor<ST, PT>> xors, Reducer<R> reducer) {
        return Xor.sequenceSecondary(xors).map(s -> s.mapReduce(reducer));
    }

    public static <ST, PT, R> Xor<?, R> accumulateSecondary(CollectionX<Xor<ST, PT>> xors, Function<? super ST, R> mapper, Semigroup<R> reducer) {
        return Xor.sequenceSecondary(xors).map(s -> s.map(mapper).reduce(reducer.reducer()).get());
    }

    public static <ST, PT> Xor<ListX<ST>, ListX<PT>> sequencePrimary(CollectionX<Xor<ST, PT>> xors) {
        return (Xor)AnyM.sequence(AnyM.listFromXor(xors)).unwrap();
    }

    public static <ST, PT, R> Xor<?, R> accumulatePrimary(CollectionX<Xor<ST, PT>> xors, Reducer<R> reducer) {
        return Xor.sequencePrimary(xors).map(s -> s.mapReduce(reducer));
    }

    public static <ST, PT, R> Xor<?, R> accumulatePrimary(CollectionX<Xor<ST, PT>> xors, Function<? super PT, R> mapper, Semigroup<R> reducer) {
        return Xor.sequencePrimary(xors).map(s -> s.map(mapper).reduce(reducer.reducer()).get());
    }

    public static <ST, PT> Xor<?, PT> accumulatePrimary(CollectionX<Xor<ST, PT>> xors, Semigroup<PT> reducer) {
        return Xor.sequencePrimary(xors).map(s -> s.reduce(reducer.reducer()).get());
    }

    public static <ST, PT> Xor<?, ST> accumulateSecondary(CollectionX<Xor<ST, PT>> xors, Semigroup<ST> reducer) {
        return Xor.sequenceSecondary(xors).map(s -> s.reduce(reducer.reducer()).get());
    }

    public <R> R visit(Function<? super ST, ? extends R> var1, Function<? super PT, ? extends R> var2);

    default public <R1, R2> Xor<R1, R2> visitXor(Function<? super ST, ? extends R1> secondary, Function<? super PT, ? extends R2> primary) {
        if (this.isSecondary()) {
            return this.swap().map((Function)secondary).swap();
        }
        return this.map(primary);
    }

    default public <R> Xor<ST, R> patternMatch(Function<Matchable.CheckValue1<PT, R>, Matchable.CheckValue1<PT, R>> case1, Supplier<? extends R> otherwise) {
        return (Xor)ApplicativeFunctor.super.patternMatch(case1, otherwise);
    }

    public <R> Eval<R> matches(Function<Matchable.CheckValue1<ST, R>, Matchable.CheckValue1<ST, R>> var1, Function<Matchable.CheckValue1<PT, R>, Matchable.CheckValue1<PT, R>> var2, Supplier<? extends R> var3);

    @Override
    public PT get();

    public Value<ST> secondaryValue();

    public ST secondaryGet();

    public Optional<ST> secondaryToOptional();

    public ReactiveSeq<ST> secondaryToStream();

    @Override
    public <LT1, RT1> Xor<LT1, RT1> flatMap(Function<? super PT, ? extends MonadicValue2<? extends LT1, ? extends RT1>> var1);

    public <LT1, RT1> Xor<LT1, RT1> secondaryFlatMap(Function<? super ST, ? extends Xor<LT1, RT1>> var1);

    public Xor<ST, PT> secondaryToPrimayFlatMap(Function<? super ST, ? extends Xor<ST, PT>> var1);

    public void peek(Consumer<? super ST> var1, Consumer<? super PT> var2);

    public boolean isPrimary();

    public boolean isSecondary();

    public <T2, R> Xor<ST, R> ap(Value<? extends T2> var1, BiFunction<? super PT, ? super T2, ? extends R> var2);

    default public Xor<PStackX<ST>, PT> list() {
        return this.secondaryMap(xva$0 -> PStackX.of(xva$0));
    }

    default public <T2, R> Xor<PStackX<ST>, R> apToList(Xor<ST, ? extends T2> app, BiFunction<? super PT, ? super T2, ? extends R> fn) {
        return this.list().ap(app.list(), Semigroups.collectionXConcat(), fn);
    }

    default public <T2, R> Xor<ST, R> ap(Xor<? extends ST, ? extends T2> app, BinaryOperator<ST> semigroup, BiFunction<? super PT, ? super T2, ? extends R> fn) {
        return this.visit((? super ST secondary) -> app.visit((? super ST s2) -> Xor.secondary(semigroup.apply(s2, secondary)), (? super PT p2) -> Xor.secondary(secondary)), (? super PT primary) -> app.visit((? super ST s2) -> Xor.secondary(s2), (? super PT p2) -> Xor.primary(fn.apply((Object)primary, (Object)p2))));
    }

    default public <T2, R> Xor<ST, R> zip(Iterable<? extends T2> app, BiFunction<? super PT, ? super T2, ? extends R> fn) {
        return this.map((T v) -> Tuple.tuple((Object)v, Curry.curry2(fn).apply(v))).flatMap((T tuple) -> Xor.fromIterable(app).visit((? super T i) -> Xor.primary(((Function)tuple.v2).apply(i)), () -> Xor.secondary(null)));
    }

    default public <T2, R> Xor<ST, R> zip(BiFunction<? super PT, ? super T2, ? extends R> fn, Publisher<? extends T2> app) {
        return this.map((T v) -> Tuple.tuple((Object)v, Curry.curry2(fn).apply(v))).flatMap((T tuple) -> Xor.fromPublisher(app).visit((? super T i) -> Xor.primary(((Function)tuple.v2).apply(i)), () -> Xor.secondary(null)));
    }

    default public <U> Xor<ST, U> ofType(Class<? extends U> type) {
        return (Xor)Filterable.super.ofType(type);
    }

    default public Xor<ST, PT> filterNot(Predicate<? super PT> fn) {
        return (Xor)Filterable.super.filterNot(fn);
    }

    default public Xor<ST, PT> notNull() {
        return (Xor)Filterable.super.notNull();
    }

    default public <U> Xor<ST, U> cast(Class<? extends U> type) {
        return (Xor)ApplicativeFunctor.super.cast(type);
    }

    default public <R> Xor<ST, R> trampoline(Function<? super PT, ? extends Trampoline<? extends R>> mapper) {
        return (Xor)ApplicativeFunctor.super.trampoline(mapper);
    }

    public static class Secondary<ST, PT>
    implements Xor<ST, PT> {
        private final ST value;

        @Override
        public boolean isSecondary() {
            return true;
        }

        @Override
        public boolean isPrimary() {
            return false;
        }

        @Override
        public <R> Eval<R> matches(Function<Matchable.CheckValue1<ST, R>, Matchable.CheckValue1<ST, R>> secondary, Function<Matchable.CheckValue1<PT, R>, Matchable.CheckValue1<PT, R>> primary, Supplier<? extends R> otherwise) {
            Matchable.MTuple1 mt1 = () -> Tuple.tuple(this.value);
            return mt1.matches(secondary, otherwise);
        }

        @Override
        public Xor<ST, PT> secondaryToPrimayMap(Function<? super ST, ? extends PT> fn) {
            return new Primary(fn.apply(this.value));
        }

        @Override
        public <R> Xor<R, PT> secondaryMap(Function<? super ST, ? extends R> fn) {
            return new Secondary<R, PT>(fn.apply(this.value));
        }

        @Override
        public <R> Xor<ST, R> map(Function<? super PT, ? extends R> fn) {
            return this;
        }

        @Override
        public Xor<ST, PT> secondaryPeek(Consumer<? super ST> action) {
            return this.secondaryMap(FluentFunctions.expression(action));
        }

        @Override
        public Xor<ST, PT> peek(Consumer<? super PT> action) {
            return this;
        }

        @Override
        public Xor<ST, PT> filter(Predicate<? super PT> test) {
            return this;
        }

        @Override
        public Xor<PT, ST> swap() {
            return new Primary(this.value);
        }

        @Override
        public PT get() {
            throw new NoSuchElementException();
        }

        @Override
        public ST secondaryGet() {
            return this.value;
        }

        @Override
        public Optional<ST> secondaryToOptional() {
            return Optional.ofNullable(this.value);
        }

        @Override
        public ReactiveSeq<ST> secondaryToStream() {
            return ReactiveSeq.fromStream(StreamUtils.optionalToStream(this.secondaryToOptional()));
        }

        @Override
        public <LT1, RT1> Xor<LT1, RT1> flatMap(Function<? super PT, ? extends MonadicValue2<? extends LT1, ? extends RT1>> mapper) {
            return this;
        }

        @Override
        public <LT1, RT1> Xor<LT1, RT1> secondaryFlatMap(Function<? super ST, ? extends Xor<LT1, RT1>> mapper) {
            return mapper.apply(this.value);
        }

        @Override
        public Xor<ST, PT> secondaryToPrimayFlatMap(Function<? super ST, ? extends Xor<ST, PT>> fn) {
            return fn.apply(this.value);
        }

        @Override
        public void peek(Consumer<? super ST> stAction, Consumer<? super PT> ptAction) {
            stAction.accept(this.value);
        }

        @Override
        public <R> R visit(Function<? super ST, ? extends R> secondary, Function<? super PT, ? extends R> primary) {
            return secondary.apply(this.value);
        }

        @Override
        public Maybe<PT> toMaybe() {
            return Maybe.none();
        }

        @Override
        public Optional<PT> toOptional() {
            return Optional.empty();
        }

        @Override
        public Value<ST> secondaryValue() {
            return Value.of(() -> this.value);
        }

        public String toString() {
            return this.mkString();
        }

        @Override
        public String mkString() {
            return "Xor.secondary[" + this.value + "]";
        }

        @Override
        public ListX<ST> unapply() {
            return ListX.of(new Object[]{this.value});
        }

        @Override
        public Ior<ST, PT> toIor() {
            return Ior.secondary(this.value);
        }

        @Override
        public <T2, R> Xor<ST, R> ap(Value<? extends T2> app, BiFunction<? super PT, ? super T2, ? extends R> fn) {
            return this;
        }

        private Secondary(ST value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Secondary)) {
                return false;
            }
            Secondary other = (Secondary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ST this$value = this.value;
            ST other$value = other.value;
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Secondary;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ST $value = this.value;
            result = result * 59 + ($value == null ? 0 : $value.hashCode());
            return result;
        }
    }

    public static class Primary<ST, PT>
    implements Xor<ST, PT> {
        private final PT value;

        @Override
        public Xor<ST, PT> secondaryToPrimayMap(Function<? super ST, ? extends PT> fn) {
            return this;
        }

        @Override
        public <R> Xor<R, PT> secondaryMap(Function<? super ST, ? extends R> fn) {
            return this;
        }

        @Override
        public <R> Xor<ST, R> map(Function<? super PT, ? extends R> fn) {
            return new Primary<ST, R>(fn.apply(this.value));
        }

        @Override
        public Xor<ST, PT> secondaryPeek(Consumer<? super ST> action) {
            return this;
        }

        @Override
        public Xor<ST, PT> peek(Consumer<? super PT> action) {
            action.accept(this.value);
            return this;
        }

        @Override
        public Xor<ST, PT> filter(Predicate<? super PT> test) {
            if (test.test(this.value)) {
                return this;
            }
            return Xor.secondary(null);
        }

        @Override
        public Xor<PT, ST> swap() {
            return new Secondary(this.value);
        }

        @Override
        public PT get() {
            return this.value;
        }

        @Override
        public ST secondaryGet() {
            return null;
        }

        @Override
        public Optional<ST> secondaryToOptional() {
            return Optional.empty();
        }

        @Override
        public ReactiveSeq<ST> secondaryToStream() {
            return ReactiveSeq.empty();
        }

        @Override
        public <LT1, RT1> Xor<LT1, RT1> flatMap(Function<? super PT, ? extends MonadicValue2<? extends LT1, ? extends RT1>> mapper) {
            return mapper.apply(this.value).toXor();
        }

        @Override
        public <LT1, RT1> Xor<LT1, RT1> secondaryFlatMap(Function<? super ST, ? extends Xor<LT1, RT1>> mapper) {
            return this;
        }

        @Override
        public Xor<ST, PT> secondaryToPrimayFlatMap(Function<? super ST, ? extends Xor<ST, PT>> fn) {
            return this;
        }

        @Override
        public void peek(Consumer<? super ST> stAction, Consumer<? super PT> ptAction) {
            ptAction.accept(this.value);
        }

        @Override
        public boolean isPrimary() {
            return true;
        }

        @Override
        public boolean isSecondary() {
            return false;
        }

        @Override
        public Value<ST> secondaryValue() {
            return Value.of(() -> null);
        }

        public String toString() {
            return this.mkString();
        }

        @Override
        public String mkString() {
            return "Xor.primary[" + this.value + "]";
        }

        @Override
        public Ior<ST, PT> toIor() {
            return Ior.primary(this.value);
        }

        @Override
        public <R> R visit(Function<? super ST, ? extends R> secondary, Function<? super PT, ? extends R> primary) {
            return primary.apply(this.value);
        }

        @Override
        public <R> Eval<R> matches(Function<Matchable.CheckValue1<ST, R>, Matchable.CheckValue1<ST, R>> secondary, Function<Matchable.CheckValue1<PT, R>, Matchable.CheckValue1<PT, R>> primary, Supplier<? extends R> otherwise) {
            Matchable.MTuple1 mt1 = () -> Tuple.tuple(this.value);
            return mt1.matches(primary, otherwise);
        }

        @Override
        public <T2, R> Xor<ST, R> ap(Value<? extends T2> app, BiFunction<? super PT, ? super T2, ? extends R> fn) {
            return app.toXor().visit((? super ST s) -> Xor.secondary(null), (? super PT f) -> Xor.primary(fn.apply((PT)this.get(), (Object)app.get())));
        }

        private Primary(PT value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Primary)) {
                return false;
            }
            Primary other = (Primary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PT this$value = this.value;
            PT other$value = other.value;
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Primary;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PT $value = this.value;
            result = result * 59 + ($value == null ? 0 : $value.hashCode());
            return result;
        }
    }
}

